/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.xml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.datanucleus.ClassConstants;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.xml.AbstractXmlMetaDataHandler;
import org.datanucleus.metadata.xml.PersistenceXmlMetaDataHandler;
import org.datanucleus.metadata.xml.XmlMetaDataEntityResolver;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlMetaDataParser
extends DefaultHandler {
    protected XmlMetaDataEntityResolver entityResolver = null;
    protected final MetaDataManager mgr;
    protected final PluginManager pluginMgr;
    protected final boolean validate;
    protected final boolean namespaceAware;
    private final SAXParser parser;

    public XmlMetaDataParser(MetaDataManager mgr, PluginManager pluginMgr, boolean validate, boolean namespaceAware) {
        this.mgr = mgr;
        this.pluginMgr = pluginMgr;
        this.validate = validate;
        this.namespaceAware = namespaceAware;
        this.entityResolver = new XmlMetaDataEntityResolver(pluginMgr);
        this.parser = this.createSAXParser();
    }

    private SAXParser createSAXParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(this.validate);
        factory.setNamespaceAware(this.namespaceAware);
        if (this.validate) {
            try {
                Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.entityResolver.getRegisteredSchemas());
                if (schema != null) {
                    try {
                        factory.setSchema(schema);
                    }
                    catch (UnsupportedOperationException e) {
                        NucleusLogger.METADATA.info(e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                NucleusLogger.METADATA.info(e.getMessage());
            }
            try {
                factory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.info(e.getMessage());
            }
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (Exception e) {
            NucleusLogger.METADATA.warn(e.getMessage());
        }
        return saxParser;
    }

    public MetaData parseXmlMetaDataURL(URL url, String handlerName) {
        if (url == null) {
            String msg = Localiser.msg("044031");
            NucleusLogger.METADATA.error(msg);
            throw new NucleusException(msg);
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(url.getFile()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(Localiser.msg("044032", url.toString()));
            throw new NucleusException(Localiser.msg("044032", url.toString()));
        }
        return this.parseXmlMetaDataStream(in, url.toString(), handlerName);
    }

    public MetaData parseXmlMetaDataFile(String fileName, String handlerName) {
        InputStream in = null;
        try {
            in = new URL(fileName).openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(StringUtils.getFileForFilename(fileName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            NucleusLogger.METADATA.error(Localiser.msg("044032", fileName));
            throw new NucleusException(Localiser.msg("044032", fileName));
        }
        return this.parseXmlMetaDataStream(in, fileName, handlerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData parseXmlMetaDataStream(InputStream in, String filename, String handlerName) {
        if (in == null) {
            throw new NullPointerException("input stream is null");
        }
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug(Localiser.msg("044030", filename, handlerName, this.validate ? "true" : "false"));
        }
        try {
            SAXParser sAXParser = this.parser;
            synchronized (sAXParser) {
                try {
                    DefaultHandler handler = null;
                    try {
                        this.parser.getXMLReader().setEntityResolver(this.entityResolver);
                        if ("persistence".equalsIgnoreCase(handlerName)) {
                            handler = new PersistenceXmlMetaDataHandler(this.mgr, filename, this.entityResolver);
                        } else {
                            Class[] argTypes = new Class[]{ClassConstants.METADATA_MANAGER, ClassConstants.JAVA_LANG_STRING, EntityResolver.class};
                            Object[] argValues = new Object[]{this.mgr, filename, this.entityResolver};
                            handler = (DefaultHandler)this.pluginMgr.createExecutableExtension("org.datanucleus.metadata_handler", "name", handlerName, "class-name", argTypes, argValues);
                            if (handler == null) {
                                throw new NucleusUserException(Localiser.msg("044028", handlerName)).setFatal();
                            }
                        }
                    }
                    catch (Exception e) {
                        String msg = Localiser.msg("044029", handlerName, e.getMessage());
                        throw new NucleusException(msg, e);
                    }
                    ((AbstractXmlMetaDataHandler)handler).setValidate(this.validate);
                    this.parser.parse(in, handler);
                    MetaData metaData = ((AbstractXmlMetaDataHandler)handler).getMetaData();
                    return metaData;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (NucleusException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Exception cause = e;
                        if (e instanceof SAXException) {
                            cause = ((SAXException)e).getException();
                        }
                        cause = e.getCause() == null ? cause : e.getCause();
                        NucleusLogger.METADATA.error(Localiser.msg("044040", filename, cause));
                        if (cause instanceof InvalidMetaDataException) {
                            throw (InvalidMetaDataException)cause;
                        }
                        throw new NucleusException(Localiser.msg("044033", e), cause);
                    }
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }
}

