/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;

public class RowCount {
    public static void main(Configuration conf, String[] args) throws Exception {
        Options opts = RowCount.createOptions();
        CommandLine cli = new DefaultParser().parse(opts, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("count", opts);
            return;
        }
        boolean ignoreExtension = cli.hasOption("ignoreExtension");
        String[] files = cli.getArgs();
        int bad = 0;
        for (String root : files) {
            Path rootPath = new Path(root);
            FileSystem fs = rootPath.getFileSystem(conf);
            RemoteIterator itr = fs.listFiles(rootPath, true);
            while (itr.hasNext()) {
                LocatedFileStatus status = (LocatedFileStatus)itr.next();
                if (!status.isFile() || !ignoreExtension && !status.getPath().getName().endsWith(".orc")) continue;
                Path filename = status.getPath();
                try {
                    Reader reader = OrcFile.createReader((Path)filename, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                    try {
                        System.out.println(String.format("%s %d", filename.toString(), reader.getNumberOfRows()));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException ioe) {
                    ++bad;
                    System.err.println("Failed to read " + String.valueOf(filename));
                }
            }
        }
        if (bad > 0) {
            System.exit(1);
        }
    }

    public static void main(String[] args) throws Exception {
        RowCount.main(new Configuration(), args);
    }

    private static Options createOptions() {
        Options result = new Options();
        result.addOption(Option.builder((String)"i").longOpt("ignoreExtension").desc("Ignore ORC file extension").build());
        result.addOption(Option.builder((String)"h").longOpt("help").desc("Print help message").build());
        return result;
    }
}

