/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompactionRequest
implements TBase<CompactionRequest, _Fields>,
Serializable,
Cloneable,
Comparable<CompactionRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("CompactionRequest");
    private static final TField DBNAME_FIELD_DESC = new TField("dbname", 11, 1);
    private static final TField TABLENAME_FIELD_DESC = new TField("tablename", 11, 2);
    private static final TField PARTITIONNAME_FIELD_DESC = new TField("partitionname", 11, 3);
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 4);
    private static final TField RUNAS_FIELD_DESC = new TField("runas", 11, 5);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 6);
    private static final TField INITIATOR_ID_FIELD_DESC = new TField("initiatorId", 11, 7);
    private static final TField INITIATOR_VERSION_FIELD_DESC = new TField("initiatorVersion", 11, 8);
    private static final TField POOL_NAME_FIELD_DESC = new TField("poolName", 11, 9);
    private static final TField NUMBER_OF_BUCKETS_FIELD_DESC = new TField("numberOfBuckets", 8, 10);
    private static final TField ORDER_BY_CLAUSE_FIELD_DESC = new TField("orderByClause", 11, 11);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new CompactionRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new CompactionRequestTupleSchemeFactory();
    @Nullable
    private String dbname;
    @Nullable
    private String tablename;
    @Nullable
    private String partitionname;
    @Nullable
    private CompactionType type;
    @Nullable
    private String runas;
    @Nullable
    private Map<String, String> properties;
    @Nullable
    private String initiatorId;
    @Nullable
    private String initiatorVersion;
    @Nullable
    private String poolName;
    private int numberOfBuckets;
    @Nullable
    private String orderByClause;
    private static final int __NUMBEROFBUCKETS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.PARTITIONNAME, _Fields.RUNAS, _Fields.PROPERTIES, _Fields.INITIATOR_ID, _Fields.INITIATOR_VERSION, _Fields.POOL_NAME, _Fields.NUMBER_OF_BUCKETS, _Fields.ORDER_BY_CLAUSE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public CompactionRequest() {
    }

    public CompactionRequest(String dbname, String tablename, CompactionType type) {
        this();
        this.dbname = dbname;
        this.tablename = tablename;
        this.type = type;
    }

    public CompactionRequest(CompactionRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDbname()) {
            this.dbname = other.dbname;
        }
        if (other.isSetTablename()) {
            this.tablename = other.tablename;
        }
        if (other.isSetPartitionname()) {
            this.partitionname = other.partitionname;
        }
        if (other.isSetType()) {
            this.type = other.type;
        }
        if (other.isSetRunas()) {
            this.runas = other.runas;
        }
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>(other.properties);
            this.properties = __this__properties;
        }
        if (other.isSetInitiatorId()) {
            this.initiatorId = other.initiatorId;
        }
        if (other.isSetInitiatorVersion()) {
            this.initiatorVersion = other.initiatorVersion;
        }
        if (other.isSetPoolName()) {
            this.poolName = other.poolName;
        }
        this.numberOfBuckets = other.numberOfBuckets;
        if (other.isSetOrderByClause()) {
            this.orderByClause = other.orderByClause;
        }
    }

    public CompactionRequest deepCopy() {
        return new CompactionRequest(this);
    }

    public void clear() {
        this.dbname = null;
        this.tablename = null;
        this.partitionname = null;
        this.type = null;
        this.runas = null;
        this.properties = null;
        this.initiatorId = null;
        this.initiatorVersion = null;
        this.poolName = null;
        this.setNumberOfBucketsIsSet(false);
        this.numberOfBuckets = 0;
        this.orderByClause = null;
    }

    @Nullable
    public String getDbname() {
        return this.dbname;
    }

    public void setDbname(@Nullable String dbname) {
        this.dbname = dbname;
    }

    public void unsetDbname() {
        this.dbname = null;
    }

    public boolean isSetDbname() {
        return this.dbname != null;
    }

    public void setDbnameIsSet(boolean value) {
        if (!value) {
            this.dbname = null;
        }
    }

    @Nullable
    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(@Nullable String tablename) {
        this.tablename = tablename;
    }

    public void unsetTablename() {
        this.tablename = null;
    }

    public boolean isSetTablename() {
        return this.tablename != null;
    }

    public void setTablenameIsSet(boolean value) {
        if (!value) {
            this.tablename = null;
        }
    }

    @Nullable
    public String getPartitionname() {
        return this.partitionname;
    }

    public void setPartitionname(@Nullable String partitionname) {
        this.partitionname = partitionname;
    }

    public void unsetPartitionname() {
        this.partitionname = null;
    }

    public boolean isSetPartitionname() {
        return this.partitionname != null;
    }

    public void setPartitionnameIsSet(boolean value) {
        if (!value) {
            this.partitionname = null;
        }
    }

    @Nullable
    public CompactionType getType() {
        return this.type;
    }

    public void setType(@Nullable CompactionType type) {
        this.type = type;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    @Nullable
    public String getRunas() {
        return this.runas;
    }

    public void setRunas(@Nullable String runas) {
        this.runas = runas;
    }

    public void unsetRunas() {
        this.runas = null;
    }

    public boolean isSetRunas() {
        return this.runas != null;
    }

    public void setRunasIsSet(boolean value) {
        if (!value) {
            this.runas = null;
        }
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    @Nullable
    public String getInitiatorId() {
        return this.initiatorId;
    }

    public void setInitiatorId(@Nullable String initiatorId) {
        this.initiatorId = initiatorId;
    }

    public void unsetInitiatorId() {
        this.initiatorId = null;
    }

    public boolean isSetInitiatorId() {
        return this.initiatorId != null;
    }

    public void setInitiatorIdIsSet(boolean value) {
        if (!value) {
            this.initiatorId = null;
        }
    }

    @Nullable
    public String getInitiatorVersion() {
        return this.initiatorVersion;
    }

    public void setInitiatorVersion(@Nullable String initiatorVersion) {
        this.initiatorVersion = initiatorVersion;
    }

    public void unsetInitiatorVersion() {
        this.initiatorVersion = null;
    }

    public boolean isSetInitiatorVersion() {
        return this.initiatorVersion != null;
    }

    public void setInitiatorVersionIsSet(boolean value) {
        if (!value) {
            this.initiatorVersion = null;
        }
    }

    @Nullable
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(@Nullable String poolName) {
        this.poolName = poolName;
    }

    public void unsetPoolName() {
        this.poolName = null;
    }

    public boolean isSetPoolName() {
        return this.poolName != null;
    }

    public void setPoolNameIsSet(boolean value) {
        if (!value) {
            this.poolName = null;
        }
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public void setNumberOfBuckets(int numberOfBuckets) {
        this.numberOfBuckets = numberOfBuckets;
        this.setNumberOfBucketsIsSet(true);
    }

    public void unsetNumberOfBuckets() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetNumberOfBuckets() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setNumberOfBucketsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(@Nullable String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public void unsetOrderByClause() {
        this.orderByClause = null;
    }

    public boolean isSetOrderByClause() {
        return this.orderByClause != null;
    }

    public void setOrderByClauseIsSet(boolean value) {
        if (!value) {
            this.orderByClause = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetDbname();
                    break;
                }
                this.setDbname((String)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetTablename();
                    break;
                }
                this.setTablename((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetPartitionname();
                    break;
                }
                this.setPartitionname((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((CompactionType)((Object)value));
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetRunas();
                    break;
                }
                this.setRunas((String)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetInitiatorId();
                    break;
                }
                this.setInitiatorId((String)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetInitiatorVersion();
                    break;
                }
                this.setInitiatorVersion((String)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetPoolName();
                    break;
                }
                this.setPoolName((String)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetNumberOfBuckets();
                    break;
                }
                this.setNumberOfBuckets((Integer)value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.unsetOrderByClause();
                    break;
                }
                this.setOrderByClause((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.getDbname();
            }
            case 1: {
                return this.getTablename();
            }
            case 2: {
                return this.getPartitionname();
            }
            case 3: {
                return this.getType();
            }
            case 4: {
                return this.getRunas();
            }
            case 5: {
                return this.getProperties();
            }
            case 6: {
                return this.getInitiatorId();
            }
            case 7: {
                return this.getInitiatorVersion();
            }
            case 8: {
                return this.getPoolName();
            }
            case 9: {
                return this.getNumberOfBuckets();
            }
            case 10: {
                return this.getOrderByClause();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetDbname();
            }
            case 1: {
                return this.isSetTablename();
            }
            case 2: {
                return this.isSetPartitionname();
            }
            case 3: {
                return this.isSetType();
            }
            case 4: {
                return this.isSetRunas();
            }
            case 5: {
                return this.isSetProperties();
            }
            case 6: {
                return this.isSetInitiatorId();
            }
            case 7: {
                return this.isSetInitiatorVersion();
            }
            case 8: {
                return this.isSetPoolName();
            }
            case 9: {
                return this.isSetNumberOfBuckets();
            }
            case 10: {
                return this.isSetOrderByClause();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof CompactionRequest) {
            return this.equals((CompactionRequest)that);
        }
        return false;
    }

    public boolean equals(CompactionRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_dbname = this.isSetDbname();
        boolean that_present_dbname = that.isSetDbname();
        if (this_present_dbname || that_present_dbname) {
            if (!this_present_dbname || !that_present_dbname) {
                return false;
            }
            if (!this.dbname.equals(that.dbname)) {
                return false;
            }
        }
        boolean this_present_tablename = this.isSetTablename();
        boolean that_present_tablename = that.isSetTablename();
        if (this_present_tablename || that_present_tablename) {
            if (!this_present_tablename || !that_present_tablename) {
                return false;
            }
            if (!this.tablename.equals(that.tablename)) {
                return false;
            }
        }
        boolean this_present_partitionname = this.isSetPartitionname();
        boolean that_present_partitionname = that.isSetPartitionname();
        if (this_present_partitionname || that_present_partitionname) {
            if (!this_present_partitionname || !that_present_partitionname) {
                return false;
            }
            if (!this.partitionname.equals(that.partitionname)) {
                return false;
            }
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_runas = this.isSetRunas();
        boolean that_present_runas = that.isSetRunas();
        if (this_present_runas || that_present_runas) {
            if (!this_present_runas || !that_present_runas) {
                return false;
            }
            if (!this.runas.equals(that.runas)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        boolean this_present_initiatorId = this.isSetInitiatorId();
        boolean that_present_initiatorId = that.isSetInitiatorId();
        if (this_present_initiatorId || that_present_initiatorId) {
            if (!this_present_initiatorId || !that_present_initiatorId) {
                return false;
            }
            if (!this.initiatorId.equals(that.initiatorId)) {
                return false;
            }
        }
        boolean this_present_initiatorVersion = this.isSetInitiatorVersion();
        boolean that_present_initiatorVersion = that.isSetInitiatorVersion();
        if (this_present_initiatorVersion || that_present_initiatorVersion) {
            if (!this_present_initiatorVersion || !that_present_initiatorVersion) {
                return false;
            }
            if (!this.initiatorVersion.equals(that.initiatorVersion)) {
                return false;
            }
        }
        boolean this_present_poolName = this.isSetPoolName();
        boolean that_present_poolName = that.isSetPoolName();
        if (this_present_poolName || that_present_poolName) {
            if (!this_present_poolName || !that_present_poolName) {
                return false;
            }
            if (!this.poolName.equals(that.poolName)) {
                return false;
            }
        }
        boolean this_present_numberOfBuckets = this.isSetNumberOfBuckets();
        boolean that_present_numberOfBuckets = that.isSetNumberOfBuckets();
        if (this_present_numberOfBuckets || that_present_numberOfBuckets) {
            if (!this_present_numberOfBuckets || !that_present_numberOfBuckets) {
                return false;
            }
            if (this.numberOfBuckets != that.numberOfBuckets) {
                return false;
            }
        }
        boolean this_present_orderByClause = this.isSetOrderByClause();
        boolean that_present_orderByClause = that.isSetOrderByClause();
        if (this_present_orderByClause || that_present_orderByClause) {
            if (!this_present_orderByClause || !that_present_orderByClause) {
                return false;
            }
            if (!this.orderByClause.equals(that.orderByClause)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDbname() ? 131071 : 524287);
        if (this.isSetDbname()) {
            hashCode = hashCode * 8191 + this.dbname.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTablename() ? 131071 : 524287);
        if (this.isSetTablename()) {
            hashCode = hashCode * 8191 + this.tablename.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionname() ? 131071 : 524287);
        if (this.isSetPartitionname()) {
            hashCode = hashCode * 8191 + this.partitionname.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetRunas() ? 131071 : 524287);
        if (this.isSetRunas()) {
            hashCode = hashCode * 8191 + this.runas.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProperties() ? 131071 : 524287);
        if (this.isSetProperties()) {
            hashCode = hashCode * 8191 + this.properties.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetInitiatorId() ? 131071 : 524287);
        if (this.isSetInitiatorId()) {
            hashCode = hashCode * 8191 + this.initiatorId.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetInitiatorVersion() ? 131071 : 524287);
        if (this.isSetInitiatorVersion()) {
            hashCode = hashCode * 8191 + this.initiatorVersion.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPoolName() ? 131071 : 524287);
        if (this.isSetPoolName()) {
            hashCode = hashCode * 8191 + this.poolName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetNumberOfBuckets() ? 131071 : 524287);
        if (this.isSetNumberOfBuckets()) {
            hashCode = hashCode * 8191 + this.numberOfBuckets;
        }
        hashCode = hashCode * 8191 + (this.isSetOrderByClause() ? 131071 : 524287);
        if (this.isSetOrderByClause()) {
            hashCode = hashCode * 8191 + this.orderByClause.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(CompactionRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDbname(), other.isSetDbname());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbname() && (lastComparison = TBaseHelper.compareTo((String)this.dbname, (String)other.dbname)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTablename(), other.isSetTablename());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTablename() && (lastComparison = TBaseHelper.compareTo((String)this.tablename, (String)other.tablename)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionname(), other.isSetPartitionname());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionname() && (lastComparison = TBaseHelper.compareTo((String)this.partitionname, (String)other.partitionname)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRunas(), other.isSetRunas());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRunas() && (lastComparison = TBaseHelper.compareTo((String)this.runas, (String)other.runas)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProperties(), other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo(this.properties, other.properties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetInitiatorId(), other.isSetInitiatorId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInitiatorId() && (lastComparison = TBaseHelper.compareTo((String)this.initiatorId, (String)other.initiatorId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetInitiatorVersion(), other.isSetInitiatorVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInitiatorVersion() && (lastComparison = TBaseHelper.compareTo((String)this.initiatorVersion, (String)other.initiatorVersion)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPoolName(), other.isSetPoolName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPoolName() && (lastComparison = TBaseHelper.compareTo((String)this.poolName, (String)other.poolName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumberOfBuckets(), other.isSetNumberOfBuckets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumberOfBuckets() && (lastComparison = TBaseHelper.compareTo((int)this.numberOfBuckets, (int)other.numberOfBuckets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOrderByClause(), other.isSetOrderByClause());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrderByClause() && (lastComparison = TBaseHelper.compareTo((String)this.orderByClause, (String)other.orderByClause)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        CompactionRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        CompactionRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CompactionRequest(");
        boolean first = true;
        sb.append("dbname:");
        if (this.dbname == null) {
            sb.append("null");
        } else {
            sb.append(this.dbname);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tablename:");
        if (this.tablename == null) {
            sb.append("null");
        } else {
            sb.append(this.tablename);
        }
        first = false;
        if (this.isSetPartitionname()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partitionname:");
            if (this.partitionname == null) {
                sb.append("null");
            } else {
                sb.append(this.partitionname);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (this.isSetRunas()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("runas:");
            if (this.runas == null) {
                sb.append("null");
            } else {
                sb.append(this.runas);
            }
            first = false;
        }
        if (this.isSetProperties()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("properties:");
            if (this.properties == null) {
                sb.append("null");
            } else {
                sb.append(this.properties);
            }
            first = false;
        }
        if (this.isSetInitiatorId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("initiatorId:");
            if (this.initiatorId == null) {
                sb.append("null");
            } else {
                sb.append(this.initiatorId);
            }
            first = false;
        }
        if (this.isSetInitiatorVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("initiatorVersion:");
            if (this.initiatorVersion == null) {
                sb.append("null");
            } else {
                sb.append(this.initiatorVersion);
            }
            first = false;
        }
        if (this.isSetPoolName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("poolName:");
            if (this.poolName == null) {
                sb.append("null");
            } else {
                sb.append(this.poolName);
            }
            first = false;
        }
        if (this.isSetNumberOfBuckets()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("numberOfBuckets:");
            sb.append(this.numberOfBuckets);
            first = false;
        }
        if (this.isSetOrderByClause()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("orderByClause:");
            if (this.orderByClause == null) {
                sb.append("null");
            } else {
                sb.append(this.orderByClause);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetDbname()) {
            throw new TProtocolException("Required field 'dbname' is unset! Struct:" + this.toString());
        }
        if (!this.isSetTablename()) {
            throw new TProtocolException("Required field 'tablename' is unset! Struct:" + this.toString());
        }
        if (!this.isSetType()) {
            throw new TProtocolException("Required field 'type' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DBNAME, new FieldMetaData("dbname", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLENAME, new FieldMetaData("tablename", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTITIONNAME, new FieldMetaData("partitionname", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, CompactionType.class)));
        tmpMap.put(_Fields.RUNAS, new FieldMetaData("runas", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.INITIATOR_ID, new FieldMetaData("initiatorId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.INITIATOR_VERSION, new FieldMetaData("initiatorVersion", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.POOL_NAME, new FieldMetaData("poolName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.NUMBER_OF_BUCKETS, new FieldMetaData("numberOfBuckets", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.ORDER_BY_CLAUSE, new FieldMetaData("orderByClause", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(CompactionRequest.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DBNAME(1, "dbname"),
        TABLENAME(2, "tablename"),
        PARTITIONNAME(3, "partitionname"),
        TYPE(4, "type"),
        RUNAS(5, "runas"),
        PROPERTIES(6, "properties"),
        INITIATOR_ID(7, "initiatorId"),
        INITIATOR_VERSION(8, "initiatorVersion"),
        POOL_NAME(9, "poolName"),
        NUMBER_OF_BUCKETS(10, "numberOfBuckets"),
        ORDER_BY_CLAUSE(11, "orderByClause");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DBNAME;
                }
                case 2: {
                    return TABLENAME;
                }
                case 3: {
                    return PARTITIONNAME;
                }
                case 4: {
                    return TYPE;
                }
                case 5: {
                    return RUNAS;
                }
                case 6: {
                    return PROPERTIES;
                }
                case 7: {
                    return INITIATOR_ID;
                }
                case 8: {
                    return INITIATOR_VERSION;
                }
                case 9: {
                    return POOL_NAME;
                }
                case 10: {
                    return NUMBER_OF_BUCKETS;
                }
                case 11: {
                    return ORDER_BY_CLAUSE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class CompactionRequestStandardSchemeFactory
    implements SchemeFactory {
        private CompactionRequestStandardSchemeFactory() {
        }

        public CompactionRequestStandardScheme getScheme() {
            return new CompactionRequestStandardScheme();
        }
    }

    private static class CompactionRequestTupleSchemeFactory
    implements SchemeFactory {
        private CompactionRequestTupleSchemeFactory() {
        }

        public CompactionRequestTupleScheme getScheme() {
            return new CompactionRequestTupleScheme();
        }
    }

    private static class CompactionRequestTupleScheme
    extends TupleScheme<CompactionRequest> {
        private CompactionRequestTupleScheme() {
        }

        public void write(TProtocol prot, CompactionRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.dbname);
            oprot.writeString(struct.tablename);
            oprot.writeI32(struct.type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetPartitionname()) {
                optionals.set(0);
            }
            if (struct.isSetRunas()) {
                optionals.set(1);
            }
            if (struct.isSetProperties()) {
                optionals.set(2);
            }
            if (struct.isSetInitiatorId()) {
                optionals.set(3);
            }
            if (struct.isSetInitiatorVersion()) {
                optionals.set(4);
            }
            if (struct.isSetPoolName()) {
                optionals.set(5);
            }
            if (struct.isSetNumberOfBuckets()) {
                optionals.set(6);
            }
            if (struct.isSetOrderByClause()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetPartitionname()) {
                oprot.writeString(struct.partitionname);
            }
            if (struct.isSetRunas()) {
                oprot.writeString(struct.runas);
            }
            if (struct.isSetProperties()) {
                oprot.writeI32(struct.properties.size());
                for (Map.Entry<String, String> _iter939 : struct.properties.entrySet()) {
                    oprot.writeString(_iter939.getKey());
                    oprot.writeString(_iter939.getValue());
                }
            }
            if (struct.isSetInitiatorId()) {
                oprot.writeString(struct.initiatorId);
            }
            if (struct.isSetInitiatorVersion()) {
                oprot.writeString(struct.initiatorVersion);
            }
            if (struct.isSetPoolName()) {
                oprot.writeString(struct.poolName);
            }
            if (struct.isSetNumberOfBuckets()) {
                oprot.writeI32(struct.numberOfBuckets);
            }
            if (struct.isSetOrderByClause()) {
                oprot.writeString(struct.orderByClause);
            }
        }

        public void read(TProtocol prot, CompactionRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dbname = iprot.readString();
            struct.setDbnameIsSet(true);
            struct.tablename = iprot.readString();
            struct.setTablenameIsSet(true);
            struct.type = CompactionType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.partitionname = iprot.readString();
                struct.setPartitionnameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.runas = iprot.readString();
                struct.setRunasIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map940 = iprot.readMapBegin((byte)11, (byte)11);
                struct.properties = new HashMap<String, String>(2 * _map940.size);
                for (int _i943 = 0; _i943 < _map940.size; ++_i943) {
                    String _key941 = iprot.readString();
                    String _val942 = iprot.readString();
                    struct.properties.put(_key941, _val942);
                }
                struct.setPropertiesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.initiatorId = iprot.readString();
                struct.setInitiatorIdIsSet(true);
            }
            if (incoming.get(4)) {
                struct.initiatorVersion = iprot.readString();
                struct.setInitiatorVersionIsSet(true);
            }
            if (incoming.get(5)) {
                struct.poolName = iprot.readString();
                struct.setPoolNameIsSet(true);
            }
            if (incoming.get(6)) {
                struct.numberOfBuckets = iprot.readI32();
                struct.setNumberOfBucketsIsSet(true);
            }
            if (incoming.get(7)) {
                struct.orderByClause = iprot.readString();
                struct.setOrderByClauseIsSet(true);
            }
        }
    }

    private static class CompactionRequestStandardScheme
    extends StandardScheme<CompactionRequest> {
        private CompactionRequestStandardScheme() {
        }

        public void read(TProtocol iprot, CompactionRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.dbname = iprot.readString();
                            struct.setDbnameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.tablename = iprot.readString();
                            struct.setTablenameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.partitionname = iprot.readString();
                            struct.setPartitionnameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.type = CompactionType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.runas = iprot.readString();
                            struct.setRunasIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 13) {
                            TMap _map934 = iprot.readMapBegin();
                            struct.properties = new HashMap<String, String>(2 * _map934.size);
                            for (int _i937 = 0; _i937 < _map934.size; ++_i937) {
                                String _key935 = iprot.readString();
                                String _val936 = iprot.readString();
                                struct.properties.put(_key935, _val936);
                            }
                            iprot.readMapEnd();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.initiatorId = iprot.readString();
                            struct.setInitiatorIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.initiatorVersion = iprot.readString();
                            struct.setInitiatorVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.poolName = iprot.readString();
                            struct.setPoolNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.numberOfBuckets = iprot.readI32();
                            struct.setNumberOfBucketsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.orderByClause = iprot.readString();
                            struct.setOrderByClauseIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, CompactionRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dbname != null) {
                oprot.writeFieldBegin(DBNAME_FIELD_DESC);
                oprot.writeString(struct.dbname);
                oprot.writeFieldEnd();
            }
            if (struct.tablename != null) {
                oprot.writeFieldBegin(TABLENAME_FIELD_DESC);
                oprot.writeString(struct.tablename);
                oprot.writeFieldEnd();
            }
            if (struct.partitionname != null && struct.isSetPartitionname()) {
                oprot.writeFieldBegin(PARTITIONNAME_FIELD_DESC);
                oprot.writeString(struct.partitionname);
                oprot.writeFieldEnd();
            }
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.runas != null && struct.isSetRunas()) {
                oprot.writeFieldBegin(RUNAS_FIELD_DESC);
                oprot.writeString(struct.runas);
                oprot.writeFieldEnd();
            }
            if (struct.properties != null && struct.isSetProperties()) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.properties.size()));
                for (Map.Entry<String, String> _iter938 : struct.properties.entrySet()) {
                    oprot.writeString(_iter938.getKey());
                    oprot.writeString(_iter938.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.initiatorId != null && struct.isSetInitiatorId()) {
                oprot.writeFieldBegin(INITIATOR_ID_FIELD_DESC);
                oprot.writeString(struct.initiatorId);
                oprot.writeFieldEnd();
            }
            if (struct.initiatorVersion != null && struct.isSetInitiatorVersion()) {
                oprot.writeFieldBegin(INITIATOR_VERSION_FIELD_DESC);
                oprot.writeString(struct.initiatorVersion);
                oprot.writeFieldEnd();
            }
            if (struct.poolName != null && struct.isSetPoolName()) {
                oprot.writeFieldBegin(POOL_NAME_FIELD_DESC);
                oprot.writeString(struct.poolName);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNumberOfBuckets()) {
                oprot.writeFieldBegin(NUMBER_OF_BUCKETS_FIELD_DESC);
                oprot.writeI32(struct.numberOfBuckets);
                oprot.writeFieldEnd();
            }
            if (struct.orderByClause != null && struct.isSetOrderByClause()) {
                oprot.writeFieldBegin(ORDER_BY_CLAUSE_FIELD_DESC);
                oprot.writeString(struct.orderByClause);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

