/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadata;
import org.apache.hadoop.hive.metastore.api.ObjectDictionary;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Table
implements TBase<Table, _Fields>,
Serializable,
Cloneable,
Comparable<Table> {
    private static final TStruct STRUCT_DESC = new TStruct("Table");
    private static final TField TABLE_NAME_FIELD_DESC = new TField("tableName", 11, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField OWNER_FIELD_DESC = new TField("owner", 11, 3);
    private static final TField CREATE_TIME_FIELD_DESC = new TField("createTime", 8, 4);
    private static final TField LAST_ACCESS_TIME_FIELD_DESC = new TField("lastAccessTime", 8, 5);
    private static final TField RETENTION_FIELD_DESC = new TField("retention", 8, 6);
    private static final TField SD_FIELD_DESC = new TField("sd", 12, 7);
    private static final TField PARTITION_KEYS_FIELD_DESC = new TField("partitionKeys", 15, 8);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 9);
    private static final TField VIEW_ORIGINAL_TEXT_FIELD_DESC = new TField("viewOriginalText", 11, 10);
    private static final TField VIEW_EXPANDED_TEXT_FIELD_DESC = new TField("viewExpandedText", 11, 11);
    private static final TField TABLE_TYPE_FIELD_DESC = new TField("tableType", 11, 12);
    private static final TField PRIVILEGES_FIELD_DESC = new TField("privileges", 12, 13);
    private static final TField TEMPORARY_FIELD_DESC = new TField("temporary", 2, 14);
    private static final TField REWRITE_ENABLED_FIELD_DESC = new TField("rewriteEnabled", 2, 15);
    private static final TField CREATION_METADATA_FIELD_DESC = new TField("creationMetadata", 12, 16);
    private static final TField CAT_NAME_FIELD_DESC = new TField("catName", 11, 17);
    private static final TField OWNER_TYPE_FIELD_DESC = new TField("ownerType", 8, 18);
    private static final TField WRITE_ID_FIELD_DESC = new TField("writeId", 10, 19);
    private static final TField IS_STATS_COMPLIANT_FIELD_DESC = new TField("isStatsCompliant", 2, 20);
    private static final TField COL_STATS_FIELD_DESC = new TField("colStats", 12, 21);
    private static final TField ACCESS_TYPE_FIELD_DESC = new TField("accessType", 3, 22);
    private static final TField REQUIRED_READ_CAPABILITIES_FIELD_DESC = new TField("requiredReadCapabilities", 15, 23);
    private static final TField REQUIRED_WRITE_CAPABILITIES_FIELD_DESC = new TField("requiredWriteCapabilities", 15, 24);
    private static final TField ID_FIELD_DESC = new TField("id", 10, 25);
    private static final TField FILE_METADATA_FIELD_DESC = new TField("fileMetadata", 12, 26);
    private static final TField DICTIONARY_FIELD_DESC = new TField("dictionary", 12, 27);
    private static final TField TXN_ID_FIELD_DESC = new TField("txnId", 10, 28);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TableStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TableTupleSchemeFactory();
    @Nullable
    private String tableName;
    @Nullable
    private String dbName;
    @Nullable
    private String owner;
    private int createTime;
    private int lastAccessTime;
    private int retention;
    @Nullable
    private StorageDescriptor sd;
    @Nullable
    private List<FieldSchema> partitionKeys;
    @Nullable
    private Map<String, String> parameters;
    @Nullable
    private String viewOriginalText;
    @Nullable
    private String viewExpandedText;
    @Nullable
    private String tableType;
    @Nullable
    private PrincipalPrivilegeSet privileges;
    private boolean temporary;
    private boolean rewriteEnabled;
    @Nullable
    private CreationMetadata creationMetadata;
    @Nullable
    private String catName;
    @Nullable
    private PrincipalType ownerType;
    private long writeId;
    private boolean isStatsCompliant;
    @Nullable
    private ColumnStatistics colStats;
    private byte accessType;
    @Nullable
    private List<String> requiredReadCapabilities;
    @Nullable
    private List<String> requiredWriteCapabilities;
    private long id;
    @Nullable
    private FileMetadata fileMetadata;
    @Nullable
    private ObjectDictionary dictionary;
    private long txnId;
    private static final int __CREATETIME_ISSET_ID = 0;
    private static final int __LASTACCESSTIME_ISSET_ID = 1;
    private static final int __RETENTION_ISSET_ID = 2;
    private static final int __TEMPORARY_ISSET_ID = 3;
    private static final int __REWRITEENABLED_ISSET_ID = 4;
    private static final int __WRITEID_ISSET_ID = 5;
    private static final int __ISSTATSCOMPLIANT_ISSET_ID = 6;
    private static final int __ACCESSTYPE_ISSET_ID = 7;
    private static final int __ID_ISSET_ID = 8;
    private static final int __TXNID_ISSET_ID = 9;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.PRIVILEGES, _Fields.TEMPORARY, _Fields.REWRITE_ENABLED, _Fields.CREATION_METADATA, _Fields.CAT_NAME, _Fields.OWNER_TYPE, _Fields.WRITE_ID, _Fields.IS_STATS_COMPLIANT, _Fields.COL_STATS, _Fields.ACCESS_TYPE, _Fields.REQUIRED_READ_CAPABILITIES, _Fields.REQUIRED_WRITE_CAPABILITIES, _Fields.ID, _Fields.FILE_METADATA, _Fields.DICTIONARY, _Fields.TXN_ID};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Table() {
        this.temporary = false;
        this.ownerType = PrincipalType.USER;
        this.writeId = -1L;
    }

    public Table(String tableName, String dbName, String owner, int createTime, int lastAccessTime, int retention, StorageDescriptor sd, List<FieldSchema> partitionKeys, Map<String, String> parameters, String viewOriginalText, String viewExpandedText, String tableType) {
        this();
        this.tableName = tableName;
        this.dbName = dbName;
        this.owner = owner;
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
        this.retention = retention;
        this.setRetentionIsSet(true);
        this.sd = sd;
        this.partitionKeys = partitionKeys;
        this.parameters = parameters;
        this.viewOriginalText = viewOriginalText;
        this.viewExpandedText = viewExpandedText;
        this.tableType = tableType;
    }

    public Table(Table other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTableName()) {
            this.tableName = other.tableName;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetOwner()) {
            this.owner = other.owner;
        }
        this.createTime = other.createTime;
        this.lastAccessTime = other.lastAccessTime;
        this.retention = other.retention;
        if (other.isSetSd()) {
            this.sd = new StorageDescriptor(other.sd);
        }
        if (other.isSetPartitionKeys()) {
            ArrayList<FieldSchema> __this__partitionKeys = new ArrayList<FieldSchema>(other.partitionKeys.size());
            for (FieldSchema other_element : other.partitionKeys) {
                __this__partitionKeys.add(new FieldSchema(other_element));
            }
            this.partitionKeys = __this__partitionKeys;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>(other.parameters);
            this.parameters = __this__parameters;
        }
        if (other.isSetViewOriginalText()) {
            this.viewOriginalText = other.viewOriginalText;
        }
        if (other.isSetViewExpandedText()) {
            this.viewExpandedText = other.viewExpandedText;
        }
        if (other.isSetTableType()) {
            this.tableType = other.tableType;
        }
        if (other.isSetPrivileges()) {
            this.privileges = new PrincipalPrivilegeSet(other.privileges);
        }
        this.temporary = other.temporary;
        this.rewriteEnabled = other.rewriteEnabled;
        if (other.isSetCreationMetadata()) {
            this.creationMetadata = new CreationMetadata(other.creationMetadata);
        }
        if (other.isSetCatName()) {
            this.catName = other.catName;
        }
        if (other.isSetOwnerType()) {
            this.ownerType = other.ownerType;
        }
        this.writeId = other.writeId;
        this.isStatsCompliant = other.isStatsCompliant;
        if (other.isSetColStats()) {
            this.colStats = new ColumnStatistics(other.colStats);
        }
        this.accessType = other.accessType;
        if (other.isSetRequiredReadCapabilities()) {
            ArrayList<String> __this__requiredReadCapabilities = new ArrayList<String>(other.requiredReadCapabilities);
            this.requiredReadCapabilities = __this__requiredReadCapabilities;
        }
        if (other.isSetRequiredWriteCapabilities()) {
            ArrayList<String> __this__requiredWriteCapabilities = new ArrayList<String>(other.requiredWriteCapabilities);
            this.requiredWriteCapabilities = __this__requiredWriteCapabilities;
        }
        this.id = other.id;
        if (other.isSetFileMetadata()) {
            this.fileMetadata = new FileMetadata(other.fileMetadata);
        }
        if (other.isSetDictionary()) {
            this.dictionary = new ObjectDictionary(other.dictionary);
        }
        this.txnId = other.txnId;
    }

    public Table deepCopy() {
        return new Table(this);
    }

    public void clear() {
        this.tableName = null;
        this.dbName = null;
        this.owner = null;
        this.setCreateTimeIsSet(false);
        this.createTime = 0;
        this.setLastAccessTimeIsSet(false);
        this.lastAccessTime = 0;
        this.setRetentionIsSet(false);
        this.retention = 0;
        this.sd = null;
        this.partitionKeys = null;
        this.parameters = null;
        this.viewOriginalText = null;
        this.viewExpandedText = null;
        this.tableType = null;
        this.privileges = null;
        this.temporary = false;
        this.setRewriteEnabledIsSet(false);
        this.rewriteEnabled = false;
        this.creationMetadata = null;
        this.catName = null;
        this.ownerType = PrincipalType.USER;
        this.writeId = -1L;
        this.setIsStatsCompliantIsSet(false);
        this.isStatsCompliant = false;
        this.colStats = null;
        this.setAccessTypeIsSet(false);
        this.accessType = 0;
        this.requiredReadCapabilities = null;
        this.requiredWriteCapabilities = null;
        this.setIdIsSet(false);
        this.id = 0L;
        this.fileMetadata = null;
        this.dictionary = null;
        this.setTxnIdIsSet(false);
        this.txnId = 0L;
    }

    @Nullable
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(@Nullable String tableName) {
        this.tableName = tableName;
    }

    public void unsetTableName() {
        this.tableName = null;
    }

    public boolean isSetTableName() {
        return this.tableName != null;
    }

    public void setTableNameIsSet(boolean value) {
        if (!value) {
            this.tableName = null;
        }
    }

    @Nullable
    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(@Nullable String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    @Nullable
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable String owner) {
        this.owner = owner;
    }

    public void unsetOwner() {
        this.owner = null;
    }

    public boolean isSetOwner() {
        return this.owner != null;
    }

    public void setOwnerIsSet(boolean value) {
        if (!value) {
            this.owner = null;
        }
    }

    public int getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(int createTime) {
        this.createTime = createTime;
        this.setCreateTimeIsSet(true);
    }

    public void unsetCreateTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetCreateTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setCreateTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        this.setLastAccessTimeIsSet(true);
    }

    public void unsetLastAccessTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetLastAccessTime() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setLastAccessTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getRetention() {
        return this.retention;
    }

    public void setRetention(int retention) {
        this.retention = retention;
        this.setRetentionIsSet(true);
    }

    public void unsetRetention() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetRetention() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setRetentionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    @Nullable
    public StorageDescriptor getSd() {
        return this.sd;
    }

    public void setSd(@Nullable StorageDescriptor sd) {
        this.sd = sd;
    }

    public void unsetSd() {
        this.sd = null;
    }

    public boolean isSetSd() {
        return this.sd != null;
    }

    public void setSdIsSet(boolean value) {
        if (!value) {
            this.sd = null;
        }
    }

    public int getPartitionKeysSize() {
        return this.partitionKeys == null ? 0 : this.partitionKeys.size();
    }

    @Nullable
    public Iterator<FieldSchema> getPartitionKeysIterator() {
        return this.partitionKeys == null ? null : this.partitionKeys.iterator();
    }

    public void addToPartitionKeys(FieldSchema elem) {
        if (this.partitionKeys == null) {
            this.partitionKeys = new ArrayList<FieldSchema>();
        }
        this.partitionKeys.add(elem);
    }

    @Nullable
    public List<FieldSchema> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(@Nullable List<FieldSchema> partitionKeys) {
        this.partitionKeys = partitionKeys;
    }

    public void unsetPartitionKeys() {
        this.partitionKeys = null;
    }

    public boolean isSetPartitionKeys() {
        return this.partitionKeys != null;
    }

    public void setPartitionKeysIsSet(boolean value) {
        if (!value) {
            this.partitionKeys = null;
        }
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setParametersIsSet(boolean value) {
        if (!value) {
            this.parameters = null;
        }
    }

    @Nullable
    public String getViewOriginalText() {
        return this.viewOriginalText;
    }

    public void setViewOriginalText(@Nullable String viewOriginalText) {
        this.viewOriginalText = viewOriginalText;
    }

    public void unsetViewOriginalText() {
        this.viewOriginalText = null;
    }

    public boolean isSetViewOriginalText() {
        return this.viewOriginalText != null;
    }

    public void setViewOriginalTextIsSet(boolean value) {
        if (!value) {
            this.viewOriginalText = null;
        }
    }

    @Nullable
    public String getViewExpandedText() {
        return this.viewExpandedText;
    }

    public void setViewExpandedText(@Nullable String viewExpandedText) {
        this.viewExpandedText = viewExpandedText;
    }

    public void unsetViewExpandedText() {
        this.viewExpandedText = null;
    }

    public boolean isSetViewExpandedText() {
        return this.viewExpandedText != null;
    }

    public void setViewExpandedTextIsSet(boolean value) {
        if (!value) {
            this.viewExpandedText = null;
        }
    }

    @Nullable
    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(@Nullable String tableType) {
        this.tableType = tableType;
    }

    public void unsetTableType() {
        this.tableType = null;
    }

    public boolean isSetTableType() {
        return this.tableType != null;
    }

    public void setTableTypeIsSet(boolean value) {
        if (!value) {
            this.tableType = null;
        }
    }

    @Nullable
    public PrincipalPrivilegeSet getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(@Nullable PrincipalPrivilegeSet privileges) {
        this.privileges = privileges;
    }

    public void unsetPrivileges() {
        this.privileges = null;
    }

    public boolean isSetPrivileges() {
        return this.privileges != null;
    }

    public void setPrivilegesIsSet(boolean value) {
        if (!value) {
            this.privileges = null;
        }
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
        this.setTemporaryIsSet(true);
    }

    public void unsetTemporary() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetTemporary() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setTemporaryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public boolean isRewriteEnabled() {
        return this.rewriteEnabled;
    }

    public void setRewriteEnabled(boolean rewriteEnabled) {
        this.rewriteEnabled = rewriteEnabled;
        this.setRewriteEnabledIsSet(true);
    }

    public void unsetRewriteEnabled() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetRewriteEnabled() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setRewriteEnabledIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    @Nullable
    public CreationMetadata getCreationMetadata() {
        return this.creationMetadata;
    }

    public void setCreationMetadata(@Nullable CreationMetadata creationMetadata) {
        this.creationMetadata = creationMetadata;
    }

    public void unsetCreationMetadata() {
        this.creationMetadata = null;
    }

    public boolean isSetCreationMetadata() {
        return this.creationMetadata != null;
    }

    public void setCreationMetadataIsSet(boolean value) {
        if (!value) {
            this.creationMetadata = null;
        }
    }

    @Nullable
    public String getCatName() {
        return this.catName;
    }

    public void setCatName(@Nullable String catName) {
        this.catName = catName;
    }

    public void unsetCatName() {
        this.catName = null;
    }

    public boolean isSetCatName() {
        return this.catName != null;
    }

    public void setCatNameIsSet(boolean value) {
        if (!value) {
            this.catName = null;
        }
    }

    @Nullable
    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(@Nullable PrincipalType ownerType) {
        this.ownerType = ownerType;
    }

    public void unsetOwnerType() {
        this.ownerType = null;
    }

    public boolean isSetOwnerType() {
        return this.ownerType != null;
    }

    public void setOwnerTypeIsSet(boolean value) {
        if (!value) {
            this.ownerType = null;
        }
    }

    public long getWriteId() {
        return this.writeId;
    }

    public void setWriteId(long writeId) {
        this.writeId = writeId;
        this.setWriteIdIsSet(true);
    }

    public void unsetWriteId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetWriteId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setWriteIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public boolean isIsStatsCompliant() {
        return this.isStatsCompliant;
    }

    public void setIsStatsCompliant(boolean isStatsCompliant) {
        this.isStatsCompliant = isStatsCompliant;
        this.setIsStatsCompliantIsSet(true);
    }

    public void unsetIsStatsCompliant() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetIsStatsCompliant() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setIsStatsCompliantIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    @Nullable
    public ColumnStatistics getColStats() {
        return this.colStats;
    }

    public void setColStats(@Nullable ColumnStatistics colStats) {
        this.colStats = colStats;
    }

    public void unsetColStats() {
        this.colStats = null;
    }

    public boolean isSetColStats() {
        return this.colStats != null;
    }

    public void setColStatsIsSet(boolean value) {
        if (!value) {
            this.colStats = null;
        }
    }

    public byte getAccessType() {
        return this.accessType;
    }

    public void setAccessType(byte accessType) {
        this.accessType = accessType;
        this.setAccessTypeIsSet(true);
    }

    public void unsetAccessType() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetAccessType() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setAccessTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public int getRequiredReadCapabilitiesSize() {
        return this.requiredReadCapabilities == null ? 0 : this.requiredReadCapabilities.size();
    }

    @Nullable
    public Iterator<String> getRequiredReadCapabilitiesIterator() {
        return this.requiredReadCapabilities == null ? null : this.requiredReadCapabilities.iterator();
    }

    public void addToRequiredReadCapabilities(String elem) {
        if (this.requiredReadCapabilities == null) {
            this.requiredReadCapabilities = new ArrayList<String>();
        }
        this.requiredReadCapabilities.add(elem);
    }

    @Nullable
    public List<String> getRequiredReadCapabilities() {
        return this.requiredReadCapabilities;
    }

    public void setRequiredReadCapabilities(@Nullable List<String> requiredReadCapabilities) {
        this.requiredReadCapabilities = requiredReadCapabilities;
    }

    public void unsetRequiredReadCapabilities() {
        this.requiredReadCapabilities = null;
    }

    public boolean isSetRequiredReadCapabilities() {
        return this.requiredReadCapabilities != null;
    }

    public void setRequiredReadCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.requiredReadCapabilities = null;
        }
    }

    public int getRequiredWriteCapabilitiesSize() {
        return this.requiredWriteCapabilities == null ? 0 : this.requiredWriteCapabilities.size();
    }

    @Nullable
    public Iterator<String> getRequiredWriteCapabilitiesIterator() {
        return this.requiredWriteCapabilities == null ? null : this.requiredWriteCapabilities.iterator();
    }

    public void addToRequiredWriteCapabilities(String elem) {
        if (this.requiredWriteCapabilities == null) {
            this.requiredWriteCapabilities = new ArrayList<String>();
        }
        this.requiredWriteCapabilities.add(elem);
    }

    @Nullable
    public List<String> getRequiredWriteCapabilities() {
        return this.requiredWriteCapabilities;
    }

    public void setRequiredWriteCapabilities(@Nullable List<String> requiredWriteCapabilities) {
        this.requiredWriteCapabilities = requiredWriteCapabilities;
    }

    public void unsetRequiredWriteCapabilities() {
        this.requiredWriteCapabilities = null;
    }

    public boolean isSetRequiredWriteCapabilities() {
        return this.requiredWriteCapabilities != null;
    }

    public void setRequiredWriteCapabilitiesIsSet(boolean value) {
        if (!value) {
            this.requiredWriteCapabilities = null;
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    @Nullable
    public FileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    public void setFileMetadata(@Nullable FileMetadata fileMetadata) {
        this.fileMetadata = fileMetadata;
    }

    public void unsetFileMetadata() {
        this.fileMetadata = null;
    }

    public boolean isSetFileMetadata() {
        return this.fileMetadata != null;
    }

    public void setFileMetadataIsSet(boolean value) {
        if (!value) {
            this.fileMetadata = null;
        }
    }

    @Nullable
    public ObjectDictionary getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(@Nullable ObjectDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void unsetDictionary() {
        this.dictionary = null;
    }

    public boolean isSetDictionary() {
        return this.dictionary != null;
    }

    public void setDictionaryIsSet(boolean value) {
        if (!value) {
            this.dictionary = null;
        }
    }

    public long getTxnId() {
        return this.txnId;
    }

    public void setTxnId(long txnId) {
        this.txnId = txnId;
        this.setTxnIdIsSet(true);
    }

    public void unsetTxnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)9);
    }

    public boolean isSetTxnId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)9);
    }

    public void setTxnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)9, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field.ordinal()) {
            case 0: {
                if (value == null) {
                    this.unsetTableName();
                    break;
                }
                this.setTableName((String)value);
                break;
            }
            case 1: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetOwner();
                    break;
                }
                this.setOwner((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetCreateTime();
                    break;
                }
                this.setCreateTime((Integer)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetLastAccessTime();
                    break;
                }
                this.setLastAccessTime((Integer)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetRetention();
                    break;
                }
                this.setRetention((Integer)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetSd();
                    break;
                }
                this.setSd((StorageDescriptor)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetPartitionKeys();
                    break;
                }
                this.setPartitionKeys((List)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetViewOriginalText();
                    break;
                }
                this.setViewOriginalText((String)value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.unsetViewExpandedText();
                    break;
                }
                this.setViewExpandedText((String)value);
                break;
            }
            case 11: {
                if (value == null) {
                    this.unsetTableType();
                    break;
                }
                this.setTableType((String)value);
                break;
            }
            case 12: {
                if (value == null) {
                    this.unsetPrivileges();
                    break;
                }
                this.setPrivileges((PrincipalPrivilegeSet)value);
                break;
            }
            case 13: {
                if (value == null) {
                    this.unsetTemporary();
                    break;
                }
                this.setTemporary((Boolean)value);
                break;
            }
            case 14: {
                if (value == null) {
                    this.unsetRewriteEnabled();
                    break;
                }
                this.setRewriteEnabled((Boolean)value);
                break;
            }
            case 15: {
                if (value == null) {
                    this.unsetCreationMetadata();
                    break;
                }
                this.setCreationMetadata((CreationMetadata)value);
                break;
            }
            case 16: {
                if (value == null) {
                    this.unsetCatName();
                    break;
                }
                this.setCatName((String)value);
                break;
            }
            case 17: {
                if (value == null) {
                    this.unsetOwnerType();
                    break;
                }
                this.setOwnerType((PrincipalType)((Object)value));
                break;
            }
            case 18: {
                if (value == null) {
                    this.unsetWriteId();
                    break;
                }
                this.setWriteId((Long)value);
                break;
            }
            case 19: {
                if (value == null) {
                    this.unsetIsStatsCompliant();
                    break;
                }
                this.setIsStatsCompliant((Boolean)value);
                break;
            }
            case 20: {
                if (value == null) {
                    this.unsetColStats();
                    break;
                }
                this.setColStats((ColumnStatistics)value);
                break;
            }
            case 21: {
                if (value == null) {
                    this.unsetAccessType();
                    break;
                }
                this.setAccessType((Byte)value);
                break;
            }
            case 22: {
                if (value == null) {
                    this.unsetRequiredReadCapabilities();
                    break;
                }
                this.setRequiredReadCapabilities((List)value);
                break;
            }
            case 23: {
                if (value == null) {
                    this.unsetRequiredWriteCapabilities();
                    break;
                }
                this.setRequiredWriteCapabilities((List)value);
                break;
            }
            case 24: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case 25: {
                if (value == null) {
                    this.unsetFileMetadata();
                    break;
                }
                this.setFileMetadata((FileMetadata)value);
                break;
            }
            case 26: {
                if (value == null) {
                    this.unsetDictionary();
                    break;
                }
                this.setDictionary((ObjectDictionary)value);
                break;
            }
            case 27: {
                if (value == null) {
                    this.unsetTxnId();
                    break;
                }
                this.setTxnId((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field.ordinal()) {
            case 0: {
                return this.getTableName();
            }
            case 1: {
                return this.getDbName();
            }
            case 2: {
                return this.getOwner();
            }
            case 3: {
                return this.getCreateTime();
            }
            case 4: {
                return this.getLastAccessTime();
            }
            case 5: {
                return this.getRetention();
            }
            case 6: {
                return this.getSd();
            }
            case 7: {
                return this.getPartitionKeys();
            }
            case 8: {
                return this.getParameters();
            }
            case 9: {
                return this.getViewOriginalText();
            }
            case 10: {
                return this.getViewExpandedText();
            }
            case 11: {
                return this.getTableType();
            }
            case 12: {
                return this.getPrivileges();
            }
            case 13: {
                return this.isTemporary();
            }
            case 14: {
                return this.isRewriteEnabled();
            }
            case 15: {
                return this.getCreationMetadata();
            }
            case 16: {
                return this.getCatName();
            }
            case 17: {
                return this.getOwnerType();
            }
            case 18: {
                return this.getWriteId();
            }
            case 19: {
                return this.isIsStatsCompliant();
            }
            case 20: {
                return this.getColStats();
            }
            case 21: {
                return this.getAccessType();
            }
            case 22: {
                return this.getRequiredReadCapabilities();
            }
            case 23: {
                return this.getRequiredWriteCapabilities();
            }
            case 24: {
                return this.getId();
            }
            case 25: {
                return this.getFileMetadata();
            }
            case 26: {
                return this.getDictionary();
            }
            case 27: {
                return this.getTxnId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field.ordinal()) {
            case 0: {
                return this.isSetTableName();
            }
            case 1: {
                return this.isSetDbName();
            }
            case 2: {
                return this.isSetOwner();
            }
            case 3: {
                return this.isSetCreateTime();
            }
            case 4: {
                return this.isSetLastAccessTime();
            }
            case 5: {
                return this.isSetRetention();
            }
            case 6: {
                return this.isSetSd();
            }
            case 7: {
                return this.isSetPartitionKeys();
            }
            case 8: {
                return this.isSetParameters();
            }
            case 9: {
                return this.isSetViewOriginalText();
            }
            case 10: {
                return this.isSetViewExpandedText();
            }
            case 11: {
                return this.isSetTableType();
            }
            case 12: {
                return this.isSetPrivileges();
            }
            case 13: {
                return this.isSetTemporary();
            }
            case 14: {
                return this.isSetRewriteEnabled();
            }
            case 15: {
                return this.isSetCreationMetadata();
            }
            case 16: {
                return this.isSetCatName();
            }
            case 17: {
                return this.isSetOwnerType();
            }
            case 18: {
                return this.isSetWriteId();
            }
            case 19: {
                return this.isSetIsStatsCompliant();
            }
            case 20: {
                return this.isSetColStats();
            }
            case 21: {
                return this.isSetAccessType();
            }
            case 22: {
                return this.isSetRequiredReadCapabilities();
            }
            case 23: {
                return this.isSetRequiredWriteCapabilities();
            }
            case 24: {
                return this.isSetId();
            }
            case 25: {
                return this.isSetFileMetadata();
            }
            case 26: {
                return this.isSetDictionary();
            }
            case 27: {
                return this.isSetTxnId();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof Table) {
            return this.equals((Table)that);
        }
        return false;
    }

    public boolean equals(Table that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tableName = this.isSetTableName();
        boolean that_present_tableName = that.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!this.tableName.equals(that.tableName)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_owner = this.isSetOwner();
        boolean that_present_owner = that.isSetOwner();
        if (this_present_owner || that_present_owner) {
            if (!this_present_owner || !that_present_owner) {
                return false;
            }
            if (!this.owner.equals(that.owner)) {
                return false;
            }
        }
        boolean this_present_createTime = true;
        boolean that_present_createTime = true;
        if (this_present_createTime || that_present_createTime) {
            if (!this_present_createTime || !that_present_createTime) {
                return false;
            }
            if (this.createTime != that.createTime) {
                return false;
            }
        }
        boolean this_present_lastAccessTime = true;
        boolean that_present_lastAccessTime = true;
        if (this_present_lastAccessTime || that_present_lastAccessTime) {
            if (!this_present_lastAccessTime || !that_present_lastAccessTime) {
                return false;
            }
            if (this.lastAccessTime != that.lastAccessTime) {
                return false;
            }
        }
        boolean this_present_retention = true;
        boolean that_present_retention = true;
        if (this_present_retention || that_present_retention) {
            if (!this_present_retention || !that_present_retention) {
                return false;
            }
            if (this.retention != that.retention) {
                return false;
            }
        }
        boolean this_present_sd = this.isSetSd();
        boolean that_present_sd = that.isSetSd();
        if (this_present_sd || that_present_sd) {
            if (!this_present_sd || !that_present_sd) {
                return false;
            }
            if (!this.sd.equals(that.sd)) {
                return false;
            }
        }
        boolean this_present_partitionKeys = this.isSetPartitionKeys();
        boolean that_present_partitionKeys = that.isSetPartitionKeys();
        if (this_present_partitionKeys || that_present_partitionKeys) {
            if (!this_present_partitionKeys || !that_present_partitionKeys) {
                return false;
            }
            if (!this.partitionKeys.equals(that.partitionKeys)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!this.parameters.equals(that.parameters)) {
                return false;
            }
        }
        boolean this_present_viewOriginalText = this.isSetViewOriginalText();
        boolean that_present_viewOriginalText = that.isSetViewOriginalText();
        if (this_present_viewOriginalText || that_present_viewOriginalText) {
            if (!this_present_viewOriginalText || !that_present_viewOriginalText) {
                return false;
            }
            if (!this.viewOriginalText.equals(that.viewOriginalText)) {
                return false;
            }
        }
        boolean this_present_viewExpandedText = this.isSetViewExpandedText();
        boolean that_present_viewExpandedText = that.isSetViewExpandedText();
        if (this_present_viewExpandedText || that_present_viewExpandedText) {
            if (!this_present_viewExpandedText || !that_present_viewExpandedText) {
                return false;
            }
            if (!this.viewExpandedText.equals(that.viewExpandedText)) {
                return false;
            }
        }
        boolean this_present_tableType = this.isSetTableType();
        boolean that_present_tableType = that.isSetTableType();
        if (this_present_tableType || that_present_tableType) {
            if (!this_present_tableType || !that_present_tableType) {
                return false;
            }
            if (!this.tableType.equals(that.tableType)) {
                return false;
            }
        }
        boolean this_present_privileges = this.isSetPrivileges();
        boolean that_present_privileges = that.isSetPrivileges();
        if (this_present_privileges || that_present_privileges) {
            if (!this_present_privileges || !that_present_privileges) {
                return false;
            }
            if (!this.privileges.equals(that.privileges)) {
                return false;
            }
        }
        boolean this_present_temporary = this.isSetTemporary();
        boolean that_present_temporary = that.isSetTemporary();
        if (this_present_temporary || that_present_temporary) {
            if (!this_present_temporary || !that_present_temporary) {
                return false;
            }
            if (this.temporary != that.temporary) {
                return false;
            }
        }
        boolean this_present_rewriteEnabled = this.isSetRewriteEnabled();
        boolean that_present_rewriteEnabled = that.isSetRewriteEnabled();
        if (this_present_rewriteEnabled || that_present_rewriteEnabled) {
            if (!this_present_rewriteEnabled || !that_present_rewriteEnabled) {
                return false;
            }
            if (this.rewriteEnabled != that.rewriteEnabled) {
                return false;
            }
        }
        boolean this_present_creationMetadata = this.isSetCreationMetadata();
        boolean that_present_creationMetadata = that.isSetCreationMetadata();
        if (this_present_creationMetadata || that_present_creationMetadata) {
            if (!this_present_creationMetadata || !that_present_creationMetadata) {
                return false;
            }
            if (!this.creationMetadata.equals(that.creationMetadata)) {
                return false;
            }
        }
        boolean this_present_catName = this.isSetCatName();
        boolean that_present_catName = that.isSetCatName();
        if (this_present_catName || that_present_catName) {
            if (!this_present_catName || !that_present_catName) {
                return false;
            }
            if (!this.catName.equals(that.catName)) {
                return false;
            }
        }
        boolean this_present_ownerType = this.isSetOwnerType();
        boolean that_present_ownerType = that.isSetOwnerType();
        if (this_present_ownerType || that_present_ownerType) {
            if (!this_present_ownerType || !that_present_ownerType) {
                return false;
            }
            if (!this.ownerType.equals((Object)that.ownerType)) {
                return false;
            }
        }
        boolean this_present_writeId = this.isSetWriteId();
        boolean that_present_writeId = that.isSetWriteId();
        if (this_present_writeId || that_present_writeId) {
            if (!this_present_writeId || !that_present_writeId) {
                return false;
            }
            if (this.writeId != that.writeId) {
                return false;
            }
        }
        boolean this_present_isStatsCompliant = this.isSetIsStatsCompliant();
        boolean that_present_isStatsCompliant = that.isSetIsStatsCompliant();
        if (this_present_isStatsCompliant || that_present_isStatsCompliant) {
            if (!this_present_isStatsCompliant || !that_present_isStatsCompliant) {
                return false;
            }
            if (this.isStatsCompliant != that.isStatsCompliant) {
                return false;
            }
        }
        boolean this_present_colStats = this.isSetColStats();
        boolean that_present_colStats = that.isSetColStats();
        if (this_present_colStats || that_present_colStats) {
            if (!this_present_colStats || !that_present_colStats) {
                return false;
            }
            if (!this.colStats.equals(that.colStats)) {
                return false;
            }
        }
        boolean this_present_accessType = this.isSetAccessType();
        boolean that_present_accessType = that.isSetAccessType();
        if (this_present_accessType || that_present_accessType) {
            if (!this_present_accessType || !that_present_accessType) {
                return false;
            }
            if (this.accessType != that.accessType) {
                return false;
            }
        }
        boolean this_present_requiredReadCapabilities = this.isSetRequiredReadCapabilities();
        boolean that_present_requiredReadCapabilities = that.isSetRequiredReadCapabilities();
        if (this_present_requiredReadCapabilities || that_present_requiredReadCapabilities) {
            if (!this_present_requiredReadCapabilities || !that_present_requiredReadCapabilities) {
                return false;
            }
            if (!this.requiredReadCapabilities.equals(that.requiredReadCapabilities)) {
                return false;
            }
        }
        boolean this_present_requiredWriteCapabilities = this.isSetRequiredWriteCapabilities();
        boolean that_present_requiredWriteCapabilities = that.isSetRequiredWriteCapabilities();
        if (this_present_requiredWriteCapabilities || that_present_requiredWriteCapabilities) {
            if (!this_present_requiredWriteCapabilities || !that_present_requiredWriteCapabilities) {
                return false;
            }
            if (!this.requiredWriteCapabilities.equals(that.requiredWriteCapabilities)) {
                return false;
            }
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_fileMetadata = this.isSetFileMetadata();
        boolean that_present_fileMetadata = that.isSetFileMetadata();
        if (this_present_fileMetadata || that_present_fileMetadata) {
            if (!this_present_fileMetadata || !that_present_fileMetadata) {
                return false;
            }
            if (!this.fileMetadata.equals(that.fileMetadata)) {
                return false;
            }
        }
        boolean this_present_dictionary = this.isSetDictionary();
        boolean that_present_dictionary = that.isSetDictionary();
        if (this_present_dictionary || that_present_dictionary) {
            if (!this_present_dictionary || !that_present_dictionary) {
                return false;
            }
            if (!this.dictionary.equals(that.dictionary)) {
                return false;
            }
        }
        boolean this_present_txnId = this.isSetTxnId();
        boolean that_present_txnId = that.isSetTxnId();
        if (this_present_txnId || that_present_txnId) {
            if (!this_present_txnId || !that_present_txnId) {
                return false;
            }
            if (this.txnId != that.txnId) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTableName() ? 131071 : 524287);
        if (this.isSetTableName()) {
            hashCode = hashCode * 8191 + this.tableName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDbName() ? 131071 : 524287);
        if (this.isSetDbName()) {
            hashCode = hashCode * 8191 + this.dbName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOwner() ? 131071 : 524287);
        if (this.isSetOwner()) {
            hashCode = hashCode * 8191 + this.owner.hashCode();
        }
        hashCode = hashCode * 8191 + this.createTime;
        hashCode = hashCode * 8191 + this.lastAccessTime;
        hashCode = hashCode * 8191 + this.retention;
        hashCode = hashCode * 8191 + (this.isSetSd() ? 131071 : 524287);
        if (this.isSetSd()) {
            hashCode = hashCode * 8191 + this.sd.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionKeys() ? 131071 : 524287);
        if (this.isSetPartitionKeys()) {
            hashCode = hashCode * 8191 + this.partitionKeys.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParameters() ? 131071 : 524287);
        if (this.isSetParameters()) {
            hashCode = hashCode * 8191 + this.parameters.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetViewOriginalText() ? 131071 : 524287);
        if (this.isSetViewOriginalText()) {
            hashCode = hashCode * 8191 + this.viewOriginalText.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetViewExpandedText() ? 131071 : 524287);
        if (this.isSetViewExpandedText()) {
            hashCode = hashCode * 8191 + this.viewExpandedText.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableType() ? 131071 : 524287);
        if (this.isSetTableType()) {
            hashCode = hashCode * 8191 + this.tableType.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPrivileges() ? 131071 : 524287);
        if (this.isSetPrivileges()) {
            hashCode = hashCode * 8191 + this.privileges.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTemporary() ? 131071 : 524287);
        if (this.isSetTemporary()) {
            hashCode = hashCode * 8191 + (this.temporary ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetRewriteEnabled() ? 131071 : 524287);
        if (this.isSetRewriteEnabled()) {
            hashCode = hashCode * 8191 + (this.rewriteEnabled ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetCreationMetadata() ? 131071 : 524287);
        if (this.isSetCreationMetadata()) {
            hashCode = hashCode * 8191 + this.creationMetadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCatName() ? 131071 : 524287);
        if (this.isSetCatName()) {
            hashCode = hashCode * 8191 + this.catName.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOwnerType() ? 131071 : 524287);
        if (this.isSetOwnerType()) {
            hashCode = hashCode * 8191 + this.ownerType.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetWriteId() ? 131071 : 524287);
        if (this.isSetWriteId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.writeId);
        }
        hashCode = hashCode * 8191 + (this.isSetIsStatsCompliant() ? 131071 : 524287);
        if (this.isSetIsStatsCompliant()) {
            hashCode = hashCode * 8191 + (this.isStatsCompliant ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetColStats() ? 131071 : 524287);
        if (this.isSetColStats()) {
            hashCode = hashCode * 8191 + this.colStats.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAccessType() ? 131071 : 524287);
        if (this.isSetAccessType()) {
            hashCode = hashCode * 8191 + this.accessType;
        }
        hashCode = hashCode * 8191 + (this.isSetRequiredReadCapabilities() ? 131071 : 524287);
        if (this.isSetRequiredReadCapabilities()) {
            hashCode = hashCode * 8191 + this.requiredReadCapabilities.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRequiredWriteCapabilities() ? 131071 : 524287);
        if (this.isSetRequiredWriteCapabilities()) {
            hashCode = hashCode * 8191 + this.requiredWriteCapabilities.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetId() ? 131071 : 524287);
        if (this.isSetId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.id);
        }
        hashCode = hashCode * 8191 + (this.isSetFileMetadata() ? 131071 : 524287);
        if (this.isSetFileMetadata()) {
            hashCode = hashCode * 8191 + this.fileMetadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDictionary() ? 131071 : 524287);
        if (this.isSetDictionary()) {
            hashCode = hashCode * 8191 + this.dictionary.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTxnId() ? 131071 : 524287);
        if (this.isSetTxnId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.txnId);
        }
        return hashCode;
    }

    @Override
    public int compareTo(Table other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTableName(), other.isSetTableName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableName() && (lastComparison = TBaseHelper.compareTo((String)this.tableName, (String)other.tableName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDbName(), other.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)other.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOwner(), other.isSetOwner());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwner() && (lastComparison = TBaseHelper.compareTo((String)this.owner, (String)other.owner)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCreateTime(), other.isSetCreateTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreateTime() && (lastComparison = TBaseHelper.compareTo((int)this.createTime, (int)other.createTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLastAccessTime(), other.isSetLastAccessTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLastAccessTime() && (lastComparison = TBaseHelper.compareTo((int)this.lastAccessTime, (int)other.lastAccessTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRetention(), other.isSetRetention());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRetention() && (lastComparison = TBaseHelper.compareTo((int)this.retention, (int)other.retention)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSd(), other.isSetSd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSd() && (lastComparison = TBaseHelper.compareTo((Comparable)this.sd, (Comparable)other.sd)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionKeys(), other.isSetPartitionKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionKeys() && (lastComparison = TBaseHelper.compareTo(this.partitionKeys, other.partitionKeys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParameters(), other.isSetParameters());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParameters() && (lastComparison = TBaseHelper.compareTo(this.parameters, other.parameters)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetViewOriginalText(), other.isSetViewOriginalText());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetViewOriginalText() && (lastComparison = TBaseHelper.compareTo((String)this.viewOriginalText, (String)other.viewOriginalText)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetViewExpandedText(), other.isSetViewExpandedText());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetViewExpandedText() && (lastComparison = TBaseHelper.compareTo((String)this.viewExpandedText, (String)other.viewExpandedText)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableType(), other.isSetTableType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableType() && (lastComparison = TBaseHelper.compareTo((String)this.tableType, (String)other.tableType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPrivileges(), other.isSetPrivileges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrivileges() && (lastComparison = TBaseHelper.compareTo((Comparable)this.privileges, (Comparable)other.privileges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTemporary(), other.isSetTemporary());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTemporary() && (lastComparison = TBaseHelper.compareTo((boolean)this.temporary, (boolean)other.temporary)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRewriteEnabled(), other.isSetRewriteEnabled());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRewriteEnabled() && (lastComparison = TBaseHelper.compareTo((boolean)this.rewriteEnabled, (boolean)other.rewriteEnabled)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCreationMetadata(), other.isSetCreationMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreationMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)this.creationMetadata, (Comparable)other.creationMetadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCatName(), other.isSetCatName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatName() && (lastComparison = TBaseHelper.compareTo((String)this.catName, (String)other.catName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOwnerType(), other.isSetOwnerType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOwnerType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.ownerType), (Comparable)((Object)other.ownerType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetWriteId(), other.isSetWriteId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetWriteId() && (lastComparison = TBaseHelper.compareTo((long)this.writeId, (long)other.writeId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsStatsCompliant(), other.isSetIsStatsCompliant());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsStatsCompliant() && (lastComparison = TBaseHelper.compareTo((boolean)this.isStatsCompliant, (boolean)other.isStatsCompliant)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColStats(), other.isSetColStats());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColStats() && (lastComparison = TBaseHelper.compareTo((Comparable)this.colStats, (Comparable)other.colStats)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAccessType(), other.isSetAccessType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAccessType() && (lastComparison = TBaseHelper.compareTo((byte)this.accessType, (byte)other.accessType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRequiredReadCapabilities(), other.isSetRequiredReadCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequiredReadCapabilities() && (lastComparison = TBaseHelper.compareTo(this.requiredReadCapabilities, other.requiredReadCapabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRequiredWriteCapabilities(), other.isSetRequiredWriteCapabilities());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequiredWriteCapabilities() && (lastComparison = TBaseHelper.compareTo(this.requiredWriteCapabilities, other.requiredWriteCapabilities)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetId(), other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFileMetadata(), other.isSetFileMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)this.fileMetadata, (Comparable)other.fileMetadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDictionary(), other.isSetDictionary());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dictionary, (Comparable)other.dictionary)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTxnId(), other.isSetTxnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTxnId() && (lastComparison = TBaseHelper.compareTo((long)this.txnId, (long)other.txnId)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        Table.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        Table.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Table(");
        boolean first = true;
        sb.append("tableName:");
        if (this.tableName == null) {
            sb.append("null");
        } else {
            sb.append(this.tableName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("owner:");
        if (this.owner == null) {
            sb.append("null");
        } else {
            sb.append(this.owner);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("createTime:");
        sb.append(this.createTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("lastAccessTime:");
        sb.append(this.lastAccessTime);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("retention:");
        sb.append(this.retention);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sd:");
        if (this.sd == null) {
            sb.append("null");
        } else {
            sb.append(this.sd);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partitionKeys:");
        if (this.partitionKeys == null) {
            sb.append("null");
        } else {
            sb.append(this.partitionKeys);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("viewOriginalText:");
        if (this.viewOriginalText == null) {
            sb.append("null");
        } else {
            sb.append(this.viewOriginalText);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("viewExpandedText:");
        if (this.viewExpandedText == null) {
            sb.append("null");
        } else {
            sb.append(this.viewExpandedText);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("tableType:");
        if (this.tableType == null) {
            sb.append("null");
        } else {
            sb.append(this.tableType);
        }
        first = false;
        if (this.isSetPrivileges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("privileges:");
            if (this.privileges == null) {
                sb.append("null");
            } else {
                sb.append(this.privileges);
            }
            first = false;
        }
        if (this.isSetTemporary()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("temporary:");
            sb.append(this.temporary);
            first = false;
        }
        if (this.isSetRewriteEnabled()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("rewriteEnabled:");
            sb.append(this.rewriteEnabled);
            first = false;
        }
        if (this.isSetCreationMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("creationMetadata:");
            if (this.creationMetadata == null) {
                sb.append("null");
            } else {
                sb.append(this.creationMetadata);
            }
            first = false;
        }
        if (this.isSetCatName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catName:");
            if (this.catName == null) {
                sb.append("null");
            } else {
                sb.append(this.catName);
            }
            first = false;
        }
        if (this.isSetOwnerType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ownerType:");
            if (this.ownerType == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.ownerType);
            }
            first = false;
        }
        if (this.isSetWriteId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("writeId:");
            sb.append(this.writeId);
            first = false;
        }
        if (this.isSetIsStatsCompliant()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("isStatsCompliant:");
            sb.append(this.isStatsCompliant);
            first = false;
        }
        if (this.isSetColStats()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("colStats:");
            if (this.colStats == null) {
                sb.append("null");
            } else {
                sb.append(this.colStats);
            }
            first = false;
        }
        if (this.isSetAccessType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("accessType:");
            sb.append(this.accessType);
            first = false;
        }
        if (this.isSetRequiredReadCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("requiredReadCapabilities:");
            if (this.requiredReadCapabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.requiredReadCapabilities);
            }
            first = false;
        }
        if (this.isSetRequiredWriteCapabilities()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("requiredWriteCapabilities:");
            if (this.requiredWriteCapabilities == null) {
                sb.append("null");
            } else {
                sb.append(this.requiredWriteCapabilities);
            }
            first = false;
        }
        if (this.isSetId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("id:");
            sb.append(this.id);
            first = false;
        }
        if (this.isSetFileMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fileMetadata:");
            if (this.fileMetadata == null) {
                sb.append("null");
            } else {
                sb.append(this.fileMetadata);
            }
            first = false;
        }
        if (this.isSetDictionary()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dictionary:");
            if (this.dictionary == null) {
                sb.append("null");
            } else {
                sb.append(this.dictionary);
            }
            first = false;
        }
        if (this.isSetTxnId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("txnId:");
            sb.append(this.txnId);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.sd != null) {
            this.sd.validate();
        }
        if (this.privileges != null) {
            this.privileges.validate();
        }
        if (this.creationMetadata != null) {
            this.creationMetadata.validate();
        }
        if (this.colStats != null) {
            this.colStats.validate();
        }
        if (this.fileMetadata != null) {
            this.fileMetadata.validate();
        }
        if (this.dictionary != null) {
            this.dictionary.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_NAME, new FieldMetaData("tableName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER, new FieldMetaData("owner", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CREATE_TIME, new FieldMetaData("createTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.LAST_ACCESS_TIME, new FieldMetaData("lastAccessTime", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.RETENTION, new FieldMetaData("retention", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SD, new FieldMetaData("sd", 3, (FieldValueMetaData)new StructMetaData(12, StorageDescriptor.class)));
        tmpMap.put(_Fields.PARTITION_KEYS, new FieldMetaData("partitionKeys", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
        tmpMap.put(_Fields.PARAMETERS, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.VIEW_ORIGINAL_TEXT, new FieldMetaData("viewOriginalText", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VIEW_EXPANDED_TEXT, new FieldMetaData("viewExpandedText", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_TYPE, new FieldMetaData("tableType", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PRIVILEGES, new FieldMetaData("privileges", 2, (FieldValueMetaData)new StructMetaData(12, PrincipalPrivilegeSet.class)));
        tmpMap.put(_Fields.TEMPORARY, new FieldMetaData("temporary", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.REWRITE_ENABLED, new FieldMetaData("rewriteEnabled", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.CREATION_METADATA, new FieldMetaData("creationMetadata", 2, (FieldValueMetaData)new StructMetaData(12, CreationMetadata.class)));
        tmpMap.put(_Fields.CAT_NAME, new FieldMetaData("catName", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OWNER_TYPE, new FieldMetaData("ownerType", 2, (FieldValueMetaData)new EnumMetaData(16, PrincipalType.class)));
        tmpMap.put(_Fields.WRITE_ID, new FieldMetaData("writeId", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IS_STATS_COMPLIANT, new FieldMetaData("isStatsCompliant", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COL_STATS, new FieldMetaData("colStats", 2, (FieldValueMetaData)new StructMetaData(12, ColumnStatistics.class)));
        tmpMap.put(_Fields.ACCESS_TYPE, new FieldMetaData("accessType", 2, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.REQUIRED_READ_CAPABILITIES, new FieldMetaData("requiredReadCapabilities", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.REQUIRED_WRITE_CAPABILITIES, new FieldMetaData("requiredWriteCapabilities", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FILE_METADATA, new FieldMetaData("fileMetadata", 2, (FieldValueMetaData)new StructMetaData(12, FileMetadata.class)));
        tmpMap.put(_Fields.DICTIONARY, new FieldMetaData("dictionary", 2, (FieldValueMetaData)new StructMetaData(12, ObjectDictionary.class)));
        tmpMap.put(_Fields.TXN_ID, new FieldMetaData("txnId", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Table.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_NAME(1, "tableName"),
        DB_NAME(2, "dbName"),
        OWNER(3, "owner"),
        CREATE_TIME(4, "createTime"),
        LAST_ACCESS_TIME(5, "lastAccessTime"),
        RETENTION(6, "retention"),
        SD(7, "sd"),
        PARTITION_KEYS(8, "partitionKeys"),
        PARAMETERS(9, "parameters"),
        VIEW_ORIGINAL_TEXT(10, "viewOriginalText"),
        VIEW_EXPANDED_TEXT(11, "viewExpandedText"),
        TABLE_TYPE(12, "tableType"),
        PRIVILEGES(13, "privileges"),
        TEMPORARY(14, "temporary"),
        REWRITE_ENABLED(15, "rewriteEnabled"),
        CREATION_METADATA(16, "creationMetadata"),
        CAT_NAME(17, "catName"),
        OWNER_TYPE(18, "ownerType"),
        WRITE_ID(19, "writeId"),
        IS_STATS_COMPLIANT(20, "isStatsCompliant"),
        COL_STATS(21, "colStats"),
        ACCESS_TYPE(22, "accessType"),
        REQUIRED_READ_CAPABILITIES(23, "requiredReadCapabilities"),
        REQUIRED_WRITE_CAPABILITIES(24, "requiredWriteCapabilities"),
        ID(25, "id"),
        FILE_METADATA(26, "fileMetadata"),
        DICTIONARY(27, "dictionary"),
        TXN_ID(28, "txnId");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_NAME;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return OWNER;
                }
                case 4: {
                    return CREATE_TIME;
                }
                case 5: {
                    return LAST_ACCESS_TIME;
                }
                case 6: {
                    return RETENTION;
                }
                case 7: {
                    return SD;
                }
                case 8: {
                    return PARTITION_KEYS;
                }
                case 9: {
                    return PARAMETERS;
                }
                case 10: {
                    return VIEW_ORIGINAL_TEXT;
                }
                case 11: {
                    return VIEW_EXPANDED_TEXT;
                }
                case 12: {
                    return TABLE_TYPE;
                }
                case 13: {
                    return PRIVILEGES;
                }
                case 14: {
                    return TEMPORARY;
                }
                case 15: {
                    return REWRITE_ENABLED;
                }
                case 16: {
                    return CREATION_METADATA;
                }
                case 17: {
                    return CAT_NAME;
                }
                case 18: {
                    return OWNER_TYPE;
                }
                case 19: {
                    return WRITE_ID;
                }
                case 20: {
                    return IS_STATS_COMPLIANT;
                }
                case 21: {
                    return COL_STATS;
                }
                case 22: {
                    return ACCESS_TYPE;
                }
                case 23: {
                    return REQUIRED_READ_CAPABILITIES;
                }
                case 24: {
                    return REQUIRED_WRITE_CAPABILITIES;
                }
                case 25: {
                    return ID;
                }
                case 26: {
                    return FILE_METADATA;
                }
                case 27: {
                    return DICTIONARY;
                }
                case 28: {
                    return TXN_ID;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TableStandardSchemeFactory
    implements SchemeFactory {
        private TableStandardSchemeFactory() {
        }

        public TableStandardScheme getScheme() {
            return new TableStandardScheme();
        }
    }

    private static class TableTupleSchemeFactory
    implements SchemeFactory {
        private TableTupleSchemeFactory() {
        }

        public TableTupleScheme getScheme() {
            return new TableTupleScheme();
        }
    }

    private static class TableTupleScheme
    extends TupleScheme<Table> {
        private TableTupleScheme() {
        }

        public void write(TProtocol prot, Table struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTableName()) {
                optionals.set(0);
            }
            if (struct.isSetDbName()) {
                optionals.set(1);
            }
            if (struct.isSetOwner()) {
                optionals.set(2);
            }
            if (struct.isSetCreateTime()) {
                optionals.set(3);
            }
            if (struct.isSetLastAccessTime()) {
                optionals.set(4);
            }
            if (struct.isSetRetention()) {
                optionals.set(5);
            }
            if (struct.isSetSd()) {
                optionals.set(6);
            }
            if (struct.isSetPartitionKeys()) {
                optionals.set(7);
            }
            if (struct.isSetParameters()) {
                optionals.set(8);
            }
            if (struct.isSetViewOriginalText()) {
                optionals.set(9);
            }
            if (struct.isSetViewExpandedText()) {
                optionals.set(10);
            }
            if (struct.isSetTableType()) {
                optionals.set(11);
            }
            if (struct.isSetPrivileges()) {
                optionals.set(12);
            }
            if (struct.isSetTemporary()) {
                optionals.set(13);
            }
            if (struct.isSetRewriteEnabled()) {
                optionals.set(14);
            }
            if (struct.isSetCreationMetadata()) {
                optionals.set(15);
            }
            if (struct.isSetCatName()) {
                optionals.set(16);
            }
            if (struct.isSetOwnerType()) {
                optionals.set(17);
            }
            if (struct.isSetWriteId()) {
                optionals.set(18);
            }
            if (struct.isSetIsStatsCompliant()) {
                optionals.set(19);
            }
            if (struct.isSetColStats()) {
                optionals.set(20);
            }
            if (struct.isSetAccessType()) {
                optionals.set(21);
            }
            if (struct.isSetRequiredReadCapabilities()) {
                optionals.set(22);
            }
            if (struct.isSetRequiredWriteCapabilities()) {
                optionals.set(23);
            }
            if (struct.isSetId()) {
                optionals.set(24);
            }
            if (struct.isSetFileMetadata()) {
                optionals.set(25);
            }
            if (struct.isSetDictionary()) {
                optionals.set(26);
            }
            if (struct.isSetTxnId()) {
                optionals.set(27);
            }
            oprot.writeBitSet(optionals, 28);
            if (struct.isSetTableName()) {
                oprot.writeString(struct.tableName);
            }
            if (struct.isSetDbName()) {
                oprot.writeString(struct.dbName);
            }
            if (struct.isSetOwner()) {
                oprot.writeString(struct.owner);
            }
            if (struct.isSetCreateTime()) {
                oprot.writeI32(struct.createTime);
            }
            if (struct.isSetLastAccessTime()) {
                oprot.writeI32(struct.lastAccessTime);
            }
            if (struct.isSetRetention()) {
                oprot.writeI32(struct.retention);
            }
            if (struct.isSetSd()) {
                struct.sd.write((TProtocol)oprot);
            }
            if (struct.isSetPartitionKeys()) {
                oprot.writeI32(struct.partitionKeys.size());
                for (FieldSchema fieldSchema : struct.partitionKeys) {
                    fieldSchema.write((TProtocol)oprot);
                }
            }
            if (struct.isSetParameters()) {
                oprot.writeI32(struct.parameters.size());
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetViewOriginalText()) {
                oprot.writeString(struct.viewOriginalText);
            }
            if (struct.isSetViewExpandedText()) {
                oprot.writeString(struct.viewExpandedText);
            }
            if (struct.isSetTableType()) {
                oprot.writeString(struct.tableType);
            }
            if (struct.isSetPrivileges()) {
                struct.privileges.write((TProtocol)oprot);
            }
            if (struct.isSetTemporary()) {
                oprot.writeBool(struct.temporary);
            }
            if (struct.isSetRewriteEnabled()) {
                oprot.writeBool(struct.rewriteEnabled);
            }
            if (struct.isSetCreationMetadata()) {
                struct.creationMetadata.write((TProtocol)oprot);
            }
            if (struct.isSetCatName()) {
                oprot.writeString(struct.catName);
            }
            if (struct.isSetOwnerType()) {
                oprot.writeI32(struct.ownerType.getValue());
            }
            if (struct.isSetWriteId()) {
                oprot.writeI64(struct.writeId);
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeBool(struct.isStatsCompliant);
            }
            if (struct.isSetColStats()) {
                struct.colStats.write((TProtocol)oprot);
            }
            if (struct.isSetAccessType()) {
                oprot.writeByte(struct.accessType);
            }
            if (struct.isSetRequiredReadCapabilities()) {
                oprot.writeI32(struct.requiredReadCapabilities.size());
                for (String string : struct.requiredReadCapabilities) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetRequiredWriteCapabilities()) {
                oprot.writeI32(struct.requiredWriteCapabilities.size());
                for (String string : struct.requiredWriteCapabilities) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetId()) {
                oprot.writeI64(struct.id);
            }
            if (struct.isSetFileMetadata()) {
                struct.fileMetadata.write((TProtocol)oprot);
            }
            if (struct.isSetDictionary()) {
                struct.dictionary.write((TProtocol)oprot);
            }
            if (struct.isSetTxnId()) {
                oprot.writeI64(struct.txnId);
            }
        }

        public void read(TProtocol prot, Table struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(28);
            if (incoming.get(0)) {
                struct.tableName = iprot.readString();
                struct.setTableNameIsSet(true);
            }
            if (incoming.get(1)) {
                struct.dbName = iprot.readString();
                struct.setDbNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.owner = iprot.readString();
                struct.setOwnerIsSet(true);
            }
            if (incoming.get(3)) {
                struct.createTime = iprot.readI32();
                struct.setCreateTimeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.lastAccessTime = iprot.readI32();
                struct.setLastAccessTimeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.retention = iprot.readI32();
                struct.setRetentionIsSet(true);
            }
            if (incoming.get(6)) {
                struct.sd = new StorageDescriptor();
                struct.sd.read((TProtocol)iprot);
                struct.setSdIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list391 = iprot.readListBegin((byte)12);
                struct.partitionKeys = new ArrayList<FieldSchema>(_list391.size);
                for (int _i393 = 0; _i393 < _list391.size; ++_i393) {
                    FieldSchema _elem392 = new FieldSchema();
                    _elem392.read((TProtocol)iprot);
                    struct.partitionKeys.add(_elem392);
                }
                struct.setPartitionKeysIsSet(true);
            }
            if (incoming.get(8)) {
                TMap _map394 = iprot.readMapBegin((byte)11, (byte)11);
                struct.parameters = new HashMap<String, String>(2 * _map394.size);
                for (int _i397 = 0; _i397 < _map394.size; ++_i397) {
                    String _key395 = iprot.readString();
                    String _val396 = iprot.readString();
                    struct.parameters.put(_key395, _val396);
                }
                struct.setParametersIsSet(true);
            }
            if (incoming.get(9)) {
                struct.viewOriginalText = iprot.readString();
                struct.setViewOriginalTextIsSet(true);
            }
            if (incoming.get(10)) {
                struct.viewExpandedText = iprot.readString();
                struct.setViewExpandedTextIsSet(true);
            }
            if (incoming.get(11)) {
                struct.tableType = iprot.readString();
                struct.setTableTypeIsSet(true);
            }
            if (incoming.get(12)) {
                struct.privileges = new PrincipalPrivilegeSet();
                struct.privileges.read((TProtocol)iprot);
                struct.setPrivilegesIsSet(true);
            }
            if (incoming.get(13)) {
                struct.temporary = iprot.readBool();
                struct.setTemporaryIsSet(true);
            }
            if (incoming.get(14)) {
                struct.rewriteEnabled = iprot.readBool();
                struct.setRewriteEnabledIsSet(true);
            }
            if (incoming.get(15)) {
                struct.creationMetadata = new CreationMetadata();
                struct.creationMetadata.read((TProtocol)iprot);
                struct.setCreationMetadataIsSet(true);
            }
            if (incoming.get(16)) {
                struct.catName = iprot.readString();
                struct.setCatNameIsSet(true);
            }
            if (incoming.get(17)) {
                struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                struct.setOwnerTypeIsSet(true);
            }
            if (incoming.get(18)) {
                struct.writeId = iprot.readI64();
                struct.setWriteIdIsSet(true);
            }
            if (incoming.get(19)) {
                struct.isStatsCompliant = iprot.readBool();
                struct.setIsStatsCompliantIsSet(true);
            }
            if (incoming.get(20)) {
                struct.colStats = new ColumnStatistics();
                struct.colStats.read((TProtocol)iprot);
                struct.setColStatsIsSet(true);
            }
            if (incoming.get(21)) {
                struct.accessType = iprot.readByte();
                struct.setAccessTypeIsSet(true);
            }
            if (incoming.get(22)) {
                TList _list398 = iprot.readListBegin((byte)11);
                struct.requiredReadCapabilities = new ArrayList<String>(_list398.size);
                for (int _i400 = 0; _i400 < _list398.size; ++_i400) {
                    String _elem399 = iprot.readString();
                    struct.requiredReadCapabilities.add(_elem399);
                }
                struct.setRequiredReadCapabilitiesIsSet(true);
            }
            if (incoming.get(23)) {
                TList _list401 = iprot.readListBegin((byte)11);
                struct.requiredWriteCapabilities = new ArrayList<String>(_list401.size);
                for (int _i403 = 0; _i403 < _list401.size; ++_i403) {
                    String _elem402 = iprot.readString();
                    struct.requiredWriteCapabilities.add(_elem402);
                }
                struct.setRequiredWriteCapabilitiesIsSet(true);
            }
            if (incoming.get(24)) {
                struct.id = iprot.readI64();
                struct.setIdIsSet(true);
            }
            if (incoming.get(25)) {
                struct.fileMetadata = new FileMetadata();
                struct.fileMetadata.read((TProtocol)iprot);
                struct.setFileMetadataIsSet(true);
            }
            if (incoming.get(26)) {
                struct.dictionary = new ObjectDictionary();
                struct.dictionary.read((TProtocol)iprot);
                struct.setDictionaryIsSet(true);
            }
            if (incoming.get(27)) {
                struct.txnId = iprot.readI64();
                struct.setTxnIdIsSet(true);
            }
        }
    }

    private static class TableStandardScheme
    extends StandardScheme<Table> {
        private TableStandardScheme() {
        }

        public void read(TProtocol iprot, Table struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.tableName = iprot.readString();
                            struct.setTableNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dbName = iprot.readString();
                            struct.setDbNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.owner = iprot.readString();
                            struct.setOwnerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.createTime = iprot.readI32();
                            struct.setCreateTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.lastAccessTime = iprot.readI32();
                            struct.setLastAccessTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.retention = iprot.readI32();
                            struct.setRetentionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.sd = new StorageDescriptor();
                            struct.sd.read(iprot);
                            struct.setSdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list370 = iprot.readListBegin();
                            struct.partitionKeys = new ArrayList<FieldSchema>(_list370.size);
                            for (int _i372 = 0; _i372 < _list370.size; ++_i372) {
                                FieldSchema _elem371 = new FieldSchema();
                                _elem371.read(iprot);
                                struct.partitionKeys.add(_elem371);
                            }
                            iprot.readListEnd();
                            struct.setPartitionKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 13) {
                            TMap _map373 = iprot.readMapBegin();
                            struct.parameters = new HashMap<String, String>(2 * _map373.size);
                            for (int _i376 = 0; _i376 < _map373.size; ++_i376) {
                                String _key374 = iprot.readString();
                                String _val375 = iprot.readString();
                                struct.parameters.put(_key374, _val375);
                            }
                            iprot.readMapEnd();
                            struct.setParametersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.viewOriginalText = iprot.readString();
                            struct.setViewOriginalTextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.viewExpandedText = iprot.readString();
                            struct.setViewExpandedTextIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.tableType = iprot.readString();
                            struct.setTableTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 12) {
                            struct.privileges = new PrincipalPrivilegeSet();
                            struct.privileges.read(iprot);
                            struct.setPrivilegesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 2) {
                            struct.temporary = iprot.readBool();
                            struct.setTemporaryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 2) {
                            struct.rewriteEnabled = iprot.readBool();
                            struct.setRewriteEnabledIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 12) {
                            struct.creationMetadata = new CreationMetadata();
                            struct.creationMetadata.read(iprot);
                            struct.setCreationMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 11) {
                            struct.catName = iprot.readString();
                            struct.setCatNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 8) {
                            struct.ownerType = PrincipalType.findByValue(iprot.readI32());
                            struct.setOwnerTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 19: {
                        if (schemeField.type == 10) {
                            struct.writeId = iprot.readI64();
                            struct.setWriteIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 20: {
                        if (schemeField.type == 2) {
                            struct.isStatsCompliant = iprot.readBool();
                            struct.setIsStatsCompliantIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 21: {
                        if (schemeField.type == 12) {
                            struct.colStats = new ColumnStatistics();
                            struct.colStats.read(iprot);
                            struct.setColStatsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 22: {
                        if (schemeField.type == 3) {
                            struct.accessType = iprot.readByte();
                            struct.setAccessTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 23: {
                        if (schemeField.type == 15) {
                            TList _list377 = iprot.readListBegin();
                            struct.requiredReadCapabilities = new ArrayList<String>(_list377.size);
                            for (int _i379 = 0; _i379 < _list377.size; ++_i379) {
                                String _elem378 = iprot.readString();
                                struct.requiredReadCapabilities.add(_elem378);
                            }
                            iprot.readListEnd();
                            struct.setRequiredReadCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 24: {
                        if (schemeField.type == 15) {
                            TList _list380 = iprot.readListBegin();
                            struct.requiredWriteCapabilities = new ArrayList<String>(_list380.size);
                            for (int _i382 = 0; _i382 < _list380.size; ++_i382) {
                                String _elem381 = iprot.readString();
                                struct.requiredWriteCapabilities.add(_elem381);
                            }
                            iprot.readListEnd();
                            struct.setRequiredWriteCapabilitiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 25: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 26: {
                        if (schemeField.type == 12) {
                            struct.fileMetadata = new FileMetadata();
                            struct.fileMetadata.read(iprot);
                            struct.setFileMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 27: {
                        if (schemeField.type == 12) {
                            struct.dictionary = new ObjectDictionary();
                            struct.dictionary.read(iprot);
                            struct.setDictionaryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 28: {
                        if (schemeField.type == 10) {
                            struct.txnId = iprot.readI64();
                            struct.setTxnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Table struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.tableName != null) {
                oprot.writeFieldBegin(TABLE_NAME_FIELD_DESC);
                oprot.writeString(struct.tableName);
                oprot.writeFieldEnd();
            }
            if (struct.dbName != null) {
                oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
                oprot.writeString(struct.dbName);
                oprot.writeFieldEnd();
            }
            if (struct.owner != null) {
                oprot.writeFieldBegin(OWNER_FIELD_DESC);
                oprot.writeString(struct.owner);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(CREATE_TIME_FIELD_DESC);
            oprot.writeI32(struct.createTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(LAST_ACCESS_TIME_FIELD_DESC);
            oprot.writeI32(struct.lastAccessTime);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(RETENTION_FIELD_DESC);
            oprot.writeI32(struct.retention);
            oprot.writeFieldEnd();
            if (struct.sd != null) {
                oprot.writeFieldBegin(SD_FIELD_DESC);
                struct.sd.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.partitionKeys != null) {
                oprot.writeFieldBegin(PARTITION_KEYS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partitionKeys.size()));
                for (FieldSchema fieldSchema : struct.partitionKeys) {
                    fieldSchema.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.parameters != null) {
                oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.parameters.size()));
                for (Map.Entry entry : struct.parameters.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.viewOriginalText != null) {
                oprot.writeFieldBegin(VIEW_ORIGINAL_TEXT_FIELD_DESC);
                oprot.writeString(struct.viewOriginalText);
                oprot.writeFieldEnd();
            }
            if (struct.viewExpandedText != null) {
                oprot.writeFieldBegin(VIEW_EXPANDED_TEXT_FIELD_DESC);
                oprot.writeString(struct.viewExpandedText);
                oprot.writeFieldEnd();
            }
            if (struct.tableType != null) {
                oprot.writeFieldBegin(TABLE_TYPE_FIELD_DESC);
                oprot.writeString(struct.tableType);
                oprot.writeFieldEnd();
            }
            if (struct.privileges != null && struct.isSetPrivileges()) {
                oprot.writeFieldBegin(PRIVILEGES_FIELD_DESC);
                struct.privileges.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTemporary()) {
                oprot.writeFieldBegin(TEMPORARY_FIELD_DESC);
                oprot.writeBool(struct.temporary);
                oprot.writeFieldEnd();
            }
            if (struct.isSetRewriteEnabled()) {
                oprot.writeFieldBegin(REWRITE_ENABLED_FIELD_DESC);
                oprot.writeBool(struct.rewriteEnabled);
                oprot.writeFieldEnd();
            }
            if (struct.creationMetadata != null && struct.isSetCreationMetadata()) {
                oprot.writeFieldBegin(CREATION_METADATA_FIELD_DESC);
                struct.creationMetadata.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.catName != null && struct.isSetCatName()) {
                oprot.writeFieldBegin(CAT_NAME_FIELD_DESC);
                oprot.writeString(struct.catName);
                oprot.writeFieldEnd();
            }
            if (struct.ownerType != null && struct.isSetOwnerType()) {
                oprot.writeFieldBegin(OWNER_TYPE_FIELD_DESC);
                oprot.writeI32(struct.ownerType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetWriteId()) {
                oprot.writeFieldBegin(WRITE_ID_FIELD_DESC);
                oprot.writeI64(struct.writeId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsStatsCompliant()) {
                oprot.writeFieldBegin(IS_STATS_COMPLIANT_FIELD_DESC);
                oprot.writeBool(struct.isStatsCompliant);
                oprot.writeFieldEnd();
            }
            if (struct.colStats != null && struct.isSetColStats()) {
                oprot.writeFieldBegin(COL_STATS_FIELD_DESC);
                struct.colStats.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetAccessType()) {
                oprot.writeFieldBegin(ACCESS_TYPE_FIELD_DESC);
                oprot.writeByte(struct.accessType);
                oprot.writeFieldEnd();
            }
            if (struct.requiredReadCapabilities != null && struct.isSetRequiredReadCapabilities()) {
                oprot.writeFieldBegin(REQUIRED_READ_CAPABILITIES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.requiredReadCapabilities.size()));
                for (String string : struct.requiredReadCapabilities) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.requiredWriteCapabilities != null && struct.isSetRequiredWriteCapabilities()) {
                oprot.writeFieldBegin(REQUIRED_WRITE_CAPABILITIES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.requiredWriteCapabilities.size()));
                for (String string : struct.requiredWriteCapabilities) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetId()) {
                oprot.writeFieldBegin(ID_FIELD_DESC);
                oprot.writeI64(struct.id);
                oprot.writeFieldEnd();
            }
            if (struct.fileMetadata != null && struct.isSetFileMetadata()) {
                oprot.writeFieldBegin(FILE_METADATA_FIELD_DESC);
                struct.fileMetadata.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.dictionary != null && struct.isSetDictionary()) {
                oprot.writeFieldBegin(DICTIONARY_FIELD_DESC);
                struct.dictionary.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTxnId()) {
                oprot.writeFieldBegin(TXN_ID_FIELD_DESC);
                oprot.writeI64(struct.txnId);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

