/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.hadoop.hive.metastore.properties.PropertyMap;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.SerializationProxy;

public abstract class PropertyStore {
    public abstract PropertyMap fetchProperties(String var1, Function<String, PropertySchema> var2);

    public abstract Map<String, PropertyMap> selectProperties(String var1, Predicate<String> var2, Function<String, PropertySchema> var3);

    public abstract UUID fetchDigest(String var1);

    public abstract Map<String, UUID> selectDigest(String var1, Predicate<String> var2);

    protected abstract void saveProperties(String var1, PropertyMap var2);

    protected abstract boolean dropProperties(String var1);

    public abstract boolean renameProperties(String var1, String var2);

    public void saveProperties(Iterator<Map.Entry<String, PropertyMap>> save) {
        while (save.hasNext()) {
            Map.Entry<String, PropertyMap> pair = save.next();
            PropertyMap map = pair.getValue();
            if (map != null) {
                this.saveProperties(pair.getKey(), map);
                continue;
            }
            this.dropProperties(pair.getKey());
        }
    }

    public byte[] serialize(PropertyMap map) {
        return SerializationProxy.toBytes(map, new Object[0]);
    }

    public PropertyMap deserialize(byte[] bytes, Function<String, PropertySchema> getSchema) {
        return (PropertyMap)SerializationProxy.fromBytes(bytes, getSchema);
    }

    protected PropertyStore() {
    }
}

