/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimesTenVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TinyIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.StringUtils;

public class TimesTenAdapter
extends BaseDatastoreAdapter {
    public static final String RESERVED_WORDS = "AGING,                  CROSS,           GROUP,ALL,                    CURRENT_SCHEMA,  HAVING,ANY,                    CURRENT_USER,    INNER,AS,                     CURSOR,          INT,BETWEEN,                DATASTORE_OWNER, INTEGER,BIGINT,                 DATE,            INTERSECT,BINARY,                 DEC,             INTERVAL,BINARY_DOUBLE_INFINITY, DECIMAL,         INTO,BINARY_DOUBLE_NAN,      DEFAULT,         IS,BINARY_FLOAT_INFINITY,  DESTROY,         JOIN,BINARY_FLOAT_NAN,       DISTINCT,        LEFT,CASE,                   DOUBLE,          LIKE,CHAR,                   FIRST,           LONG,CHARACTER,              FLOAT,           MINUS,COLUMN,                 FOR,             NATIONAL,CONNECTION,             FOREIGN,         NCHAR,CONSTRAINT,             FROM,            NO,NULL,                   RIGHT,           TINYINT,NUMERIC,                ROWNUM,          TT_SYSDATE,NVARCHAR,               ROWS,            UNION,ON,                     SELECT,          UNIQUE,ORA_SYSDATE,            SELF,            UPDATE,ORDER,                  SESSION_USER,    USER,PRIMARY,                SET,             USING,PROPAGATE,              SMALLINT,        VARBINARY,PUBLIC,                 SOME,            VARCHAR,READONLY,               SYSDATE,         VARYING,REAL,                   SYSTEM_USER,     WHEN,RETURN,                 TIME,            WHERE";

    public TimesTenAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)RESERVED_WORDS));
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.add("UniqueInEndCreateStatements");
        this.supportedOptions.remove("CheckInCreateStatements");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("ANSI_Join_Syntax");
        this.supportedOptions.remove("FkDeleteActionNull");
        this.supportedOptions.remove("FkDeleteActionCascade");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkDeleteActionRestrict");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionRestrict");
        this.supportedOptions.remove("FkUpdateActionNull");
        this.supportedOptions.remove("FkUpdateActionCascade");
        this.supportedOptions.remove("TxIsolationReadUncommitted");
        this.supportedOptions.remove("TxIsolationReadRepeatableRead");
        this.supportedOptions.remove("TxIsolationNone");
    }

    @Override
    public String getVendorID() {
        return "timesten";
    }

    @Override
    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        Index idx = new Index(ck);
        idx.setName(ck.getName());
        return this.getCreateIndexStatement(idx, factory);
    }

    @Override
    public String getAddColumnStatement(Table table, Column col) {
        String stmnt = super.getAddColumnStatement(table, col);
        return stmnt.replaceAll("NOT NULL", "");
    }

    @Override
    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (TimesTenAdapter.isSelfReferencingForeignKey(fk)) {
            return this.getDatastoreDateStatement();
        }
        return super.getAddForeignKeyStatement(fk, factory);
    }

    private static boolean isSelfReferencingForeignKey(ForeignKey fk) {
        if (fk != null) {
            String sql = fk.toString();
            Table obj = fk.getTable();
            if (obj != null) {
                String container = obj.toString();
                return TimesTenAdapter.isSelfReferencingForeignKey(sql, container);
            }
        }
        return false;
    }

    private static boolean isSelfReferencingForeignKey(String sql, String ref) {
        if (sql != null && ref != null) {
            String REFERENCES = "REFERENCES";
            int refi = sql.indexOf("REFERENCES");
            if (refi != -1) {
                String cut = sql.substring(refi + "REFERENCES".length());
                int spacei = cut.trim().indexOf(" ");
                if (spacei != -1) {
                    return cut.substring(0, spacei + 1).trim().equalsIgnoreCase(ref);
                }
                return cut.trim().equalsIgnoreCase(ref);
            }
        }
        return false;
    }

    @Override
    public String getDatastoreDateStatement() {
        return "select tt_sysdate from dual";
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", true);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", true);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "DOUBLE", false);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(Short.class.getName(), TinyIntColumnMapping.class, JDBCType.TINYINT, "TINYINT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), TimesTenVarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), TimesTenVarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INTEGER", false);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        super.loadColumnMappings(mgr, clr);
    }
}

