/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.java;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.rdbms.identifier.DatastoreIdentifier;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.mapping.column.ColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

public class VersionMapping
extends SingleFieldMapping {
    private final JavaTypeMapping delegate;

    public VersionMapping(Table table, JavaTypeMapping delegate) {
        ColumnMetaData colmd;
        this.initialize(table.getStoreManager(), delegate.getType());
        this.delegate = delegate;
        this.table = table;
        VersionMetaData vermd = table.getVersionMetaData();
        ColumnMetaData versionColumnMetaData = vermd.getColumnMetaData();
        IdentifierFactory idFactory = table.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier id = null;
        if (versionColumnMetaData == null) {
            id = idFactory.newVersionFieldIdentifier();
            colmd = new ColumnMetaData();
            colmd.setName(id.getName());
            table.getVersionMetaData().setColumnMetaData(colmd);
        } else {
            colmd = versionColumnMetaData;
            if (colmd.getName() == null) {
                id = idFactory.newVersionFieldIdentifier();
                colmd.setName(id.getName());
            } else {
                id = idFactory.newColumnIdentifier(colmd.getName());
            }
        }
        Column column = table.addColumn(this.getType(), id, this, colmd);
        table.getStoreManager().getMappingManager().createColumnMapping(delegate, column, this.getType());
    }

    @Override
    public boolean includeInFetchStatement() {
        return false;
    }

    @Override
    public int getNumberOfColumnMappings() {
        return this.delegate.getNumberOfColumnMappings();
    }

    @Override
    public ColumnMapping getColumnMapping(int index) {
        return this.delegate.getColumnMapping(index);
    }

    @Override
    public ColumnMapping[] getColumnMappings() {
        return this.delegate.getColumnMappings();
    }

    @Override
    public void addColumnMapping(ColumnMapping colMapping) {
        this.delegate.addColumnMapping(colMapping);
    }

    @Override
    public Class getJavaType() {
        return VersionMapping.class;
    }

    @Override
    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        this.delegate.setObject(ec, ps, exprIndex, value);
    }

    @Override
    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        return this.delegate.getObject(ec, resultSet, exprIndex);
    }

    public static final class VersionLongMapping
    extends VersionMapping {
        public VersionLongMapping(Table datastoreContainer, JavaTypeMapping delegate) {
            super(datastoreContainer, delegate);
        }
    }

    public static final class VersionTimestampMapping
    extends VersionMapping {
        public VersionTimestampMapping(Table table, JavaTypeMapping delegate) {
            super(table, delegate);
        }
    }
}

