/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.ProtocolProxy;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;

public class ProtobufProxy<BlockingInterface> {
    private final Configuration conf;
    private final InetSocketAddress serverAddr;
    private final RetryPolicy retryPolicy;
    private final SocketFactory socketFactory;
    private BlockingInterface proxy;
    private final Class<?> blockingInterfaceClass;
    private UserGroupInformation ugi;

    public ProtobufProxy(Configuration conf, UserGroupInformation ugi, String hostname, int port, @Nullable RetryPolicy retryPolicy, @Nullable SocketFactory socketFactory, Class<?> blockingInterfaceClass) {
        this.conf = conf;
        this.serverAddr = NetUtils.createSocketAddr((String)hostname, (int)port);
        this.retryPolicy = retryPolicy;
        this.socketFactory = socketFactory == null ? NetUtils.getDefaultSocketFactory((Configuration)conf) : socketFactory;
        this.blockingInterfaceClass = blockingInterfaceClass;
        this.ugi = ugi;
    }

    public BlockingInterface getProxy() throws IOException {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private BlockingInterface createProxy() throws IOException {
        RPC.setProtocolEngine((Configuration)this.conf, this.blockingInterfaceClass, ProtobufRpcEngine.class);
        if (this.ugi == null) {
            return this.createProxyInternal();
        }
        try {
            return (BlockingInterface)this.ugi.doAs(new PrivilegedExceptionAction<BlockingInterface>(){

                @Override
                public BlockingInterface run() throws IOException {
                    return ProtobufProxy.this.createProxyInternal();
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private BlockingInterface createProxyInternal() throws IOException {
        ProtocolProxy proxy = RPC.getProtocolProxy(this.blockingInterfaceClass, (long)0L, (InetSocketAddress)this.serverAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)this.conf, (SocketFactory)this.socketFactory, (int)0, (RetryPolicy)this.retryPolicy);
        return (BlockingInterface)proxy.getProxy();
    }
}

