/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.histogram.KllHistogramEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.ColumnsStatsUtils;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongColumnStatsMerger
extends ColumnStatsMerger<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(LongColumnStatsMerger.class);

    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        Long highValue;
        LOG.debug("Merging statistics: [aggregateColStats:{}, newColStats: {}]", (Object)aggregateColStats, (Object)newColStats);
        LongColumnStatsDataInspector aggregateData = ColumnsStatsUtils.longInspectorFromStats(aggregateColStats);
        LongColumnStatsDataInspector newData = ColumnsStatsUtils.longInspectorFromStats(newColStats);
        Long lowValue = this.mergeLowValue(this.getLowValue(aggregateData), this.getLowValue(newData));
        if (lowValue != null) {
            aggregateData.setLowValue(lowValue);
        }
        if ((highValue = this.mergeHighValue(this.getHighValue(aggregateData), this.getHighValue(newData))) != null) {
            aggregateData.setHighValue(highValue);
        }
        aggregateData.setNumNulls(this.mergeNumNulls(aggregateData.getNumNulls(), newData.getNumNulls()));
        NumDistinctValueEstimator oldNDVEst = aggregateData.getNdvEstimator();
        NumDistinctValueEstimator newNDVEst = newData.getNdvEstimator();
        List<NumDistinctValueEstimator> ndvEstimatorsList = Arrays.asList(oldNDVEst, newNDVEst);
        aggregateData.setNumDVs(this.mergeNumDistinctValueEstimator(aggregateColStats.getColName(), ndvEstimatorsList, aggregateData.getNumDVs(), newData.getNumDVs()));
        aggregateData.setNdvEstimator(ndvEstimatorsList.get(0));
        KllHistogramEstimator oldKllEst = aggregateData.getHistogramEstimator();
        KllHistogramEstimator newKllEst = newData.getHistogramEstimator();
        aggregateData.setHistogramEstimator(this.mergeHistogramEstimator(aggregateColStats.getColName(), oldKllEst, newKllEst));
        aggregateColStats.getStatsData().setLongStats((LongColumnStatsData)aggregateData);
    }

    public Long getLowValue(LongColumnStatsDataInspector data) {
        return data.isSetLowValue() ? Long.valueOf(data.getLowValue()) : null;
    }

    public Long getHighValue(LongColumnStatsDataInspector data) {
        return data.isSetHighValue() ? Long.valueOf(data.getHighValue()) : null;
    }

    @Override
    public Long mergeLowValue(Long oldValue, Long newValue) {
        if (oldValue != null && newValue != null) {
            return Math.min(oldValue, newValue);
        }
        if (oldValue != null) {
            return oldValue;
        }
        return newValue;
    }

    @Override
    public Long mergeHighValue(Long oldValue, Long newValue) {
        if (oldValue != null && newValue != null) {
            return Math.max(oldValue, newValue);
        }
        if (oldValue != null) {
            return oldValue;
        }
        return newValue;
    }
}

