/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.WriteNotificationLogRequest;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.utils.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class BatchAcidWriteEvent
extends ListenerEvent {
    private final List<WriteNotificationLogRequest> writeNotificationLogRequestList = new ArrayList<WriteNotificationLogRequest>();
    private final List<String> partitionList = new ArrayList<String>();
    private final List<Table> tableObjList = new ArrayList<Table>();
    private final List<Partition> partitionObjList = new ArrayList<Partition>();

    public BatchAcidWriteEvent(String partition, Table tableObj, Partition partitionObj, WriteNotificationLogRequest writeNotificationLogRequest) {
        super(true, null);
        this.addNotification(partition, tableObj, partitionObj, writeNotificationLogRequest);
    }

    public BatchAcidWriteEvent() {
        super(true, null);
    }

    public void addNotification(String partition, Table tableObj, Partition partitionObj, WriteNotificationLogRequest writeNotificationLogRequest) {
        this.writeNotificationLogRequestList.add(writeNotificationLogRequest);
        this.partitionList.add(partition);
        this.tableObjList.add(tableObj);
        this.partitionObjList.add(partitionObj);
    }

    public Long getTxnId(int idx) {
        return this.writeNotificationLogRequestList.get(idx).getTxnId();
    }

    public List<String> getFiles(int idx) {
        return this.writeNotificationLogRequestList.get(idx).getFileInfo().getFilesAdded();
    }

    public List<String> getChecksums(int idx) {
        return this.writeNotificationLogRequestList.get(idx).getFileInfo().getFilesAddedChecksum();
    }

    public String getDatabase(int idx) {
        return StringUtils.normalizeIdentifier((String)this.writeNotificationLogRequestList.get(idx).getDb());
    }

    public String getTable(int idx) {
        return StringUtils.normalizeIdentifier((String)this.writeNotificationLogRequestList.get(idx).getTable());
    }

    public String getPartition(int idx) {
        return this.partitionList.get(idx);
    }

    public Long getWriteId(int idx) {
        return this.writeNotificationLogRequestList.get(idx).getWriteId();
    }

    public Table getTableObj(int idx) {
        return this.tableObjList.get(idx);
    }

    public Partition getPartitionObj(int idx) {
        return this.partitionObjList.get(idx);
    }

    public List<String> getSubDirs(int idx) {
        return this.writeNotificationLogRequestList.get(idx).getFileInfo().getSubDirectoryList();
    }

    public WriteNotificationLogRequest getNotificationRequest(int idx) {
        return this.writeNotificationLogRequestList.get(idx);
    }

    public int getNumRequest() {
        return this.writeNotificationLogRequestList.size();
    }
}

