/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.function.Function;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class RemoveCompactionMetricsDataCommand
implements ParameterizedCommand {
    private static final String DELETE_COMPACTION_METRICS_CACHE = "DELETE FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_DATABASE\" = :db AND \"CMC_TABLE\" = :table AND \"CMC_METRIC_TYPE\" = :type AND (:partition IS NULL OR \"CMC_PARTITION\" = :partition)";
    private final String dbName;
    private final String tblName;
    private final String partitionName;
    private final CompactionMetricsData.MetricType type;

    public RemoveCompactionMetricsDataCommand(String dbName, String tblName, String partitionName, CompactionMetricsData.MetricType type) {
        this.dbName = dbName;
        this.tblName = tblName;
        this.partitionName = partitionName;
        this.type = type;
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return null;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return DELETE_COMPACTION_METRICS_CACHE;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("db", (Object)this.dbName).addValue("table", (Object)this.tblName).addValue("type", (Object)this.type.toString()).addValue("partition", (Object)this.partitionName, 12);
    }
}

