/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.tools.SQLGenerator;
import org.apache.hadoop.hive.metastore.txn.MetaWrapperException;
import org.apache.hadoop.hive.metastore.txn.entities.LockInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetLocksByLockId
implements QueryHandler<List<LockInfo>> {
    private static final String noSelectQuery = " \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_TXNID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = :extLockId";
    private final long extLockId;
    private final int limit;
    private final SQLGenerator sqlGenerator;

    public GetLocksByLockId(long extLockId, int limit, SQLGenerator sqlGenerator) {
        this.extLockId = extLockId;
        this.limit = limit;
        this.sqlGenerator = sqlGenerator;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        if (this.limit > 0) {
            return this.sqlGenerator.addLimitClause(this.limit, noSelectQuery);
        }
        return "SELECT  \"HL_LOCK_EXT_ID\", \"HL_LOCK_INT_ID\", \"HL_DB\", \"HL_TABLE\", \"HL_PARTITION\", \"HL_LOCK_STATE\", \"HL_LOCK_TYPE\", \"HL_TXNID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LOCK_EXT_ID\" = :extLockId";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("extLockId", (Object)this.extLockId);
    }

    public List<LockInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<LockInfo> result = new ArrayList<LockInfo>();
        while (rs.next()) {
            try {
                result.add(new LockInfo(rs));
            }
            catch (MetaException e) {
                throw new MetaWrapperException(e);
            }
        }
        return result;
    }
}

