/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.shared.common.error.ErrorStringBuilder;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.PassThroughException;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.LocaleFinder;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public class ContextManager {
    private final HashMap<String, CtxStack> ctxTable = new HashMap();
    private final ArrayList<Context> holder = new ArrayList();
    private Locale messageLocale;
    final ContextService owningCsf;
    private int logSeverityLevel;
    private int extDiagSeverityLevel;
    private HeaderPrintWriter errorStream;
    private ErrorStringBuilder errorStringBuilder;
    private String threadDump;
    private boolean shutdown;
    private LocaleFinder finder;
    Thread activeThread;
    int activeCount;

    public void pushContext(Context context) {
        this.checkInterrupt();
        String string = context.getIdName();
        CtxStack ctxStack = this.ctxTable.get(string);
        if (ctxStack == null) {
            ctxStack = new CtxStack();
            this.ctxTable.put(string, ctxStack);
        }
        ctxStack.push(context);
        this.holder.add(context);
    }

    public Context getContext(String string) {
        this.checkInterrupt();
        CtxStack ctxStack = this.ctxTable.get(string);
        return ctxStack == null ? null : ctxStack.top();
    }

    public void popContext() {
        this.checkInterrupt();
        if (this.holder.isEmpty()) {
            return;
        }
        Context context = this.holder.remove(this.holder.size() - 1);
        String string = context.getIdName();
        CtxStack ctxStack = this.ctxTable.get(string);
        ctxStack.pop();
    }

    void popContext(Context context) {
        this.checkInterrupt();
        this.holder.remove(this.holder.lastIndexOf(context));
        String string = context.getIdName();
        CtxStack ctxStack = this.ctxTable.get(string);
        ctxStack.remove(context);
    }

    final boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public final List<Context> getContextStack(String string) {
        CtxStack ctxStack = this.ctxTable.get(string);
        return ctxStack == null ? Collections.emptyList() : ctxStack.getUnmodifiableList();
    }

    public boolean cleanupOnError(Throwable throwable, boolean bl) {
        boolean bl2;
        if (this.shutdown) {
            return true;
        }
        if (this.errorStringBuilder == null) {
            this.errorStringBuilder = new ErrorStringBuilder(this.errorStream.getHeader());
        }
        ThreadDeath threadDeath = null;
        if (throwable instanceof ThreadDeath) {
            threadDeath = (ThreadDeath)throwable;
        }
        if (throwable instanceof PassThroughException) {
            throwable = throwable.getCause();
        }
        if (bl2 = this.reportError(throwable)) {
            ContextImpl contextImpl;
            Object object;
            StringBuffer stringBuffer = null;
            if (!this.shutdown && (object = (ContextImpl)this.getContext("LanguageConnectionContext")) != null) {
                stringBuffer = ((ContextImpl)object).appendErrorInfo();
            }
            object = "Cleanup action starting";
            if (stringBuffer != null) {
                stringBuffer.append((String)object);
                object = stringBuffer.toString();
            }
            this.errorStringBuilder.appendln((String)object);
            if (!this.shutdown && (contextImpl = (ContextImpl)this.getContext("StatementContext")) != null && (stringBuffer = contextImpl.appendErrorInfo()) != null) {
                this.errorStringBuilder.appendln(stringBuffer.toString());
            }
        }
        block3: while (true) {
            int n = this.getErrorSeverity(throwable);
            if (bl2) {
                this.errorStringBuilder.stackTrace(throwable);
                this.flushErrorString();
            }
            boolean bl3 = false;
            for (int i = this.holder.size() - 1; i >= 0; --i) {
                try {
                    if (bl3) break block3;
                    Context context = this.holder.get(i);
                    bl3 = context.isLastHandler(n);
                    context.cleanupOnError(throwable);
                    if (bl2 && bl && n >= this.extDiagSeverityLevel) {
                        this.threadDump = ExceptionUtil.dumpThreads();
                        continue;
                    }
                    this.threadDump = null;
                    continue;
                }
                catch (StandardException standardException) {
                    if (throwable instanceof StandardException && standardException.getSeverity() > ((StandardException)throwable).getSeverity()) {
                        throwable = standardException;
                        bl2 = this.reportError(standardException);
                        if (!bl2) continue block3;
                        this.errorStream.println("New exception raised during cleanup " + throwable.getMessage());
                        this.errorStream.flush();
                        continue block3;
                    }
                    if (!this.reportError(standardException)) continue;
                    this.errorStringBuilder.appendln("Less severe exception raised during cleanup (ignored) " + standardException.getMessage());
                    this.errorStringBuilder.stackTrace((Throwable)standardException);
                    this.flushErrorString();
                    continue;
                }
                catch (Throwable throwable2) {
                    bl2 = this.reportError(throwable2);
                    if (throwable instanceof StandardException) {
                        throwable = throwable2;
                        if (!bl2) continue block3;
                        this.errorStream.println("New exception raised during cleanup " + throwable.getMessage());
                        this.errorStream.flush();
                        continue block3;
                    }
                    if (bl2) {
                        this.errorStringBuilder.appendln("Equally severe exception raised during cleanup (ignored) " + throwable2.getMessage());
                        this.errorStringBuilder.stackTrace(throwable2);
                        this.flushErrorString();
                    }
                    if (!(throwable2 instanceof ThreadDeath)) continue;
                    if (threadDeath != null) {
                        throw threadDeath;
                    }
                    threadDeath = (ThreadDeath)throwable2;
                }
            }
            break;
        }
        if (this.threadDump != null) {
            this.errorStream.println(this.threadDump);
            JVMInfo.javaDump();
        }
        if (bl2) {
            this.errorStream.println("Cleanup action completed");
            this.errorStream.flush();
        }
        if (threadDeath != null) {
            throw threadDeath;
        }
        return false;
    }

    synchronized boolean setInterrupted(Context context) {
        boolean bl;
        boolean bl2 = bl = context == null || this.holder.contains(context);
        if (bl) {
            this.shutdown = true;
        }
        return bl;
    }

    private void checkInterrupt() {
        if (this.shutdown) {
            throw new ShutdownException();
        }
    }

    public void setLocaleFinder(LocaleFinder localeFinder) {
        this.finder = localeFinder;
    }

    public void setMessageLocale(String string) throws StandardException {
        this.messageLocale = Monitor.getLocaleFromString(string);
    }

    public Locale getMessageLocale() {
        if (this.messageLocale != null) {
            return this.messageLocale;
        }
        if (this.finder != null) {
            try {
                return this.finder.getCurrentLocale();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        return Locale.getDefault();
    }

    private void flushErrorString() {
        this.errorStream.print(this.errorStringBuilder.get().toString());
        this.errorStream.flush();
        this.errorStringBuilder.reset();
    }

    private boolean reportError(Throwable throwable) {
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            switch (standardException.report()) {
                case 0: {
                    int n = standardException.getSeverity();
                    return n >= this.logSeverityLevel || n == 0;
                }
                case 1: {
                    return false;
                }
            }
            return true;
        }
        return !(throwable instanceof ShutdownException);
    }

    public int getErrorSeverity(Throwable throwable) {
        if (throwable instanceof StandardException) {
            return ((StandardException)throwable).getErrorCode();
        }
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getErrorCode();
        }
        return 0;
    }

    ContextManager(ContextService contextService, HeaderPrintWriter headerPrintWriter) {
        this.errorStream = headerPrintWriter;
        this.owningCsf = contextService;
        this.logSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.logSeverityLevel", 40000);
        this.extDiagSeverityLevel = PropertyUtil.getSystemInt("derby.stream.error.extendedDiagSeverityLevel", 40000);
    }

    private static final class CtxStack {
        private final ArrayList<Context> stack_ = new ArrayList();
        private final List<Context> view_ = Collections.unmodifiableList(this.stack_);
        private Context top_ = null;

        private CtxStack() {
        }

        void push(Context context) {
            this.stack_.add(context);
            this.top_ = context;
        }

        void pop() {
            this.stack_.remove(this.stack_.size() - 1);
            this.top_ = this.stack_.isEmpty() ? null : this.stack_.get(this.stack_.size() - 1);
        }

        void remove(Context context) {
            if (context == this.top_) {
                this.pop();
                return;
            }
            this.stack_.remove(this.stack_.lastIndexOf(context));
        }

        Context top() {
            return this.top_;
        }

        boolean isEmpty() {
            return this.stack_.isEmpty();
        }

        List<Context> getUnmodifiableList() {
            return this.view_;
        }
    }
}

