/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.client.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;

public class HiveMetaStoreClientUtils {
    public static Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    public static Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    public static Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    public static Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    public static FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    public static Function deepCopy(Function func) {
        Function copy = null;
        if (func != null) {
            copy = new Function(func);
        }
        return copy;
    }

    public static PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    public static List<Partition> deepCopyPartitions(List<Partition> partitions) {
        return HiveMetaStoreClientUtils.deepCopyPartitions(partitions, null);
    }

    public static List<Partition> deepCopyPartitions(Collection<Partition> src, List<Partition> dest) {
        if (src == null) {
            return dest;
        }
        if (dest == null) {
            dest = new ArrayList<Partition>(src.size());
        }
        for (Partition part : src) {
            dest.add(HiveMetaStoreClientUtils.deepCopy(part));
        }
        return dest;
    }

    public static List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(HiveMetaStoreClientUtils.deepCopy(tab));
            }
        }
        return copy;
    }

    public static List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(HiveMetaStoreClientUtils.deepCopy(schema));
            }
        }
        return copy;
    }

    public static String getValidWriteIdList(String dbName, String tblName, Configuration conf) {
        String validTableWriteIdsKey = conf.get("hive.txn.tables.valid.writeids");
        if (validTableWriteIdsKey == null) {
            return null;
        }
        ValidTxnWriteIdList validTxnWriteIdList = ValidTxnWriteIdList.fromValue((String)validTableWriteIdsKey);
        ValidWriteIdList writeIdList = validTxnWriteIdList.getTableValidWriteIdList(TableName.getDbTable((String)dbName, (String)tblName));
        return writeIdList != null ? writeIdList.toString() : null;
    }

    public static short shrinkMaxtoShort(int max) {
        if (max < 0) {
            return -1;
        }
        if (max <= Short.MAX_VALUE) {
            return (short)max;
        }
        return Short.MAX_VALUE;
    }
}

