/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.lang.reflect.Array;
import java.util.Comparator;

public class IncludeMinMax {
    public static DoublesPair includeDoublesMinMax(double[] quantilesIn, long[] cumWeightsIn, double maxItem, double minItem) {
        long[] adjCumWeights;
        double[] adjQuantiles;
        int lenIn = cumWeightsIn.length;
        boolean adjLow = quantilesIn[0] != minItem;
        boolean adjHigh = quantilesIn[lenIn - 1] != maxItem;
        int adjLen = lenIn;
        adjLen += adjLow ? 1 : 0;
        if ((adjLen += adjHigh ? 1 : 0) > lenIn) {
            adjQuantiles = new double[adjLen];
            adjCumWeights = new long[adjLen];
            int offset = adjLow ? 1 : 0;
            System.arraycopy(quantilesIn, 0, adjQuantiles, offset, lenIn);
            System.arraycopy(cumWeightsIn, 0, adjCumWeights, offset, lenIn);
            if (adjLow) {
                adjQuantiles[0] = minItem;
                adjCumWeights[0] = 1L;
            }
            if (adjHigh) {
                adjQuantiles[adjLen - 1] = maxItem;
                adjCumWeights[adjLen - 1] = cumWeightsIn[lenIn - 1];
                adjCumWeights[adjLen - 2] = cumWeightsIn[lenIn - 1] - 1L;
            }
        } else {
            adjQuantiles = quantilesIn;
            adjCumWeights = cumWeightsIn;
        }
        return new DoublesPair(adjQuantiles, adjCumWeights);
    }

    public static FloatsPair includeFloatsMinMax(float[] quantilesIn, long[] cumWeightsIn, float maxItem, float minItem) {
        long[] adjCumWeights;
        float[] adjQuantiles;
        int lenIn = cumWeightsIn.length;
        boolean adjLow = quantilesIn[0] != minItem;
        boolean adjHigh = quantilesIn[lenIn - 1] != maxItem;
        int adjLen = lenIn;
        adjLen += adjLow ? 1 : 0;
        if ((adjLen += adjHigh ? 1 : 0) > lenIn) {
            adjQuantiles = new float[adjLen];
            adjCumWeights = new long[adjLen];
            int offset = adjLow ? 1 : 0;
            System.arraycopy(quantilesIn, 0, adjQuantiles, offset, lenIn);
            System.arraycopy(cumWeightsIn, 0, adjCumWeights, offset, lenIn);
            if (adjLow) {
                adjQuantiles[0] = minItem;
                adjCumWeights[0] = 1L;
            }
            if (adjHigh) {
                adjQuantiles[adjLen - 1] = maxItem;
                adjCumWeights[adjLen - 1] = cumWeightsIn[lenIn - 1];
                adjCumWeights[adjLen - 2] = cumWeightsIn[lenIn - 1] - 1L;
            }
        } else {
            adjQuantiles = quantilesIn;
            adjCumWeights = cumWeightsIn;
        }
        return new FloatsPair(adjQuantiles, adjCumWeights);
    }

    public static <T> ItemsPair<T> includeItemsMinMax(T[] quantilesIn, long[] cumWeightsIn, T maxItem, T minItem, Comparator<? super T> comparator) {
        long[] adjCumWeights;
        Object[] adjQuantiles;
        int lenIn = cumWeightsIn.length;
        boolean adjLow = comparator.compare(quantilesIn[0], minItem) != 0;
        boolean adjHigh = comparator.compare(quantilesIn[lenIn - 1], maxItem) != 0;
        int adjLen = lenIn;
        adjLen += adjLow ? 1 : 0;
        if ((adjLen += adjHigh ? 1 : 0) > lenIn) {
            adjQuantiles = (Object[])Array.newInstance(minItem.getClass(), adjLen);
            adjCumWeights = new long[adjLen];
            int offset = adjLow ? 1 : 0;
            System.arraycopy(quantilesIn, 0, adjQuantiles, offset, lenIn);
            System.arraycopy(cumWeightsIn, 0, adjCumWeights, offset, lenIn);
            if (adjLow) {
                adjQuantiles[0] = minItem;
                adjCumWeights[0] = 1L;
            }
            if (adjHigh) {
                adjQuantiles[adjLen - 1] = maxItem;
                adjCumWeights[adjLen - 1] = cumWeightsIn[lenIn - 1];
                adjCumWeights[adjLen - 2] = cumWeightsIn[lenIn - 1] - 1L;
            }
        } else {
            adjQuantiles = quantilesIn;
            adjCumWeights = cumWeightsIn;
        }
        return new ItemsPair<T>(adjQuantiles, adjCumWeights);
    }

    public static class ItemsPair<T> {
        public T[] quantiles;
        public long[] cumWeights;

        public ItemsPair(T[] quantiles, long[] cumWeights) {
            this.quantiles = quantiles;
            this.cumWeights = cumWeights;
        }
    }

    public static class FloatsPair {
        public float[] quantiles;
        public long[] cumWeights;

        public FloatsPair(float[] quantiles, long[] cumWeights) {
            this.quantiles = quantiles;
            this.cumWeights = cumWeights;
        }
    }

    public static class DoublesPair {
        public double[] quantiles;
        public long[] cumWeights;

        public DoublesPair(double[] quantiles, long[] cumWeights) {
            this.quantiles = quantiles;
            this.cumWeights = cumWeights;
        }
    }
}

