/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.desc;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Describe Connector", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class DescDataConnectorDesc
implements DDLDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DESC_DATACONNECTOR_SCHEMA = "name,type,url,owner_name,owner_type,comment#string:string:string:string:string:string";
    public static final String DESC_DATACONNECTOR_SCHEMA_EXTENDED = "name,type,url,owner_name,owner_type,comment,parameters#string:string:string:string:string:string,string";
    private final String resFile;
    private final String dcName;
    private final boolean isExtended;

    public DescDataConnectorDesc(Path resFile, String dcName, boolean isExtended) {
        this.resFile = resFile.toString();
        this.dcName = dcName;
        this.isExtended = isExtended;
    }

    @Explain(displayName="extended", displayOnlyOnTrue=true, explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isExtended() {
        return this.isExtended;
    }

    @Explain(displayName="connector", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getConnectorName() {
        return this.dcName;
    }

    @Explain(displayName="result file", explainLevels={Explain.Level.EXTENDED})
    public String getResFile() {
        return this.resFile;
    }

    public String getSchema() {
        return this.isExtended ? DESC_DATACONNECTOR_SCHEMA_EXTENDED : DESC_DATACONNECTOR_SCHEMA;
    }
}

