/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege.role.grant;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.privilege.PrivilegeUtils;
import org.apache.hadoop.hive.ql.ddl.privilege.role.grant.GrantRoleDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;

public class GrantRoleOperation
extends DDLOperation<GrantRoleDesc> {
    public GrantRoleOperation(DDLOperationContext context, GrantRoleDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        HiveAuthorizer authorizer = PrivilegeUtils.getSessionAuthorizer(this.context.getConf());
        List<HivePrincipal> principals = AuthorizationUtils.getHivePrincipals(((GrantRoleDesc)this.desc).getPrincipals(), PrivilegeUtils.getAuthorizationTranslator(authorizer));
        HivePrincipal grantorPrincipal = null;
        if (((GrantRoleDesc)this.desc).getGrantor() != null) {
            grantorPrincipal = new HivePrincipal(((GrantRoleDesc)this.desc).getGrantor(), AuthorizationUtils.getHivePrincipalType(PrincipalType.USER));
        }
        authorizer.grantRole(principals, ((GrantRoleDesc)this.desc).getRoles(), ((GrantRoleDesc)this.desc).isGrantOption(), grantorPrincipal);
        return 0;
    }
}

