/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;

public class BinaryRecordReader
implements RecordReader {
    private InputStream in;
    private BytesWritable bytes;
    private int maxRecordLength;

    @Override
    public void initialize(InputStream in, Configuration conf, Properties tbl) throws IOException {
        this.in = in;
        this.maxRecordLength = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_BINARY_RECORD_MAX);
    }

    @Override
    public Writable createRow() throws IOException {
        this.bytes = new BytesWritable();
        this.bytes.setCapacity(this.maxRecordLength);
        return this.bytes;
    }

    @Override
    public int next(Writable row) throws IOException {
        int recordLength = this.in.read(this.bytes.get(), 0, this.maxRecordLength);
        if (recordLength >= 0) {
            this.bytes.setSize(recordLength);
        }
        return recordLength;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

