/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.tez.HashableInputSplit;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.SplitLocationProvider;
import org.apache.hive.common.util.Murmur3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAffinitySplitLocationProvider
implements SplitLocationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HostAffinitySplitLocationProvider.class);
    @VisibleForTesting
    final List<String> locations;

    public HostAffinitySplitLocationProvider(List<String> knownLocations) {
        Preconditions.checkState((knownLocations != null && !knownLocations.isEmpty() ? 1 : 0) != 0, (Object)(HostAffinitySplitLocationProvider.class.getName() + " needs at least 1 location to function"));
        this.locations = knownLocations;
    }

    public String[] getLocations(InputSplit split) throws IOException {
        String[] stringArray;
        if (!(split instanceof FileSplit)) {
            LOG.debug("Split: {} is not a FileSplit. Using default locations", (Object)split);
            return split.getLocations();
        }
        FileSplit fsplit = (FileSplit)split;
        String location = this.locations.get(HostAffinitySplitLocationProvider.determineLocation(this.locations, fsplit));
        if (location != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = location;
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @VisibleForTesting
    public static int determineLocation(List<String> locations, FileSplit fsplit) {
        byte[] bytes = HostAffinitySplitLocationProvider.getHashInputForSplit(fsplit);
        long hash1 = HostAffinitySplitLocationProvider.hash1(bytes);
        int index = Hashing.consistentHash((long)hash1, (int)locations.size());
        String location = locations.get(index);
        LOG.debug("{} mapped to index={}, location={}", new Object[]{HostAffinitySplitLocationProvider.getSplitDescForDebug(fsplit), index, location});
        long hash2 = 0L;
        for (int iter = 1; location == null && iter < locations.size() * 2; ++iter) {
            if (iter == 1) {
                hash2 = HostAffinitySplitLocationProvider.hash2(bytes);
            }
            index = Hashing.consistentHash((long)(hash1 + (long)iter * hash2), (int)locations.size());
            location = locations.get(index);
            LOG.debug("{} remapped to index={}, location={}", new Object[]{HostAffinitySplitLocationProvider.getSplitDescForDebug(fsplit), index, location});
        }
        return index;
    }

    private static byte[] getHashInputForSplit(FileSplit fsplit) {
        if (fsplit instanceof HashableInputSplit) {
            return ((HashableInputSplit)fsplit).getBytesForHash();
        }
        throw new RuntimeException("Split is not a HashableInputSplit: " + String.valueOf(fsplit));
    }

    private static long hash1(byte[] bytes) {
        int PRIME = 104729;
        return Murmur3.hash64((byte[])bytes, (int)0, (int)bytes.length, (int)104729);
    }

    private static long hash2(byte[] bytes) {
        int PRIME = 1366661;
        return Murmur3.hash64((byte[])bytes, (int)0, (int)bytes.length, (int)1366661);
    }

    private static String getSplitDescForDebug(FileSplit fsplit) {
        if (LOG.isDebugEnabled()) {
            return "Split at " + String.valueOf(fsplit.getPath()) + " with offset= " + fsplit.getStart() + ", length=" + fsplit.getLength();
        }
        return null;
    }
}

