/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.TezDummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.tez.DynamicValueRegistryTez;
import org.apache.hadoop.hive.ql.exec.tez.MapRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.exec.tez.tools.KeyValueInputMerger;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapOperator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.api.TaskContext;
import org.apache.tez.runtime.library.api.KeyValueReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRecordProcessor
extends RecordProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MapRecordProcessor.class);
    private static final String MAP_PLAN_KEY = "__MAP_PLAN__";
    private AbstractMapOperator mapOp;
    private final List<AbstractMapOperator> mergeMapOpList = new ArrayList<AbstractMapOperator>();
    private MapRecordSource[] sources;
    private final Map<String, MultiMRInput> multiMRInputMap = new HashMap<String, MultiMRInput>();
    private int position;
    private MRInputLegacy legacyMRInput;
    private MultiMRInput mainWorkMultiMRInput;
    private final ExecMapperContext execContext;
    private MapWork mapWork;
    private List<MapWork> mergeWorkList;
    private final List<String> cacheKeys = new ArrayList<String>();
    private final List<String> dynamicValueCacheKeys = new ArrayList<String>();
    private final ObjectCache cache;
    private final ObjectCache dynamicValueCache;
    private final boolean isInCompaction;

    public MapRecordProcessor(JobConf jconf, ProcessorContext context) throws Exception {
        super(jconf, context);
        String queryId = HiveConf.getVar((Configuration)jconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        if (LlapProxy.isDaemon()) {
            this.setLlapOfFragmentId(context);
        }
        this.cache = ObjectCacheFactory.getCache((Configuration)jconf, queryId, true);
        this.dynamicValueCache = ObjectCacheFactory.getCache((Configuration)jconf, queryId, false, true);
        this.execContext = new ExecMapperContext(jconf);
        this.execContext.setJc(jconf);
        this.isInCompaction = "compactor".equalsIgnoreCase(HiveConf.getVar((Configuration)jconf, (HiveConf.ConfVars)HiveConf.ConfVars.SPLIT_GROUPING_MODE));
    }

    private void setLlapOfFragmentId(ProcessorContext context) {
        String attemptId = Converters.createTaskAttemptId((TaskContext)context).toString();
        LOG.debug("Setting the LLAP fragment ID for OF to {}", (Object)attemptId);
        this.jconf.set("llap.of.id", attemptId);
    }

    @Override
    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        Configuration configuration;
        this.perfLogger.perfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(mrReporter, inputs, outputs);
        this.checkAbortCondition();
        String key = this.processorContext.getTaskVertexName() + MAP_PLAN_KEY;
        this.cacheKeys.add(key);
        this.mapWork = !this.isInCompaction ? this.cache.retrieve(key, () -> Utilities.getMapWork((Configuration)this.jconf)) : Utilities.getMapWork((Configuration)this.jconf);
        Utilities.setMapWork((Configuration)this.jconf, this.mapWork);
        for (PartitionDesc partitionDesc : this.mapWork.getAliasToPartnInfo().values()) {
            TableDesc tableDesc = partitionDesc.getTableDesc();
            Utilities.copyJobSecretToTableProperties(tableDesc);
        }
        String prefixes = this.jconf.get("hive.tez.merge.file.prefixes");
        if (prefixes != null) {
            this.mergeWorkList = new ArrayList<MapWork>();
            for (String prefix : prefixes.split(",")) {
                if (prefix == null || prefix.isEmpty()) continue;
                key = this.processorContext.getTaskVertexName() + prefix;
                this.cacheKeys.add(key);
                this.checkAbortCondition();
                this.mergeWorkList.add((MapWork)this.cache.retrieve(key, () -> Utilities.getMergeWork((Configuration)this.jconf, prefix)));
            }
        }
        MapredContext.init(true, new JobConf((Configuration)this.jconf));
        ((TezContext)MapredContext.get()).setInputs(inputs);
        ((TezContext)MapredContext.get()).setTezProcessorContext(this.processorContext);
        this.checkAbortCondition();
        this.legacyMRInput = this.getMRInput(inputs);
        if (this.legacyMRInput != null && (configuration = this.legacyMRInput.getConfigUpdates()) != null) {
            for (Map.Entry entry : configuration) {
                this.jconf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.checkAbortCondition();
        this.createOutputMap();
        for (Map.Entry<String, LogicalOutput> entry : outputs.entrySet()) {
            LOG.debug("Starting Output: " + entry.getKey());
            entry.getValue().start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(entry.getKey())).initialize();
        }
        this.checkAbortCondition();
        try {
            boolean bl;
            CompilationOpContext compilationOpContext = new CompilationOpContext();
            this.mapOp = this.mapWork.getVectorMode() ? new VectorMapOperator(compilationOpContext) : new MapOperator(compilationOpContext);
            this.checkAbortCondition();
            this.mapOp.clearConnectedOperators();
            this.mapOp.setExecContext(this.execContext);
            boolean bl2 = false;
            if (this.mergeWorkList != null) {
                AbstractMapOperator mergeMapOp = null;
                for (BaseWork baseWork : this.mergeWorkList) {
                    MapWork mergeMapWork = (MapWork)baseWork;
                    mergeMapOp = mergeMapWork.getVectorMode() ? new VectorMapOperator(compilationOpContext) : new MapOperator(compilationOpContext);
                    this.mergeMapOpList.add(mergeMapOp);
                    if (mergeMapOp == null) continue;
                    mergeMapOp.setConf(mergeMapWork);
                    LOG.info("Input name is {}", (Object)mergeMapWork.getName());
                    this.jconf.set("iocontext.input.name", mergeMapWork.getName());
                    mergeMapOp.initialize((Configuration)this.jconf, null);
                    MultiMRInput multiMRInput = this.multiMRInputMap.get(mergeMapWork.getName());
                    boolean skipRead = false;
                    if (multiMRInput == null) {
                        LOG.info("Multi MR Input for work {} is null. Skipping read.", (Object)mergeMapWork.getName());
                        skipRead = true;
                    } else {
                        Collection keyValueReaders = multiMRInput.getKeyValueReaders();
                        if (keyValueReaders == null || keyValueReaders.isEmpty()) {
                            LOG.info("Key value readers are null or empty and hence skipping read. KeyValueReaders = {}", (Object)keyValueReaders);
                            skipRead = true;
                        }
                    }
                    if (skipRead) {
                        ArrayList children = new ArrayList();
                        children.addAll(((MapWork)mergeMapOp.getConf()).getAliasToWork().values());
                        mergeMapOp.initEmptyInputChildren(children, (Configuration)this.jconf);
                    } else {
                        mergeMapOp.setChildren((Configuration)this.jconf);
                    }
                    Operator<? extends OperatorDesc> finalOp = this.getFinalOp(mergeMapOp);
                    if (finalOp instanceof TezDummyStoreOperator) {
                        ((TezDummyStoreOperator)finalOp).setFetchDone(skipRead);
                        this.mapOp.setConnectedOperators(mergeMapWork.getTag(), (DummyStoreOperator)finalOp);
                    } else {
                        bl = true;
                    }
                    mergeMapOp.passExecContext(new ExecMapperContext(this.jconf));
                    mergeMapOp.initializeLocalWork((Configuration)this.jconf);
                }
            }
            if (!bl) {
                ((TezContext)MapredContext.get()).setDummyOpsMap(this.mapOp.getConnectedOperators());
            }
            this.mapOp.setConf(this.mapWork);
            LOG.info("Main input name is " + this.mapWork.getName());
            this.jconf.set("iocontext.input.name", this.mapWork.getName());
            this.mapOp.initialize((Configuration)this.jconf, null);
            this.checkAbortCondition();
            this.mapOp.setChildren((Configuration)this.jconf);
            this.mapOp.passExecContext(this.execContext);
            LOG.info(this.mapOp.dump(0));
            long memoryAvailableToTask = this.processorContext.getTotalMemoryAvailableToTask();
            if (this.mapOp.getConf() != null) {
                ((MapWork)this.mapOp.getConf()).setMaxMemoryAvailable(memoryAvailableToTask);
                LOG.info("Memory available for operators set to {}", (Object)LlapUtil.humanReadableByteCount((long)memoryAvailableToTask));
            }
            OperatorUtils.setMemoryAvailable(this.mapOp.getChildOperators(), memoryAvailableToTask);
            this.mapOp.initializeLocalWork((Configuration)this.jconf);
            this.checkAbortCondition();
            String string = "DynamicValueRegistry";
            DynamicValueRegistryTez registryTez = this.dynamicValueCache.retrieve(string, () -> new DynamicValueRegistryTez());
            this.dynamicValueCacheKeys.add(string);
            DynamicValueRegistryTez.RegistryConfTez registryConf = new DynamicValueRegistryTez.RegistryConfTez((Configuration)this.jconf, this.mapWork, this.processorContext, inputs);
            registryTez.init(registryConf);
            this.checkAbortCondition();
            this.initializeMapRecordSources();
            this.mapOp.initializeMapOperator((Configuration)this.jconf);
            if (this.mergeMapOpList != null && !this.mergeMapOpList.isEmpty()) {
                for (AbstractMapOperator mergeMapOp : this.mergeMapOpList) {
                    this.jconf.set("iocontext.input.name", ((MapWork)mergeMapOp.getConf()).getName());
                    mergeMapOp.initializeMapOperator((Configuration)this.jconf);
                }
            }
            List<HashTableDummyOperator> dummyOps = this.mapWork.getDummyOps();
            this.jconf.set("iocontext.input.name", this.mapWork.getName());
            if (dummyOps != null) {
                for (Operator operator : dummyOps) {
                    operator.setExecContext(this.execContext);
                    operator.initialize((Configuration)this.jconf, null);
                }
            }
            OperatorUtils.setChildrenCollector(this.mapOp.getChildOperators(), this.outMap);
            this.mapOp.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable throwable) {
            this.setAborted(true);
            if (throwable instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)throwable;
            }
            if (throwable instanceof InterruptedException) {
                LOG.info("Hit an interrupt while initializing MapRecordProcessor. Message={}", (Object)throwable.getMessage());
                throw (InterruptedException)throwable;
            }
            throw new RuntimeException("Map operator initialization failed", throwable);
        }
        this.perfLogger.perfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    private void initializeMapRecordSources() throws Exception {
        int size = this.mergeMapOpList.size() + 1;
        this.sources = new MapRecordSource[size];
        this.position = ((MapWork)this.mapOp.getConf()).getTag();
        this.sources[this.position] = new MapRecordSource();
        KeyValueReader reader = null;
        reader = this.mainWorkMultiMRInput != null ? this.getKeyValueReader(this.mainWorkMultiMRInput.getKeyValueReaders(), this.mapOp) : this.legacyMRInput.getReader();
        this.sources[this.position].init(this.jconf, this.mapOp, reader);
        for (AbstractMapOperator mapOp : this.mergeMapOpList) {
            int tag = ((MapWork)mapOp.getConf()).getTag();
            this.sources[tag] = new MapRecordSource();
            String inputName = ((MapWork)mapOp.getConf()).getName();
            MultiMRInput multiMRInput = this.multiMRInputMap.get(inputName);
            Collection kvReaders = multiMRInput.getKeyValueReaders();
            LOG.debug("There are {} key-value readers for input {}", (Object)kvReaders.size(), (Object)inputName);
            if (kvReaders.size() <= 0) continue;
            reader = this.getKeyValueReader(kvReaders, mapOp);
            this.sources[tag].init(this.jconf, mapOp, reader);
        }
        ((TezContext)MapredContext.get()).setRecordSources(this.sources);
    }

    private KeyValueReader getKeyValueReader(Collection<KeyValueReader> keyValueReaders, AbstractMapOperator mapOp) throws Exception {
        ArrayList<KeyValueReader> kvReaderList = new ArrayList<KeyValueReader>(keyValueReaders);
        mapOp.initializeContexts();
        Deserializer deserializer = mapOp.getCurrentDeserializer();
        KeyValueInputMerger reader = new KeyValueInputMerger(kvReaderList, deserializer, new ObjectInspector[]{deserializer == null ? null : deserializer.getObjectInspector()}, ((MapWork)mapOp.getConf()).getSortCols());
        return reader;
    }

    private Operator<? extends OperatorDesc> getFinalOp(Operator<? extends OperatorDesc> mergeMapOp) {
        Iterator<Operator<OperatorDesc>> iterator = mergeMapOp.getChildOperators().iterator();
        if (iterator.hasNext()) {
            Operator<OperatorDesc> childOp = iterator.next();
            if (childOp.getChildOperators() == null || childOp.getChildOperators().isEmpty()) {
                return childOp;
            }
            return this.getFinalOp(childOp);
        }
        return null;
    }

    @Override
    void run() throws Exception {
        this.startAbortChecks();
        while (this.sources[this.position].pushRecord()) {
            this.addRowAndMaybeCheckAbort();
        }
    }

    @Override
    public void abort() {
        super.abort();
        if (this.mapOp != null) {
            LOG.info("Forwarding abort to mapOp: {} ", (Object)this.mapOp.getName());
            this.mapOp.abort();
        } else {
            LOG.info("mapOp not setup yet. abort not being forwarded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        if (!this.isAborted()) {
            this.setAborted(this.execContext.getIoCxt().getIOExceptions());
        }
        if (this.cache != null) {
            for (String string : this.cacheKeys) {
                this.cache.release(string);
            }
        }
        if (this.dynamicValueCache != null) {
            for (String string : this.dynamicValueCacheKeys) {
                this.dynamicValueCache.release(string);
            }
        }
        try {
            List<HashTableDummyOperator> list;
            if (this.mapOp == null || this.mapWork == null) {
                return;
            }
            boolean abort = this.isAborted();
            this.mapOp.close(abort);
            if (!this.mergeMapOpList.isEmpty()) {
                for (AbstractMapOperator abstractMapOperator : this.mergeMapOpList) {
                    abstractMapOperator.close(abort);
                }
            }
            if ((list = this.mapWork.getDummyOps()) != null) {
                for (Operator operator : list) {
                    operator.close(abort);
                }
            }
            ExecMapper.ReportStats reportStats = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.mapOp.preorderMap(reportStats);
            return;
        }
        catch (Exception e) {
            if (!this.isAborted()) {
                LOG.error("Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators", e);
            }
        }
        finally {
            Utilities.clearWorkMap((Configuration)this.jconf);
            MapredContext.close();
        }
    }

    private MRInputLegacy getMRInput(Map<String, LogicalInput> inputs) throws Exception {
        MRInputLegacy theMRInput = null;
        HashSet<LogicalInput> li = new HashSet<LogicalInput>();
        for (LogicalInput logicalInput : inputs.values()) {
            if (!(logicalInput instanceof MRInputLegacy) && !(logicalInput instanceof MultiMRInput)) continue;
            logicalInput.start();
            li.add(logicalInput);
        }
        this.processorContext.waitForAllInputsReady(li);
        LOG.info("The input names are: {}", (Object)String.join((CharSequence)",", inputs.keySet()));
        for (Map.Entry entry : inputs.entrySet()) {
            if (entry.getValue() instanceof MRInputLegacy) {
                if (theMRInput != null) {
                    throw new IllegalArgumentException("Only one MRInput is expected");
                }
                theMRInput = (MRInputLegacy)entry.getValue();
                continue;
            }
            if (!(entry.getValue() instanceof MultiMRInput)) continue;
            this.multiMRInputMap.put((String)entry.getKey(), (MultiMRInput)entry.getValue());
        }
        if (theMRInput != null) {
            theMRInput.init();
        } else {
            String alias = this.mapWork.getAliasToWork().keySet().iterator().next();
            if (inputs.get(alias) instanceof MultiMRInput) {
                this.mainWorkMultiMRInput = (MultiMRInput)inputs.get(alias);
            } else {
                throw new IOException("Unexpected input type found: " + inputs.get(alias).getClass().getCanonicalName());
            }
        }
        return theMRInput;
    }
}

