/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public final class VectorSerializeRow<T extends SerializeWrite> {
    private T serializeWrite;
    private Field root;
    private VectorExtractRow vectorExtractRow;
    private boolean hasAnyNulls;
    private boolean isAllNulls;

    public VectorSerializeRow(T serializeWrite) {
        this();
        this.serializeWrite = serializeWrite;
        this.vectorExtractRow = new VectorExtractRow();
    }

    private VectorSerializeRow() {
    }

    private Field[] createFields(TypeInfo[] typeInfos) {
        Field[] children = new Field[typeInfos.length];
        for (int i = 0; i < typeInfos.length; ++i) {
            children[i] = this.createField(typeInfos[i]);
        }
        return children;
    }

    private Field createField(TypeInfo typeInfo) {
        Field field;
        block23: {
            ObjectInspector.Category category;
            block22: {
                field = new Field();
                field.category = category = typeInfo.getCategory();
                field.typeInfo = typeInfo;
                if (category != ObjectInspector.Category.PRIMITIVE) break block22;
                field.isPrimitive = true;
                field.primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
                switch (field.primitiveCategory) {
                    case BOOLEAN: {
                        field.writer = new VectorSerializeBooleanWriter();
                        break block23;
                    }
                    case BYTE: {
                        field.writer = new VectorSerializeByteWriter();
                        break block23;
                    }
                    case SHORT: {
                        field.writer = new VectorSerializeShortWriter();
                        break block23;
                    }
                    case INT: {
                        field.writer = new VectorSerializeIntWriter();
                        break block23;
                    }
                    case LONG: {
                        field.writer = new VectorSerializeLongWriter();
                        break block23;
                    }
                    case DATE: {
                        field.writer = new VectorSerializeDateWriter();
                        break block23;
                    }
                    case TIMESTAMP: {
                        field.writer = new VectorSerializeTimestampWriter();
                        break block23;
                    }
                    case FLOAT: {
                        field.writer = new VectorSerializeFloatWriter();
                        break block23;
                    }
                    case DOUBLE: {
                        field.writer = new VectorSerializeDoubleWriter();
                        break block23;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        field.writer = new VectorSerializeStringWriter();
                        break block23;
                    }
                    case BINARY: {
                        field.writer = new VectorSerializeBinaryWriter();
                        break block23;
                    }
                    case DECIMAL: {
                        field.writer = new VectorSerializeDecimalWriter();
                        break block23;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        field.writer = new VectorSerializeHiveIntervalYearMonthWriter();
                        break block23;
                    }
                    case INTERVAL_DAY_TIME: {
                        field.writer = new VectorSerializeHiveIntervalDayTimeWriter();
                        break block23;
                    }
                    default: {
                        throw new RuntimeException("Unexpected primitive category " + String.valueOf(field.primitiveCategory));
                    }
                }
            }
            field.isPrimitive = false;
            field.objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
            switch (category) {
                case LIST: {
                    field.children = new Field[1];
                    field.children[0] = this.createField(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                    field.writer = new VectorSerializeListWriter();
                    break;
                }
                case MAP: {
                    field.children = new Field[2];
                    field.children[0] = this.createField(((MapTypeInfo)typeInfo).getMapKeyTypeInfo());
                    field.children[1] = this.createField(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
                    field.writer = new VectorSerializeMapWriter();
                    break;
                }
                case STRUCT: {
                    StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                    List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                    field.children = this.createFields(fieldTypeInfos.toArray(new TypeInfo[fieldTypeInfos.size()]));
                    field.writer = new VectorSerializeStructWriter();
                    break;
                }
                case UNION: {
                    UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                    List objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                    field.children = this.createFields(objectTypeInfos.toArray(new TypeInfo[objectTypeInfos.size()]));
                    field.writer = new VectorSerializeUnionWriter();
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            field.count = field.children.length;
        }
        return field;
    }

    public void init(List<String> typeNames, int[] columnMap) throws HiveException {
        TypeInfo[] typeInfos = TypeInfoUtils.typeInfosFromTypeNames(typeNames).toArray(new TypeInfo[typeNames.size()]);
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        int[] outputColumnNums = new int[count];
        for (int i = 0; i < count; ++i) {
            int outputColumnNum;
            outputColumnNums[i] = outputColumnNum = columnMap[i];
            this.root.children[i].outputColumnNum = outputColumnNum;
        }
        this.vectorExtractRow.init(typeInfos, outputColumnNums);
    }

    public void init(List<String> typeNames) throws HiveException {
        TypeInfo[] typeInfos = TypeInfoUtils.typeInfosFromTypeNames(typeNames).toArray(new TypeInfo[typeNames.size()]);
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        for (int i = 0; i < count; ++i) {
            this.root.children[i].outputColumnNum = i;
        }
        this.vectorExtractRow.init(typeInfos);
    }

    public void init(TypeInfo[] typeInfos) throws HiveException {
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        for (int i = 0; i < count; ++i) {
            this.root.children[i].outputColumnNum = i;
        }
        this.vectorExtractRow.init(typeInfos);
    }

    public void init(TypeInfo[] typeInfos, int[] columnMap) throws HiveException {
        int count = typeInfos.length;
        this.root = new Field();
        this.root.isPrimitive = false;
        this.root.category = ObjectInspector.Category.STRUCT;
        this.root.children = this.createFields(typeInfos);
        this.root.count = count;
        this.root.objectInspector = null;
        int[] outputColumnNums = new int[count];
        for (int i = 0; i < count; ++i) {
            int outputColumnNum;
            outputColumnNums[i] = outputColumnNum = columnMap[i];
            this.root.children[i].outputColumnNum = outputColumnNum;
        }
        this.vectorExtractRow.init(typeInfos, outputColumnNums);
    }

    public int getCount() {
        return this.root.count;
    }

    public void setOutput(ByteStream.Output output) {
        this.serializeWrite.set(output);
    }

    public void setOutputAppend(ByteStream.Output output) {
        this.serializeWrite.setAppend(output);
    }

    public void serializeWrite(VectorizedRowBatch batch, int batchIndex) throws IOException {
        this.hasAnyNulls = false;
        this.isAllNulls = true;
        Field[] children = this.root.children;
        int size = this.root.count;
        for (int i = 0; i < size; ++i) {
            Field field = children[i];
            ColumnVector colVector = batch.cols[field.outputColumnNum];
            this.serializeWrite(colVector, field, batchIndex);
        }
    }

    private void serializeWrite(ColumnVector colVector, Field field, int batchIndex) throws IOException {
        int adjustedBatchIndex = colVector.isRepeating ? 0 : batchIndex;
        if (!colVector.noNulls && colVector.isNull[adjustedBatchIndex]) {
            this.serializeWrite.writeNull();
            this.hasAnyNulls = true;
            return;
        }
        this.isAllNulls = false;
        field.writer.serialize(colVector, field, adjustedBatchIndex);
    }

    public boolean getHasAnyNulls() {
        return this.hasAnyNulls;
    }

    public boolean getIsAllNulls() {
        return this.isAllNulls;
    }

    private static class Field {
        Field[] children = null;
        boolean isPrimitive = false;
        ObjectInspector.Category category = null;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = null;
        TypeInfo typeInfo = null;
        int count = 0;
        ObjectInspector objectInspector = null;
        int outputColumnNum = -1;
        VectorSerializeWriter writer = null;

        private Field() {
        }
    }

    class VectorSerializeBooleanWriter
    extends VectorSerializeWriter {
        VectorSerializeBooleanWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeBoolean(((LongColumnVector)colInfo).vector[adjustedBatchIndex] != 0L);
        }
    }

    static abstract class VectorSerializeWriter {
        VectorSerializeWriter() {
        }

        abstract void serialize(Object var1, Field var2, int var3) throws IOException;
    }

    class VectorSerializeByteWriter
    extends VectorSerializeWriter {
        VectorSerializeByteWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeByte((byte)((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeShortWriter
    extends VectorSerializeWriter {
        VectorSerializeShortWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeShort((short)((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeIntWriter
    extends VectorSerializeWriter {
        VectorSerializeIntWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeInt((int)((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeLongWriter
    extends VectorSerializeWriter {
        VectorSerializeLongWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeLong(((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeDateWriter
    extends VectorSerializeWriter {
        VectorSerializeDateWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeDate((int)((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeTimestampWriter
    extends VectorSerializeWriter {
        VectorSerializeTimestampWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            Timestamp ts = ((TimestampColumnVector)colInfo).asScratchTimestamp(adjustedBatchIndex);
            org.apache.hadoop.hive.common.type.Timestamp serializableTS = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)ts.getTime(), (int)ts.getNanos());
            VectorSerializeRow.this.serializeWrite.writeTimestamp(serializableTS);
        }
    }

    class VectorSerializeFloatWriter
    extends VectorSerializeWriter {
        VectorSerializeFloatWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeFloat((float)((DoubleColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeDoubleWriter
    extends VectorSerializeWriter {
        VectorSerializeDoubleWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeDouble(((DoubleColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeStringWriter
    extends VectorSerializeWriter {
        VectorSerializeStringWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            BytesColumnVector bytesColVector = (BytesColumnVector)colInfo;
            VectorSerializeRow.this.serializeWrite.writeString(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
        }
    }

    class VectorSerializeBinaryWriter
    extends VectorSerializeWriter {
        VectorSerializeBinaryWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            BytesColumnVector bytesColVector = (BytesColumnVector)colInfo;
            VectorSerializeRow.this.serializeWrite.writeBinary(bytesColVector.vector[adjustedBatchIndex], bytesColVector.start[adjustedBatchIndex], bytesColVector.length[adjustedBatchIndex]);
        }
    }

    class VectorSerializeDecimalWriter
    extends VectorSerializeWriter {
        VectorSerializeDecimalWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            if (colInfo instanceof Decimal64ColumnVector) {
                Decimal64ColumnVector decimal64ColVector = (Decimal64ColumnVector)colInfo;
                VectorSerializeRow.this.serializeWrite.writeDecimal64(decimal64ColVector.vector[adjustedBatchIndex], (int)decimal64ColVector.scale);
            } else {
                DecimalColumnVector decimalColVector = (DecimalColumnVector)colInfo;
                VectorSerializeRow.this.serializeWrite.writeHiveDecimal(decimalColVector.vector[adjustedBatchIndex], (int)decimalColVector.scale);
            }
        }
    }

    class VectorSerializeHiveIntervalYearMonthWriter
    extends VectorSerializeWriter {
        VectorSerializeHiveIntervalYearMonthWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeHiveIntervalYearMonth((int)((LongColumnVector)colInfo).vector[adjustedBatchIndex]);
        }
    }

    class VectorSerializeHiveIntervalDayTimeWriter
    extends VectorSerializeWriter {
        VectorSerializeHiveIntervalDayTimeWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            VectorSerializeRow.this.serializeWrite.writeHiveIntervalDayTime(((IntervalDayTimeColumnVector)colInfo).asScratchIntervalDayTime(adjustedBatchIndex));
        }
    }

    class VectorSerializeListWriter
    extends VectorSerializeWriter {
        VectorSerializeListWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            this.serializeListWrite((ListColumnVector)colInfo, field, adjustedBatchIndex);
        }

        private void serializeListWrite(ListColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
            ListTypeInfo typeInfo = (ListTypeInfo)field.typeInfo;
            ListObjectInspector objectInspector = (ListObjectInspector)field.objectInspector;
            ColumnVector childColumnVector = colVector.child;
            Field elementField = field.children[0];
            int offset = (int)colVector.offsets[adjustedBatchIndex];
            int size = (int)colVector.lengths[adjustedBatchIndex];
            ObjectInspector elementObjectInspector = objectInspector.getListElementObjectInspector();
            List list = (List)VectorSerializeRow.this.vectorExtractRow.extractRowColumn((ColumnVector)colVector, (TypeInfo)typeInfo, (ObjectInspector)objectInspector, adjustedBatchIndex);
            VectorSerializeRow.this.serializeWrite.beginList(list);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    VectorSerializeRow.this.serializeWrite.separateList();
                }
                VectorSerializeRow.this.serializeWrite(childColumnVector, elementField, offset + i);
            }
            VectorSerializeRow.this.serializeWrite.finishList();
        }
    }

    class VectorSerializeMapWriter
    extends VectorSerializeWriter {
        VectorSerializeMapWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            this.serializeMapWrite((MapColumnVector)colInfo, field, adjustedBatchIndex);
        }

        private void serializeMapWrite(MapColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
            MapTypeInfo typeInfo = (MapTypeInfo)field.typeInfo;
            MapObjectInspector objectInspector = (MapObjectInspector)field.objectInspector;
            ColumnVector keyColumnVector = colVector.keys;
            ColumnVector valueColumnVector = colVector.values;
            Field keyField = field.children[0];
            Field valueField = field.children[1];
            int offset = (int)colVector.offsets[adjustedBatchIndex];
            int size = (int)colVector.lengths[adjustedBatchIndex];
            Map map = (Map)VectorSerializeRow.this.vectorExtractRow.extractRowColumn((ColumnVector)colVector, (TypeInfo)typeInfo, (ObjectInspector)objectInspector, adjustedBatchIndex);
            VectorSerializeRow.this.serializeWrite.beginMap(map);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    VectorSerializeRow.this.serializeWrite.separateKeyValuePair();
                }
                VectorSerializeRow.this.serializeWrite(keyColumnVector, keyField, offset + i);
                VectorSerializeRow.this.serializeWrite.separateKey();
                VectorSerializeRow.this.serializeWrite(valueColumnVector, valueField, offset + i);
            }
            VectorSerializeRow.this.serializeWrite.finishMap();
        }
    }

    class VectorSerializeStructWriter
    extends VectorSerializeWriter {
        VectorSerializeStructWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            this.serializeStructWrite((StructColumnVector)colInfo, field, adjustedBatchIndex);
        }

        private void serializeStructWrite(StructColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
            StructTypeInfo typeInfo = (StructTypeInfo)field.typeInfo;
            StructObjectInspector objectInspector = (StructObjectInspector)field.objectInspector;
            ColumnVector[] fieldColumnVectors = colVector.fields;
            Field[] children = field.children;
            List structFields = objectInspector.getAllStructFieldRefs();
            int size = field.count;
            List list = (List)VectorSerializeRow.this.vectorExtractRow.extractRowColumn((ColumnVector)colVector, (TypeInfo)typeInfo, (ObjectInspector)objectInspector, adjustedBatchIndex);
            VectorSerializeRow.this.serializeWrite.beginStruct(list);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    VectorSerializeRow.this.serializeWrite.separateStruct();
                }
                VectorSerializeRow.this.serializeWrite(fieldColumnVectors[i], children[i], adjustedBatchIndex);
            }
            VectorSerializeRow.this.serializeWrite.finishStruct();
        }
    }

    class VectorSerializeUnionWriter
    extends VectorSerializeWriter {
        VectorSerializeUnionWriter() {
        }

        @Override
        void serialize(Object colInfo, Field field, int adjustedBatchIndex) throws IOException {
            this.serializeUnionWrite((UnionColumnVector)colInfo, field, adjustedBatchIndex);
        }

        private void serializeUnionWrite(UnionColumnVector colVector, Field field, int adjustedBatchIndex) throws IOException {
            UnionTypeInfo typeInfo = (UnionTypeInfo)field.typeInfo;
            UnionObjectInspector objectInspector = (UnionObjectInspector)field.objectInspector;
            byte tag = (byte)colVector.tags[adjustedBatchIndex];
            ColumnVector fieldColumnVector = colVector.fields[tag];
            Field childField = field.children[tag];
            VectorSerializeRow.this.serializeWrite.beginUnion((int)tag);
            VectorSerializeRow.this.serializeWrite(fieldColumnVector, childField, adjustedBatchIndex);
            VectorSerializeRow.this.serializeWrite.finishUnion();
        }
    }
}

