/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class TimestampColLessTimestampScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final Timestamp value;

    public TimestampColLessTimestampScalar(int colNum, Timestamp value, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.value = value;
    }

    public TimestampColLessTimestampScalar() {
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        long[] outputVector = outputColVector.vector;
        outputColVector.isRepeating = false;
        if (inputColVector1.isRepeating) {
            if (inputColVector1.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                outputVector[0] = inputColVector1.compareTo(0, this.value) < 0 ? 1L : 0L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar((ColumnVector)outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        outputVector[i] = inputColVector1.compareTo(i, this.value) < 0 ? 1L : 0L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputVector[i] = inputColVector1.compareTo(i, this.value) < 0 ? 1L : 0L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = inputColVector1.compareTo(i, this.value) < 0 ? 1L : 0L;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = inputColVector1.compareTo(i, this.value) < 0 ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    outputVector[i] = inputColVector1.compareTo(i, this.value) < 0 ? 1L : 0L;
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", val " + TimestampUtils.timestampScalarTypeToString(this.value);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("timestamp")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

