/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorAbstractAvg;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorHelper;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleAvg
extends VectorPTFEvaluatorAbstractAvg<Double> {
    protected double avg;

    public VectorPTFEvaluatorDoubleAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.sum = doubleColVector.vector[0] * (double)batch.size;
                    this.isGroupResultNull = false;
                } else {
                    this.sum = (Double)this.sum + doubleColVector.vector[0] * (double)batch.size;
                }
                this.nonNullGroupCount += size;
            }
        } else if (doubleColVector.noNulls) {
            double[] vector = doubleColVector.vector;
            double varSum = vector[0];
            for (int i = 1; i < size; ++i) {
                varSum += vector[i];
            }
            this.nonNullGroupCount += size;
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum = (Double)this.sum + varSum;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            double[] vector = doubleColVector.vector;
            double varSum = vector[i++];
            ++this.nonNullGroupCount;
            while (i < size) {
                if (!batchIsNull[i]) {
                    varSum += vector[i];
                    ++this.nonNullGroupCount;
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum = (Double)this.sum + varSum;
            }
        }
    }

    @Override
    public void doLastBatchWork() {
        if (!this.isGroupResultNull) {
            this.avg = (Double)this.sum / (double)this.nonNullGroupCount;
        }
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public Object getGroupResult() {
        this.doLastBatchWork();
        return this.avg;
    }

    @Override
    protected Double computeValue(Double number) {
        return VectorPTFEvaluatorHelper.computeValue(number);
    }

    @Override
    protected Double plus(Double number1, Double number2) {
        return VectorPTFEvaluatorHelper.plus(number1, number2);
    }

    @Override
    protected Double minus(Double number1, Double number2) {
        return VectorPTFEvaluatorHelper.minus(number1, number2);
    }

    protected Double divide(Double number, long divisor) {
        return VectorPTFEvaluatorHelper.divide(number, divisor);
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum = 0.0;
        this.nonNullGroupCount = 0;
        this.avg = 0.0;
    }
}

