/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.hooks.PreExecutePrinter;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;

public class PostExecutePrinter
implements ExecuteWithHookContext {
    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK);
        Set<ReadEntity> inputs = hookContext.getInputs();
        Set<WriteEntity> outputs = hookContext.getOutputs();
        LineageInfo linfo = hookContext.getLinfo();
        UserGroupInformation ugi = hookContext.getUgi();
        this.run(hookContext.getQueryState(), inputs, outputs, linfo, ugi);
    }

    public void run(QueryState queryState, Set<ReadEntity> inputs, Set<WriteEntity> outputs, LineageInfo linfo, UserGroupInformation ugi) throws Exception {
        SessionState.LogHelper console = SessionState.getConsole();
        if (console == null) {
            return;
        }
        if (queryState != null) {
            console.printInfo("POSTHOOK: query: " + queryState.getQueryString().trim(), false);
            console.printInfo("POSTHOOK: type: " + queryState.getCommandType(), false);
        }
        PreExecutePrinter.printEntities(console, inputs, "POSTHOOK: Input: ");
        PreExecutePrinter.printEntities(console, outputs, "POSTHOOK: Output: ");
        if (linfo != null) {
            LinkedList<Map.Entry<LineageInfo.DependencyKey, LineageInfo.Dependency>> entry_list = new LinkedList<Map.Entry<LineageInfo.DependencyKey, LineageInfo.Dependency>>(linfo.entrySet());
            Collections.sort(entry_list, new DependencyKeyComp(this));
            for (Map.Entry entry : entry_list) {
                LineageInfo.Dependency dep = (LineageInfo.Dependency)entry.getValue();
                LineageInfo.DependencyKey depK = (LineageInfo.DependencyKey)entry.getKey();
                if (dep == null) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("POSTHOOK: Lineage: ");
                if (depK.getDataContainer().isPartition()) {
                    Partition part = depK.getDataContainer().getPartition();
                    sb.append(part.getTableName());
                    sb.append(" PARTITION(");
                    int i = 0;
                    for (FieldSchema fs : depK.getDataContainer().getTable().getPartitionKeys()) {
                        if (i != 0) {
                            sb.append(",");
                        }
                        sb.append(fs.getName() + "=" + (String)part.getValues().get(i++));
                    }
                    sb.append(")");
                } else {
                    sb.append(depK.getDataContainer().getTable().getTableName());
                }
                sb.append("." + depK.getFieldSchema().getName() + " " + String.valueOf((Object)dep.getType()) + " ");
                sb.append("[");
                for (LineageInfo.BaseColumnInfo col : dep.getBaseCols()) {
                    sb.append("(" + col.getTabAlias().getTable().getTableName() + ")" + col.getTabAlias().getAlias() + "." + String.valueOf(col.getColumn()) + ", ");
                }
                sb.append("]");
                console.printInfo(sb.toString(), false);
            }
        }
    }

    public class DependencyKeyComp
    implements Comparator<Map.Entry<LineageInfo.DependencyKey, LineageInfo.Dependency>> {
        public DependencyKeyComp(PostExecutePrinter this$0) {
        }

        @Override
        public int compare(Map.Entry<LineageInfo.DependencyKey, LineageInfo.Dependency> o1, Map.Entry<LineageInfo.DependencyKey, LineageInfo.Dependency> o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            int ret = o1.getKey().getDataContainer().getTable().getTableName().compareTo(o2.getKey().getDataContainer().getTable().getTableName());
            if (ret != 0) {
                return ret;
            }
            if (!o1.getKey().getDataContainer().isPartition() && o2.getKey().getDataContainer().isPartition()) {
                return -1;
            }
            if (o1.getKey().getDataContainer().isPartition() && !o2.getKey().getDataContainer().isPartition()) {
                return 1;
            }
            if (o1.getKey().getDataContainer().isPartition() && o2.getKey().getDataContainer().isPartition() && (ret = o1.getKey().getDataContainer().getPartition().getValues().toString().compareTo(o2.getKey().getDataContainer().getPartition().getValues().toString())) != 0) {
                return ret;
            }
            return o1.getKey().getFieldSchema().getName().compareTo(o2.getKey().getFieldSchema().getName());
        }
    }
}

