/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public abstract class SingleFileSystem
extends FileSystem {
    private static final String SINGLEFILE = "#SINGLEFILE#";
    private URI uri;
    private Configuration conf;
    private Path workDir;

    public String getScheme() {
        return "sfs+" + ((Object)((Object)this)).getClass().getSimpleName().toLowerCase();
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.uri = uri;
        this.conf = conf;
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path upperPath, int bufferSize) throws IOException {
        SfsInfo info = new SfsInfo(this, upperPath);
        switch (info.type.ordinal()) {
            case 0: {
                return info.lowerTargetPath.getFileSystem(this.conf).open(info.lowerTargetPath, bufferSize);
            }
            case 3: {
                throw this.newFileNotFoundException(upperPath.toString());
            }
        }
        throw this.unsupported("open:" + String.valueOf(upperPath));
    }

    public FileStatus getFileStatus(Path upperPath) throws IOException {
        SfsInfo info = new SfsInfo(this, upperPath);
        switch (info.type.ordinal()) {
            case 0: {
                return this.makeFileStatus(info.upperTargetPath, info.lowerTargetPath);
            }
            case 2: {
                return this.makeDirFileStatus(upperPath, this.removeSfsScheme(upperPath));
            }
            case 1: {
                return this.makeDirFileStatus(upperPath, info.lowerTargetPath);
            }
            case 3: {
                throw this.newFileNotFoundException(upperPath.toString());
            }
        }
        throw this.unsupported("fileStatus:" + String.valueOf(upperPath));
    }

    public FileStatus[] listStatus(Path upperPath) throws FileNotFoundException, IOException {
        SfsInfo info = new SfsInfo(this, upperPath);
        switch (info.type.ordinal()) {
            case 2: {
                return this.dirModeListStatus(upperPath);
            }
            case 0: 
            case 1: {
                return new FileStatus[]{this.makeFileStatus(info.upperTargetPath, info.lowerTargetPath)};
            }
            case 3: {
                throw this.newFileNotFoundException(upperPath.toString());
            }
        }
        throw this.unsupported("listStatus: " + String.valueOf(upperPath));
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workDir = new_dir;
    }

    public Path getWorkingDirectory() {
        return this.workDir;
    }

    public FSDataOutputStream create(Path upperPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw this.unsupportedReadOnly("create", upperPath);
    }

    public FSDataOutputStream append(Path upperPath, int bufferSize, Progressable progress) throws IOException {
        throw this.unsupportedReadOnly("append", upperPath);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw this.unsupportedReadOnly("rename", src);
    }

    public boolean delete(Path upperPath, boolean recursive) throws IOException {
        throw this.unsupportedReadOnly("delete", upperPath);
    }

    public boolean mkdirs(Path upperPath, FsPermission permission) throws IOException {
        throw this.unsupportedReadOnly("mkdirs", upperPath);
    }

    public String getCanonicalServiceName() {
        return null;
    }

    public FileStatus[] dirModeListStatus(Path upperPath) throws IOException {
        Path lowerPath = this.removeSfsScheme(upperPath);
        FileSystem fs = lowerPath.getFileSystem(this.conf);
        FileStatus status = fs.getFileStatus(lowerPath);
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        if (status.isDirectory()) {
            FileStatus[] statusList;
            for (FileStatus fileStatus : statusList = fs.listStatus(lowerPath)) {
                ret.add(SingleFileSystem.makeDirFileStatus(fileStatus));
            }
        } else {
            FileStatus dirStat = this.makeDirFileStatus(new Path(upperPath, SINGLEFILE), lowerPath);
            ret.add(dirStat);
        }
        return ret.toArray(new FileStatus[0]);
    }

    public FileStatus makeFileStatus(Path upperPath, Path lowerPath) throws IOException {
        FileStatus status = lowerPath.getFileSystem(this.conf).getFileStatus(lowerPath);
        status = new FileStatus(status);
        status.setPath(upperPath);
        return status;
    }

    private static FileStatus makeDirFileStatus(FileStatus lowerStatus) throws IOException {
        return SingleFileSystem.makeDirFileStatus(SingleFileSystem.makeSfsPath(lowerStatus.getPath()), lowerStatus);
    }

    private Path removeSfsScheme(Path lowerTargetPath0) {
        URI u = lowerTargetPath0.toUri();
        return new Path(this.removeSfsScheme(u.getScheme()), u.getAuthority(), u.getPath());
    }

    private String removeSfsScheme(String scheme) {
        if (scheme.startsWith("sfs+")) {
            return scheme.substring(4);
        }
        if (scheme.equals("sfs")) {
            return null;
        }
        throw new RuntimeException("Unexpected scheme: " + scheme);
    }

    private static Path makeSfsPath(Path path) throws IOException {
        URI oldUri = path.toUri();
        if (oldUri.getScheme().startsWith("sfs+")) {
            throw new IOException("unexpected path");
        }
        return new Path("sfs+" + oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath());
    }

    public FileStatus makeDirFileStatus(Path upperPath, Path lowerPath) throws IOException {
        FileStatus status = lowerPath.getFileSystem(this.conf).getFileStatus(lowerPath);
        return SingleFileSystem.makeDirFileStatus(upperPath, status);
    }

    public static FileStatus makeDirFileStatus(Path upperPath, FileStatus status) throws IOException {
        FileStatus newStatus = new FileStatus(status.getLen(), true, (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), SingleFileSystem.addExecute(status.getPermission()), status.getOwner(), status.getGroup(), status.isSymlink() ? status.getSymlink() : null, status.getPath());
        newStatus.setPath(upperPath);
        return newStatus;
    }

    private static FsPermission addExecute(FsPermission permission) {
        short mode = (short)(permission.toShort() | 1 | 8 | 0x40);
        return new FsPermission(mode);
    }

    private IOException unsupportedReadOnly(String opName, Path path) throws IOException {
        SfsInfo sfsInfo = new SfsInfo(this, path);
        if (sfsInfo.type == SfsInodeType.SINGLEFILE_DIR || sfsInfo.type == SfsInodeType.LEAF_FILE) {
            FileSystem fs = sfsInfo.lowerTargetPath.getFileSystem(this.conf);
            fs.getFileStatus(sfsInfo.lowerTargetPath);
        }
        return new IOException("SFS is readonly hence " + opName + " is not supported! (" + String.valueOf(path) + ")");
    }

    private IOException unsupported(String str) {
        return new IOException("Unsupported SFS filesystem operation! (" + str + ")");
    }

    private IOException newFileNotFoundException(String path) {
        return new FileNotFoundException("File " + path + " does not exists!");
    }

    class SfsInfo {
        private final URI uri;
        private final SfsInodeType type;
        private final Path lowerTargetPath;
        private final Path upperTargetPath;

        public SfsInfo(SingleFileSystem this$0, Path upperPath) {
            this.uri = upperPath.toUri();
            String[] parts = this.uri.getPath().split("/");
            int n = parts.length;
            if (n >= 1 && parts[n - 1].equals(SingleFileSystem.SINGLEFILE)) {
                this.type = SfsInodeType.SINGLEFILE_DIR;
                this.lowerTargetPath = this$0.removeSfsScheme(upperPath.getParent());
                this.upperTargetPath = new Path(this.uri.getScheme(), this.uri.getAuthority(), this.uri.getPath() + "/" + parts[n - 2]);
            } else if (n >= 2 && parts[n - 2].equals(SingleFileSystem.SINGLEFILE)) {
                if (n >= 3 && !parts[n - 3].equals(parts[n - 1])) {
                    this.type = SfsInodeType.NONEXISTENT;
                    this.lowerTargetPath = null;
                    this.upperTargetPath = null;
                } else {
                    this.type = SfsInodeType.LEAF_FILE;
                    this.lowerTargetPath = this$0.removeSfsScheme(upperPath.getParent().getParent());
                    this.upperTargetPath = upperPath;
                }
            } else {
                this.type = SfsInodeType.DIR_MODE;
                this.lowerTargetPath = null;
                this.upperTargetPath = null;
            }
        }
    }

    static enum SfsInodeType {
        LEAF_FILE,
        SINGLEFILE_DIR,
        DIR_MODE,
        NONEXISTENT;

    }

    public static class FILE
    extends SingleFileSystem {
    }

    public static class PFILE
    extends SingleFileSystem {
    }

    public static class OFS
    extends SingleFileSystem {
    }

    public static class O3FS
    extends SingleFileSystem {
    }

    public static class GS
    extends SingleFileSystem {
    }

    public static class ADL
    extends SingleFileSystem {
    }

    public static class ABFSS
    extends SingleFileSystem {
    }

    public static class ABFS
    extends SingleFileSystem {
    }

    public static class S3A
    extends SingleFileSystem {
    }

    public static class HDFS
    extends SingleFileSystem {
    }
}

