/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.oracle.truffle.js.scriptengine.GraalJSScriptEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.graalvm.polyglot.Context;

final class PartitionTree {
    private Map<String, Partition> parts = new LinkedHashMap<String, Partition>();
    private final Table tTable;

    PartitionTree(Table t) {
        this.tTable = t;
    }

    Partition addPartition(Partition partition, String partName, boolean ifNotExists) throws AlreadyExistsException {
        partition.setDbName(partition.getDbName().toLowerCase());
        partition.setTableName(partition.getTableName().toLowerCase());
        if (!ifNotExists && this.parts.containsKey(partName)) {
            throw new AlreadyExistsException("Partition " + partName + " already exists");
        }
        return this.parts.putIfAbsent(partName, partition);
    }

    Partition getPartition(String partName) {
        return this.parts.get(partName);
    }

    Partition getPartition(List<String> partVals) throws MetaException {
        String partName = Warehouse.makePartName((List)this.tTable.getPartitionKeys(), partVals);
        return this.getPartition(partName);
    }

    List<Partition> addPartitions(List<Partition> partitions, boolean ifNotExists) throws MetaException, AlreadyExistsException {
        ArrayList<Partition> partitionsAdded = new ArrayList<Partition>();
        HashMap<String, Partition> partNameToPartition = new HashMap<String, Partition>();
        for (Partition partition : partitions) {
            String partName = Warehouse.makePartName((List)this.tTable.getPartitionKeys(), (List)partition.getValues());
            if (!ifNotExists && this.parts.containsKey(partName)) {
                throw new AlreadyExistsException("Partition " + partName + " already exists");
            }
            partNameToPartition.put(partName, partition);
        }
        for (Map.Entry entry : partNameToPartition.entrySet()) {
            if (this.addPartition((Partition)entry.getValue(), (String)entry.getKey(), ifNotExists) != null) continue;
            partitionsAdded.add((Partition)entry.getValue());
        }
        return partitionsAdded;
    }

    List<Partition> getPartitionsByPartitionVals(List<String> partialPartVals) throws MetaException {
        if (partialPartVals == null || partialPartVals.isEmpty()) {
            throw new MetaException("Partition partial vals cannot be null or empty");
        }
        String partNameMatcher = MetaStoreUtils.makePartNameMatcher((Table)this.tTable, partialPartVals, (String)".*");
        ArrayList<Partition> matchedPartitions = new ArrayList<Partition>();
        for (Map.Entry<String, Partition> entry : this.parts.entrySet()) {
            if (!entry.getKey().matches(partNameMatcher)) continue;
            matchedPartitions.add(entry.getValue());
        }
        return matchedPartitions;
    }

    List<Partition> listPartitions() {
        return new ArrayList<Partition>(this.parts.values());
    }

    Partition dropPartition(List<String> partVals) throws MetaException, NoSuchObjectException {
        String partName = Warehouse.makePartName((List)this.tTable.getPartitionKeys(), partVals);
        if (!this.parts.containsKey(partName)) {
            throw new NoSuchObjectException("Partition with partition values " + Arrays.toString(partVals.toArray()) + " is not found.");
        }
        return this.parts.remove(partName);
    }

    void alterPartition(List<String> oldPartitionVals, Partition newPartition, boolean isRename) throws MetaException, InvalidOperationException, NoSuchObjectException {
        if (oldPartitionVals == null || oldPartitionVals.isEmpty()) {
            throw new InvalidOperationException("Old partition values cannot be null or empty.");
        }
        if (newPartition == null) {
            throw new InvalidOperationException("New partition cannot be null.");
        }
        Partition oldPartition = this.getPartition(oldPartitionVals);
        if (oldPartition == null) {
            throw new InvalidOperationException("Partition with partition values " + Arrays.toString(oldPartitionVals.toArray()) + " is not found.");
        }
        if (!oldPartition.getDbName().equals(newPartition.getDbName())) {
            throw new MetaException("Db name cannot be altered.");
        }
        if (!oldPartition.getTableName().equals(newPartition.getTableName())) {
            throw new MetaException("Table name cannot be altered.");
        }
        if (isRename) {
            newPartition.getSd().setLocation(oldPartition.getSd().getLocation());
        }
        this.dropPartition(oldPartitionVals);
        String partName = Warehouse.makePartName((List)this.tTable.getPartitionKeys(), (List)newPartition.getValues());
        if (this.parts.containsKey(partName)) {
            throw new InvalidOperationException("Partition " + partName + " already exists");
        }
        this.parts.put(partName, newPartition);
    }

    void alterPartitions(List<Partition> newParts) throws MetaException, InvalidOperationException, NoSuchObjectException {
        LinkedHashMap<String, Partition> clonedPartitions = new LinkedHashMap<String, Partition>();
        this.parts.forEach((key, value) -> clonedPartitions.put((String)key, new Partition(value)));
        for (Partition partition : newParts) {
            try {
                if (partition == null) {
                    throw new InvalidOperationException("New partition cannot be null.");
                }
                this.alterPartition(partition.getValues(), partition, false);
            }
            catch (InvalidOperationException | MetaException | NoSuchObjectException e) {
                this.parts = clonedPartitions;
                throw e;
            }
        }
    }

    void renamePartition(List<String> oldPartitionVals, Partition newPart) throws MetaException, InvalidOperationException, NoSuchObjectException {
        this.alterPartition(oldPartitionVals, newPart, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<Partition> getPartitionsByFilter(String filter) throws MetaException {
        if (filter == null || filter.isEmpty()) {
            return new ArrayList<Partition>(this.parts.values());
        }
        ArrayList<Partition> result = new ArrayList<Partition>();
        try (GraalJSScriptEngine se = GraalJSScriptEngine.create(null, (Context.Builder)Context.newBuilder((String[])new String[0]).allowExperimentalOptions(true).option("js.nashorn-compat", "true").allowAllAccess(true));){
            for (Map.Entry<String, Partition> entry : this.parts.entrySet()) {
                se.put("partitionName", (Object)entry.getKey());
                se.put("values", (Object)entry.getValue().getValues());
                try {
                    if (!((Boolean)se.eval(filter)).booleanValue()) continue;
                    result.add(entry.getValue());
                }
                catch (ScriptException e) {
                    throw new MetaException("Incorrect partition filter");
                    return result;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    GetPartitionsResponse getPartitionsWithSpecs(GetPartitionsRequest getPartitionsRequest) throws MetaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$getPartitionsWithSpecs$1(Map.Entry entry, String str) {
        return ((Partition)entry.getValue()).getValues().contains(str);
    }
}

