/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Iterator;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;

public class HiveRemoveSqCountCheck
extends RelOptRule {
    public static final HiveRemoveSqCountCheck INSTANCE = new HiveRemoveSqCountCheck();

    public HiveRemoveSqCountCheck() {
        super(HiveRemoveSqCountCheck.operand(Join.class, (RelOptRuleOperandChildren)HiveRemoveSqCountCheck.some((RelOptRuleOperand)HiveRemoveSqCountCheck.operand(Project.class, (RelOptRuleOperand)HiveRemoveSqCountCheck.operand(Join.class, (RelOptRuleOperandChildren)HiveRemoveSqCountCheck.some((RelOptRuleOperand)HiveRemoveSqCountCheck.operand(RelNode.class, (RelOptRuleOperandChildren)HiveRemoveSqCountCheck.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveRemoveSqCountCheck.operand(Filter.class, (RelOptRuleOperandChildren)HiveRemoveSqCountCheck.any())})), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveRemoveSqCountCheck.operand(Project.class, (RelOptRuleOperand)HiveRemoveSqCountCheck.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveRemoveSqCountCheck.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0])})), HiveRelFactories.HIVE_BUILDER, "HiveRemoveSqCountCheck");
    }

    public boolean matches(RelOptRuleCall call) {
        RelNode filter = call.rel(4);
        if (filter instanceof HiveFilter) {
            HiveFilter hiveFilter = (HiveFilter)filter;
            return this.isSqlCountCheck(hiveFilter);
        }
        return false;
    }

    private boolean isSqlCountCheck(HiveFilter filter) {
        if (filter.getCondition() instanceof RexCall) {
            RexCall condition = (RexCall)filter.getCondition();
            return condition.getOperator().getName().equals("sq_count_check");
        }
        return false;
    }

    private boolean isAggregateWithoutGbyKeys(Aggregate agg) {
        return agg.getGroupCount() == 0;
    }

    private boolean isAggWithConstantGbyKeys(Aggregate aggregate, RelOptRuleCall call) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList predicates = mq.getPulledUpPredicates(aggregate.getInput());
        if (predicates == null) {
            return false;
        }
        TreeMap<Integer, RexNode> map = new TreeMap<Integer, RexNode>();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            RexInputRef ref = rexBuilder.makeInputRef(aggregate.getInput(), key);
            if (!predicates.constantMap.containsKey((Object)ref)) continue;
            map.put(key, (RexNode)predicates.constantMap.get((Object)ref));
        }
        if (map.isEmpty()) {
            return false;
        }
        int groupCount = aggregate.getGroupCount();
        return groupCount == map.size();
    }

    public void onMatch(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join join = (Join)call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(6);
        Objects.requireNonNull(aggregate);
        if (this.isAggregateWithoutGbyKeys(aggregate) || this.isAggWithConstantGbyKeys(aggregate, call)) {
            HiveJoin newJoin = HiveJoin.getJoin(topJoin.getCluster(), join.getLeft(), topJoin.getRight(), topJoin.getCondition(), topJoin.getJoinType());
            call.transformTo((RelNode)newJoin);
        }
    }
}

