/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ListResourceProcessor
implements CommandProcessor {
    private static final String LIST_COLUMN_NAME = "resource";
    private static final Schema SCHEMA = new Schema();

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        Set<String> s;
        SessionState.ResourceType t;
        SessionState ss = SessionState.get();
        String[] tokens = command.split("\\s+");
        if (tokens.length < 1 || (t = SessionState.find_resource_type(tokens[0])) == null) {
            String message = "Usage: list [" + StringUtils.join((Object[])SessionState.ResourceType.values(), (String)"|") + "] [<value> [<value>]*]";
            throw new CommandProcessorException(message);
        }
        List<String> filter = null;
        if (tokens.length > 1) {
            filter = Arrays.asList(Arrays.copyOfRange(tokens, 1, tokens.length));
        }
        if ((s = ss.list_resource(t, filter)) != null && !s.isEmpty()) {
            ss.out.println(StringUtils.join(s, (String)"\n"));
        }
        return new CommandProcessorResponse(SCHEMA, null);
    }

    @Override
    public void close() throws Exception {
    }

    static {
        SCHEMA.addToFieldSchemas(new FieldSchema(LIST_COLUMN_NAME, "string", null));
        SCHEMA.putToProperties("serialization.null.format", "\\N");
    }
}

