/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivilegeType;

public class RequiredPrivileges {
    private final Set<SQLPrivTypeGrant> privilegeGrantSet = new HashSet<SQLPrivTypeGrant>();

    public void addPrivilege(String priv, boolean withGrant) throws HiveAuthzPluginException {
        SQLPrivTypeGrant privType = SQLPrivTypeGrant.getSQLPrivTypeGrant(priv, withGrant);
        this.addPrivilege(privType);
        this.privilegeGrantSet.add(privType);
        if (withGrant) {
            this.addPrivilege(priv, false);
        }
    }

    public Set<SQLPrivTypeGrant> getRequiredPrivilegeSet() {
        return this.privilegeGrantSet;
    }

    public Collection<SQLPrivTypeGrant> findMissingPrivs(RequiredPrivileges availPrivs) {
        MissingPrivilegeCapturer missingPrivCapturer = new MissingPrivilegeCapturer(this);
        if (availPrivs == null) {
            availPrivs = new RequiredPrivileges();
        }
        if (availPrivs.privilegeGrantSet.contains((Object)SQLPrivTypeGrant.ADMIN_PRIV)) {
            return missingPrivCapturer.getMissingPrivileges();
        }
        for (SQLPrivTypeGrant requiredPriv : this.privilegeGrantSet) {
            if (availPrivs.privilegeGrantSet.contains((Object)requiredPriv)) continue;
            missingPrivCapturer.addMissingPrivilege(requiredPriv);
        }
        return missingPrivCapturer.getMissingPrivileges();
    }

    public void addPrivilege(SQLPrivTypeGrant requiredPriv) {
        this.privilegeGrantSet.add(requiredPriv);
    }

    Set<SQLPrivTypeGrant> getPrivilegeWithGrants() {
        return this.privilegeGrantSet;
    }

    public void addAll(SQLPrivTypeGrant[] inputPrivs) {
        if (inputPrivs == null) {
            return;
        }
        for (SQLPrivTypeGrant privType : inputPrivs) {
            this.addPrivilege(privType);
        }
    }

    class MissingPrivilegeCapturer {
        private final Map<SQLPrivilegeType, SQLPrivTypeGrant> priv2privWithGrant = new HashMap<SQLPrivilegeType, SQLPrivTypeGrant>();

        MissingPrivilegeCapturer(RequiredPrivileges this$0) {
        }

        void addMissingPrivilege(SQLPrivTypeGrant newPrivWGrant) {
            SQLPrivTypeGrant matchingPrivWGrant = this.priv2privWithGrant.get((Object)newPrivWGrant.getPrivType());
            if (matchingPrivWGrant != null && (matchingPrivWGrant.isWithGrant() || !newPrivWGrant.isWithGrant())) {
                return;
            }
            this.priv2privWithGrant.put(newPrivWGrant.getPrivType(), newPrivWGrant);
        }

        Collection<SQLPrivTypeGrant> getMissingPrivileges() {
            return this.priv2privWithGrant.values();
        }
    }
}

