/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderForInsertOnly;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderForMajor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderForMinor;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilderForRebalance;

class CompactionQueryBuilderFactory {
    CompactionQueryBuilderFactory() {
    }

    public CompactionQueryBuilder getCompactionQueryBuilder(CompactionType compactionType, boolean insertOnly) {
        if (compactionType == null) {
            throw new IllegalArgumentException("CompactionQueryBuilder.CompactionType cannot be null");
        }
        if (insertOnly) {
            return new CompactionQueryBuilderForInsertOnly(compactionType);
        }
        switch (compactionType) {
            case MAJOR: {
                return new CompactionQueryBuilderForMajor();
            }
            case MINOR: {
                return new CompactionQueryBuilderForMinor();
            }
            case REBALANCE: {
                return new CompactionQueryBuilderForRebalance();
            }
        }
        throw new IllegalArgumentException(String.format("Compaction cannot be created with type %s", compactionType));
    }
}

