/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;

class ByteTransformerAdapter
extends AbstractTransformerAdapter {
    final ByteObjectInspector columnType;
    final ByteWritable writable;

    public ByteTransformerAdapter(ByteObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new ByteWritable());
    }

    public ByteTransformerAdapter(ByteObjectInspector columnType, AbstractTransformer transformer, ByteWritable writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        Byte transformedValue;
        Byte value = (Byte)this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue.byteValue());
            return this.writable;
        }
        return null;
    }
}

