/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="array_append", value="_FUNC_(array, element) - Returns an array appended by element.", extended="Example:\n  > SELECT _FUNC_(array(1,3,4), 2) FROM src;\n  [1,3,4,2]")
public class GenericUDFArrayAppend
extends AbstractGenericUDFArrayBase {
    private static final String FUNC_NAME = "ARRAY_APPEND";
    private static final int ELEMENT_IDX = 1;

    public GenericUDFArrayAppend() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector defaultOI = super.initialize(arguments);
        this.checkValueAndListElementTypes(this.arrayElementOI, FUNC_NAME, arguments[1], 1);
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object value = arguments[1].get();
        int arrayLength = this.arrayOI.getListLength(array);
        if (arrayLength == 0) {
            return Collections.emptyList();
        }
        if (arrayLength < 0) {
            return null;
        }
        ArrayList<Object> resultArray = new ArrayList<Object>(((ListObjectInspector)this.argumentOIs[0]).getList(array));
        resultArray.add(value);
        return resultArray.stream().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

