/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_except", value="_FUNC_(array1, array2) - Returns an array of the elements in array1 but not in array2.", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4), array(2,3)) FROM src LIMIT 1;\n  [1,4]")
public class GenericUDFArrayExcept
extends AbstractGenericUDFArrayBase {
    static final int ARRAY2_IDX = 1;
    private static final String FUNC_NAME = "ARRAY_EXCEPT";
    static final String ERROR_NOT_COMPARABLE = "Input arrays are not comparable to use ARRAY_EXCEPT udf";

    public GenericUDFArrayExcept() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector defaultOI = super.initialize(arguments);
        this.checkArgCategory(arguments, 1, ObjectInspector.Category.LIST, FUNC_NAME, "array");
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayOI.getListElementObjectInspector(), (ObjectInspector)((ListObjectInspector)arguments[1]).getListElementObjectInspector())) {
            throw new UDFArgumentTypeException(1, ERROR_NOT_COMPARABLE);
        }
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object array2 = arguments[1].get();
        if (array == null) {
            return null;
        }
        if (array2 == null) {
            return null;
        }
        List retArray3 = ((ListObjectInspector)this.argumentOIs[0]).getList(array);
        ArrayList inputArrayCopy = new ArrayList();
        inputArrayCopy.addAll(retArray3);
        inputArrayCopy.removeAll(((ListObjectInspector)this.argumentOIs[1]).getList(arguments[1].get()));
        return inputArrayCopy.stream().distinct().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

