/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.base.Joiner;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@Description(name="array_join", value="_FUNC_(array, delimiter, replaceNull) - concatenate the elements of an array with a specified delimiter", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4), ',') FROM src LIMIT 1;\n  1,2,3,4\n  > SELECT _FUNC_(array(1, 2, NULL, 4), ',',':') FROM src LIMIT 1;\n  1,2,:,4")
public class GenericUDFArrayJoin
extends AbstractGenericUDFArrayBase {
    private static final int SEPARATOR_IDX = 1;
    private static final int REPLACE_NULL_IDX = 2;
    private final Text result = new Text();

    public GenericUDFArrayJoin() {
        super("ARRAY_JOIN", 2, 3, ObjectInspector.Category.PRIMITIVE);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        super.initialize(arguments);
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        if (this.arrayOI.getListLength(array) <= 0) {
            return null;
        }
        List retArray = ((ListObjectInspector)this.argumentOIs[0]).getList(array);
        String separator = arguments[1].get().toString();
        if (arguments.length > 2 && arguments[2].get() != null) {
            this.result.set(Joiner.on((String)separator).useForNull(arguments[2].get().toString()).join((Iterable)retArray));
        } else {
            this.result.set(Joiner.on((String)separator).skipNulls().join((Iterable)retArray));
        }
        return this.result;
    }
}

