/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Description(name="explode", value="_FUNC_(a) - separates the elements of array a into multiple rows, or the elements of a map into multiple rows and columns ")
public class GenericUDTFExplode
extends GenericUDTF {
    private transient ObjectInspector inputOI = null;
    private final transient Object[] forwardListObj = new Object[1];
    private final transient Object[] forwardMapObj = new Object[2];

    @Override
    public void close() throws HiveException {
    }

    @Override
    public StructObjectInspector initialize(ObjectInspector[] args) throws UDFArgumentException {
        if (args.length != 1) {
            throw new UDFArgumentException("explode() takes only one argument");
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<ObjectInspector> fieldOIs = new ArrayList<ObjectInspector>();
        switch (args[0].getCategory()) {
            case LIST: {
                this.inputOI = args[0];
                fieldNames.add("col");
                fieldOIs.add(((ListObjectInspector)this.inputOI).getListElementObjectInspector());
                break;
            }
            case MAP: {
                this.inputOI = args[0];
                fieldNames.add("key");
                fieldNames.add("value");
                fieldOIs.add(((MapObjectInspector)this.inputOI).getMapKeyObjectInspector());
                fieldOIs.add(((MapObjectInspector)this.inputOI).getMapValueObjectInspector());
                break;
            }
            default: {
                throw new UDFArgumentException("explode() takes an array or a map as a parameter");
            }
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    @Override
    public void process(Object[] o) throws HiveException {
        switch (this.inputOI.getCategory()) {
            case LIST: {
                ListObjectInspector listOI = (ListObjectInspector)this.inputOI;
                List list = listOI.getList(o[0]);
                if (list == null) {
                    return;
                }
                for (Object r : list) {
                    this.forwardListObj[0] = r;
                    this.forward(this.forwardListObj);
                }
                break;
            }
            case MAP: {
                MapObjectInspector mapOI = (MapObjectInspector)this.inputOI;
                Map map = mapOI.getMap(o[0]);
                if (map == null) {
                    return;
                }
                for (Map.Entry r : map.entrySet()) {
                    this.forwardMapObj[0] = r.getKey();
                    this.forwardMapObj[1] = r.getValue();
                    this.forward(this.forwardMapObj);
                }
                break;
            }
        }
    }

    public String toString() {
        return "explode";
    }
}

