/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class HiveDecimalValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public HiveDecimalValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        HiveDecimal d1 = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
        HiveDecimal d2 = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
        if (d1 != null && d2 != null) {
            return d1.subtract(d2).intValue() > amt;
        }
        return d1 != null || d2 != null;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        HiveDecimal d1 = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)v1, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
        HiveDecimal d2 = PrimitiveObjectInspectorUtils.getHiveDecimal((Object)v2, (PrimitiveObjectInspector)((PrimitiveObjectInspector)this.expressionDef.getOI()));
        if (d1 != null && d2 != null) {
            return d1.equals((Object)d2);
        }
        return d1 == null && d2 == null;
    }
}

