/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.avro.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class UtfTextUtils {
    private static final int TRANSFER_BUFFER_SIZE = 4096;
    private static final Charset UTF_32 = Charset.forName("UTF-32");
    private static final Charset UTF_32BE = Charset.forName("UTF-32BE");
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");

    public static String asString(byte[] bytes, Charset charset) {
        if (charset == null) {
            charset = UtfTextUtils.detectUtfCharset(bytes);
        }
        return UtfTextUtils.skipBOM(new String(bytes, charset));
    }

    public static String readAllBytes(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            input = UtfTextUtils.ensureMarkSupport(input);
            input.mark(4);
            byte[] buffer = new byte[4];
            int bytesRead = UtfTextUtils.fillBuffer(input, buffer);
            input.reset();
            charset = UtfTextUtils.detectUtfCharset0(buffer, bytesRead);
            if (charset == null) {
                throw new IOException("Unsupported UCS-4 variant (neither UTF-32BE nor UTF32-LE)");
            }
        }
        InputStreamReader reader = new InputStreamReader(input, charset);
        return UtfTextUtils.readAllChars(reader);
    }

    private static InputStream ensureMarkSupport(InputStream input) {
        if (input.markSupported()) {
            return input;
        }
        return new BufferedInputStream(input);
    }

    private static int fillBuffer(InputStream in, byte[] buf) throws IOException {
        int bytesRead;
        int offset = 0;
        for (int remaining = buf.length; remaining > 0 && (bytesRead = in.read(buf, offset, remaining)) != -1; remaining -= bytesRead) {
            offset += bytesRead;
        }
        return offset;
    }

    public static String readAllChars(Reader input) throws IOException {
        int charsRead;
        StringBuilder buffer = new StringBuilder();
        char[] charBuffer = new char[4096];
        while ((charsRead = input.read(charBuffer, 0, 4096)) >= 0) {
            buffer.append(charBuffer, 0, charsRead);
        }
        return UtfTextUtils.skipBOM(buffer);
    }

    private static String skipBOM(CharSequence buffer) {
        if (buffer.charAt(0) == '\ufeff') {
            return buffer.subSequence(1, buffer.length()).toString();
        }
        return buffer.toString();
    }

    public static Charset detectUtfCharset(byte[] firstFewBytes) {
        Charset detectedCharset = UtfTextUtils.detectUtfCharset0(firstFewBytes, firstFewBytes.length);
        if (detectedCharset == null) {
            throw new IllegalArgumentException("Unsupported UCS-4 variant (neither UTF-32BE nor UTF32-LE)");
        }
        return detectedCharset;
    }

    private static Charset detectUtfCharset0(byte[] firstFewBytes, int numBytes) {
        int quad = UtfTextUtils.quad(firstFewBytes, numBytes);
        int word = quad >>> 16;
        if (numBytes > 3 && (quad == 65279 || quad == -131072)) {
            return UTF_32;
        }
        if (numBytes > 3 && (quad == 65534 || quad == -16842752)) {
            return null;
        }
        if (numBytes > 1 && (word == 65279 || word == 65534)) {
            return StandardCharsets.UTF_16;
        }
        if (numBytes > 2 && quad >>> 8 == 0xEFBBBF) {
            return StandardCharsets.UTF_8;
        }
        if (numBytes > 3 && (quad & 0xFFFFFF00) == 0) {
            return UTF_32BE;
        }
        if (numBytes > 3 && (quad & 0xFFFFFF) == 0) {
            return UTF_32LE;
        }
        if (numBytes > 3 && (quad & 0xFFFF00FF) == 0 || (quad & 0xFF00FFFF) == 0) {
            return null;
        }
        if (numBytes > 1 && (word & 0xFF00) == 0) {
            return StandardCharsets.UTF_16BE;
        }
        if (numBytes > 1 && (word & 0xFF) == 0) {
            return StandardCharsets.UTF_16LE;
        }
        return StandardCharsets.UTF_8;
    }

    private static int quad(byte[] bytes, int length) {
        int quad = -1;
        switch (length) {
            default: {
                quad = quad & 0xFFFFFF00 | bytes[3] & 0xFF;
            }
            case 3: {
                quad = quad & 0xFFFF00FF | (bytes[2] & 0xFF) << 8;
            }
            case 2: {
                quad = quad & 0xFF00FFFF | (bytes[1] & 0xFF) << 16;
            }
            case 1: {
                quad = quad & 0xFFFFFF | (bytes[0] & 0xFF) << 24;
            }
            case 0: 
        }
        return quad;
    }
}

