/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum IsolationLevel {
    SERIALIZABLE,
    SNAPSHOT;


    public static IsolationLevel fromName(String levelName) {
        Preconditions.checkArgument(levelName != null, "Invalid isolation level: null");
        try {
            return IsolationLevel.valueOf(levelName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid isolation level: %s", levelName), e);
        }
    }
}

