/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.io.Encoder;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.BaseWriteBuilder;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;

public class InternalWriter<T>
implements MetricsAwareDatumWriter<T> {
    private ValueWriter<T> writer = null;

    public static <D> InternalWriter<D> create(Schema schema) {
        return new InternalWriter(schema);
    }

    InternalWriter(Schema schema) {
        this.setSchema(schema);
    }

    @Override
    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroSchemaVisitor.visit(schema, new WriteBuilder());
    }

    @Override
    public void write(T datum, Encoder out) throws IOException {
        this.writer.write(datum, out);
    }

    @Override
    public Stream<FieldMetrics> metrics() {
        return this.writer.metrics();
    }

    private static class WriteBuilder
    extends BaseWriteBuilder {
        private WriteBuilder() {
        }

        @Override
        protected ValueWriter<?> createRecordWriter(List<ValueWriter<?>> fields) {
            return ValueWriters.struct(fields);
        }

        @Override
        protected ValueWriter<?> fixedWriter(int length) {
            return ValueWriters.fixedBuffers(length);
        }
    }
}

