/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import java.util.List;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PositionDeletesScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class IcebergCompactionUtil {
    private IcebergCompactionUtil() {
    }

    public static boolean shouldIncludeForCompaction(Table table, String partitionPath, ContentFile<?> file) {
        return !table.spec().isPartitioned() || partitionPath == null && file.specId() != table.spec().specId() || partitionPath != null && table.specs().get(file.specId()).partitionToPath(file.partition()).equals(partitionPath);
    }

    public static boolean shouldIncludeForCompaction(Table table, String partitionPath, ContentFile<?> file, long fileSizeThreshold) {
        return IcebergCompactionUtil.shouldIncludeForCompaction(table, partitionPath, file) && (fileSizeThreshold == -1L || file.fileSizeInBytes() < fileSizeThreshold);
    }

    public static List<DataFile> getDataFiles(Table table, String partitionPath, long fileSizeThreshold) {
        CloseableIterable fileScanTasks = ((TableScan)table.newScan().useSnapshot(table.currentSnapshot().snapshotId()).ignoreResiduals()).planFiles();
        CloseableIterable<FileScanTask> filteredFileScanTasks = CloseableIterable.filter(fileScanTasks, t -> {
            DataFile file = (DataFile)t.asFileScanTask().file();
            return IcebergCompactionUtil.shouldIncludeForCompaction(table, partitionPath, file, fileSizeThreshold);
        });
        return Lists.newArrayList(CloseableIterable.transform(filteredFileScanTasks, t -> (DataFile)t.file()));
    }

    public static List<DeleteFile> getDeleteFiles(Table table, String partitionPath) {
        Table deletesTable = MetadataTableUtils.createMetadataTableInstance(table, MetadataTableType.POSITION_DELETES);
        CloseableIterable deletesScanTasks = deletesTable.newBatchScan().planFiles();
        CloseableIterable<ScanTask> filteredDeletesScanTasks = CloseableIterable.filter(deletesScanTasks, t -> {
            DeleteFile file = (DeleteFile)((PositionDeletesScanTask)t).file();
            return IcebergCompactionUtil.shouldIncludeForCompaction(table, partitionPath, file);
        });
        return Lists.newArrayList(CloseableIterable.transform(filteredDeletesScanTasks, t -> (DeleteFile)((PositionDeletesScanTask)t).file()));
    }
}

