/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.io.IOException;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.responses.ImmutableLoadViewResponse;
import org.apache.iceberg.rest.responses.LoadViewResponse;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewMetadataParser;

public class LoadViewResponseParser {
    private static final String METADATA_LOCATION = "metadata-location";
    private static final String METADATA = "metadata";
    private static final String CONFIG = "config";

    private LoadViewResponseParser() {
    }

    public static String toJson(LoadViewResponse response) {
        return LoadViewResponseParser.toJson(response, false);
    }

    public static String toJson(LoadViewResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> LoadViewResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(LoadViewResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != response, "Invalid load view response: null");
        gen.writeStartObject();
        gen.writeStringField(METADATA_LOCATION, response.metadataLocation());
        gen.writeFieldName(METADATA);
        ViewMetadataParser.toJson(response.metadata(), gen);
        if (!response.config().isEmpty()) {
            JsonUtil.writeStringMap(CONFIG, response.config(), gen);
        }
        gen.writeEndObject();
    }

    public static LoadViewResponse fromJson(String json) {
        return JsonUtil.parse(json, LoadViewResponseParser::fromJson);
    }

    public static LoadViewResponse fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse load view response from null object");
        String metadataLocation = JsonUtil.getString(METADATA_LOCATION, json);
        ViewMetadata metadata = ViewMetadataParser.fromJson(JsonUtil.get(METADATA, json));
        if (null == metadata.metadataFileLocation()) {
            metadata = ViewMetadata.buildFrom(metadata).setMetadataLocation(metadataLocation).build();
        }
        ImmutableLoadViewResponse.Builder builder = ImmutableLoadViewResponse.builder().metadataLocation(metadataLocation).metadata(metadata);
        if (json.has(CONFIG)) {
            builder.config(JsonUtil.getStringMap(CONFIG, json));
        }
        return builder.build();
    }
}

