/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;

class PrimitiveWrapper<T>
implements VariantPrimitive<T> {
    private static final byte NULL_HEADER = VariantUtil.primitiveHeader(0);
    private static final byte TRUE_HEADER = VariantUtil.primitiveHeader(1);
    private static final byte FALSE_HEADER = VariantUtil.primitiveHeader(2);
    private static final byte INT8_HEADER = VariantUtil.primitiveHeader(3);
    private static final byte INT16_HEADER = VariantUtil.primitiveHeader(4);
    private static final byte INT32_HEADER = VariantUtil.primitiveHeader(5);
    private static final byte INT64_HEADER = VariantUtil.primitiveHeader(6);
    private static final byte FLOAT_HEADER = VariantUtil.primitiveHeader(14);
    private static final byte DOUBLE_HEADER = VariantUtil.primitiveHeader(7);
    private static final byte DATE_HEADER = VariantUtil.primitiveHeader(11);
    private static final byte TIMESTAMPTZ_HEADER = VariantUtil.primitiveHeader(12);
    private static final byte TIMESTAMPNTZ_HEADER = VariantUtil.primitiveHeader(13);
    private static final byte DECIMAL4_HEADER = VariantUtil.primitiveHeader(8);
    private static final byte DECIMAL8_HEADER = VariantUtil.primitiveHeader(9);
    private static final byte DECIMAL16_HEADER = VariantUtil.primitiveHeader(10);
    private static final byte BINARY_HEADER = VariantUtil.primitiveHeader(15);
    private static final byte STRING_HEADER = VariantUtil.primitiveHeader(16);
    private final PhysicalType type;
    private final T value;
    private ByteBuffer buffer = null;

    PrimitiveWrapper(PhysicalType type, T value) {
        this.type = value instanceof Boolean && (type == PhysicalType.BOOLEAN_TRUE || type == PhysicalType.BOOLEAN_FALSE) ? ((Boolean)value != false ? PhysicalType.BOOLEAN_TRUE : PhysicalType.BOOLEAN_FALSE) : type;
        this.value = value;
    }

    @Override
    public PhysicalType type() {
        return this.type;
    }

    @Override
    public T get() {
        return this.value;
    }

    @Override
    public int sizeInBytes() {
        switch (this.type()) {
            case NULL: 
            case BOOLEAN_TRUE: 
            case BOOLEAN_FALSE: {
                return 1;
            }
            case INT8: {
                return 2;
            }
            case INT16: {
                return 3;
            }
            case INT32: 
            case DATE: 
            case FLOAT: {
                return 5;
            }
            case INT64: 
            case DOUBLE: 
            case TIMESTAMPTZ: 
            case TIMESTAMPNTZ: {
                return 9;
            }
            case DECIMAL4: {
                return 6;
            }
            case DECIMAL8: {
                return 10;
            }
            case DECIMAL16: {
                return 18;
            }
            case BINARY: {
                return 5 + ((ByteBuffer)this.value).remaining();
            }
            case STRING: {
                if (null == this.buffer) {
                    this.buffer = ByteBuffer.wrap(((String)this.value).getBytes(StandardCharsets.UTF_8));
                }
                return 5 + this.buffer.remaining();
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + this.type());
    }

    @Override
    public int writeTo(ByteBuffer outBuffer, int offset) {
        Preconditions.checkArgument(outBuffer.order() == ByteOrder.LITTLE_ENDIAN, "Invalid byte order: big endian");
        switch (this.type()) {
            case NULL: {
                outBuffer.put(offset, NULL_HEADER);
                return 1;
            }
            case BOOLEAN_TRUE: {
                outBuffer.put(offset, TRUE_HEADER);
                return 1;
            }
            case BOOLEAN_FALSE: {
                outBuffer.put(offset, FALSE_HEADER);
                return 1;
            }
            case INT8: {
                outBuffer.put(offset, INT8_HEADER);
                outBuffer.put(offset + 1, (Byte)this.value);
                return 2;
            }
            case INT16: {
                outBuffer.put(offset, INT16_HEADER);
                outBuffer.putShort(offset + 1, (Short)this.value);
                return 3;
            }
            case INT32: {
                outBuffer.put(offset, INT32_HEADER);
                outBuffer.putInt(offset + 1, (Integer)this.value);
                return 5;
            }
            case INT64: {
                outBuffer.put(offset, INT64_HEADER);
                outBuffer.putLong(offset + 1, (Long)this.value);
                return 9;
            }
            case FLOAT: {
                outBuffer.put(offset, FLOAT_HEADER);
                outBuffer.putFloat(offset + 1, ((Float)this.value).floatValue());
                return 5;
            }
            case DOUBLE: {
                outBuffer.put(offset, DOUBLE_HEADER);
                outBuffer.putDouble(offset + 1, (Double)this.value);
                return 9;
            }
            case DATE: {
                outBuffer.put(offset, DATE_HEADER);
                outBuffer.putInt(offset + 1, (Integer)this.value);
                return 5;
            }
            case TIMESTAMPTZ: {
                outBuffer.put(offset, TIMESTAMPTZ_HEADER);
                outBuffer.putLong(offset + 1, (Long)this.value);
                return 9;
            }
            case TIMESTAMPNTZ: {
                outBuffer.put(offset, TIMESTAMPNTZ_HEADER);
                outBuffer.putLong(offset + 1, (Long)this.value);
                return 9;
            }
            case DECIMAL4: {
                BigDecimal decimal4 = (BigDecimal)this.value;
                outBuffer.put(offset, DECIMAL4_HEADER);
                outBuffer.put(offset + 1, (byte)decimal4.scale());
                outBuffer.putInt(offset + 2, decimal4.unscaledValue().intValueExact());
                return 6;
            }
            case DECIMAL8: {
                BigDecimal decimal8 = (BigDecimal)this.value;
                outBuffer.put(offset, DECIMAL8_HEADER);
                outBuffer.put(offset + 1, (byte)decimal8.scale());
                outBuffer.putLong(offset + 2, decimal8.unscaledValue().longValueExact());
                return 10;
            }
            case DECIMAL16: {
                BigDecimal decimal16 = (BigDecimal)this.value;
                byte padding = (byte)(decimal16.signum() < 0 ? 255 : 0);
                byte[] bytes = decimal16.unscaledValue().toByteArray();
                outBuffer.put(offset, DECIMAL16_HEADER);
                outBuffer.put(offset + 1, (byte)decimal16.scale());
                for (int i = 0; i < 16; ++i) {
                    if (i < bytes.length) {
                        outBuffer.put(offset + 2 + i, bytes[bytes.length - i - 1]);
                        continue;
                    }
                    outBuffer.put(offset + 2 + i, padding);
                }
                return 18;
            }
            case BINARY: {
                ByteBuffer binary = (ByteBuffer)this.value;
                outBuffer.put(offset, BINARY_HEADER);
                outBuffer.putInt(offset + 1, binary.remaining());
                VariantUtil.writeBufferAbsolute(outBuffer, offset + 5, binary);
                return 5 + binary.remaining();
            }
            case STRING: {
                if (null == this.buffer) {
                    this.buffer = ByteBuffer.wrap(((String)this.value).getBytes(StandardCharsets.UTF_8));
                }
                outBuffer.put(offset, STRING_HEADER);
                outBuffer.putInt(offset + 1, this.buffer.remaining());
                VariantUtil.writeBufferAbsolute(outBuffer, offset + 5, this.buffer);
                return 5 + this.buffer.remaining();
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + this.type());
    }

    public int hashCode() {
        return VariantPrimitive.hash(this);
    }

    public boolean equals(Object other) {
        return VariantPrimitive.equals(this, other);
    }

    public String toString() {
        return VariantPrimitive.asString(this);
    }
}

