/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.v1.typesystem.types.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.v1.model.typedef.AttributeDefinition;
import org.apache.atlas.v1.model.typedef.ClassTypeDefinition;
import org.apache.atlas.v1.model.typedef.Multiplicity;
import org.apache.atlas.v1.model.typedef.TraitTypeDefinition;

public class TypesUtil {
    public static ClassTypeDefinition createClassTypeDef(String name, String description, Set<String> superTypes, AttributeDefinition ... attributes) {
        ClassTypeDefinition ret = new ClassTypeDefinition(name, description, "1.0", Arrays.asList(attributes), superTypes);
        return ret;
    }

    public static ClassTypeDefinition createClassTypeDef(String name, String description, String typeVersion, Set<String> superTypes, AttributeDefinition ... attributes) {
        ClassTypeDefinition ret = new ClassTypeDefinition(name, description, typeVersion, Arrays.asList(attributes), superTypes);
        return ret;
    }

    public static TraitTypeDefinition createTraitTypeDef(String name, String description, Set<String> superTypes, AttributeDefinition ... attributes) {
        return TypesUtil.createTraitTypeDef(name, description, superTypes, Arrays.asList(attributes));
    }

    public static TraitTypeDefinition createTraitTypeDef(String name, String description, String typeVersion, Set<String> superTypes, AttributeDefinition ... attributes) {
        return TypesUtil.createTraitTypeDef(name, description, typeVersion, superTypes, Arrays.asList(attributes));
    }

    public static TraitTypeDefinition createTraitTypeDef(String name, String description, Set<String> superTypes, List<AttributeDefinition> attributes) {
        TraitTypeDefinition ret = new TraitTypeDefinition(name, description, "1.0", attributes, superTypes);
        return ret;
    }

    public static TraitTypeDefinition createTraitTypeDef(String name, String description, String typeVersion, Set<String> superTypes, List<AttributeDefinition> attributes) {
        TraitTypeDefinition ret = new TraitTypeDefinition(name, description, typeVersion, attributes, superTypes);
        return ret;
    }

    public static AttributeDefinition createUniqueRequiredAttrDef(String name, String dataTypeName) {
        AttributeDefinition ret = new AttributeDefinition(name, dataTypeName, Multiplicity.REQUIRED, false, true, true, null, null);
        return ret;
    }

    public static AttributeDefinition createRequiredAttrDef(String name, String dataTypeName) {
        AttributeDefinition ret = new AttributeDefinition(name, dataTypeName, Multiplicity.REQUIRED, false, false, true, null, null);
        return ret;
    }

    public static AttributeDefinition createOptionalAttrDef(String name, String dataTypeName) {
        AttributeDefinition ret = new AttributeDefinition(name, dataTypeName, Multiplicity.OPTIONAL, false, false, true, null, null);
        return ret;
    }

    public static class Pair<L, R> {
        public L left;
        public R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public static <L, R> Pair<L, R> of(L left, R right) {
            return new Pair<L, R>(left, right);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair p = (Pair)o;
            return Objects.equals(this.left, p.left) && Objects.equals(this.right, p.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }
    }
}

