/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.AsyncRequesterBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.AsyncServerBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncRequester;
import org.apache.hc.core5.http.impl.bootstrap.HttpAsyncServer;
import org.apache.hc.core5.http.impl.nio.BufferedData;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.RequestChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.HttpDateGenerator;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolStats;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class AsyncReverseProxyExample {
    private static boolean quiet;
    private static final AtomicLong COUNT;
    private static final int INIT_BUFFER_SIZE = 4096;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: <hostname[:port]> [listener port] [--quiet]");
            System.exit(1);
        }
        HttpHost targetHost = HttpHost.create((String)args[0]);
        int port = 8080;
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        for (String s : args) {
            if (!"--quiet".equalsIgnoreCase(s)) continue;
            quiet = true;
            break;
        }
        AsyncReverseProxyExample.println("Reverse proxy to " + targetHost);
        IOReactorConfig config = IOReactorConfig.custom().setSoTimeout(1, TimeUnit.MINUTES).build();
        HttpAsyncRequester requester = AsyncRequesterBootstrap.bootstrap().setIOReactorConfig(config).setConnPoolListener((ConnPoolListener)new ConnPoolListener<HttpHost>(){

            public void onLease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
                StringBuilder buf = new StringBuilder();
                buf.append("[proxy->origin] connection leased ").append(route);
                AsyncReverseProxyExample.println(buf.toString());
            }

            public void onRelease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
                StringBuilder buf = new StringBuilder();
                buf.append("[proxy->origin] connection released ").append(route);
                PoolStats totals = connPoolStats.getTotalStats();
                buf.append("; total kept alive: ").append(totals.getAvailable()).append("; ");
                buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
                buf.append(" of ").append(totals.getMax());
                AsyncReverseProxyExample.println(buf.toString());
            }
        }).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                AsyncReverseProxyExample.println("[proxy<-origin] connection " + connection.getLocalAddress() + "->" + connection.getRemoteAddress() + (keepAlive ? " kept alive" : " cannot be kept alive"));
            }
        }).setMaxTotal(100).setDefaultMaxPerRoute(20).create();
        HttpAsyncServer server = AsyncServerBootstrap.bootstrap().setExceptionCallback(e -> e.printStackTrace()).setIOReactorConfig(config).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                AsyncReverseProxyExample.println("[client<-proxy] connection " + connection.getLocalAddress() + "->" + connection.getRemoteAddress() + (keepAlive ? " kept alive" : " cannot be kept alive"));
            }
        }).register("*", () -> new IncomingExchangeHandler(targetHost, requester)).create();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            AsyncReverseProxyExample.println("Reverse proxy shutting down");
            server.close(CloseMode.GRACEFUL);
            requester.close(CloseMode.GRACEFUL);
        }));
        requester.start();
        server.start();
        server.listen((SocketAddress)new InetSocketAddress(port), URIScheme.HTTP);
        AsyncReverseProxyExample.println("Listening on port " + port);
        server.awaitShutdown(TimeValue.MAX_VALUE);
    }

    static void println(String msg) {
        if (!quiet) {
            System.out.println(HttpDateGenerator.INSTANCE.getCurrentDate() + " | " + msg);
        }
    }

    static /* synthetic */ AtomicLong access$000() {
        return COUNT;
    }

    static {
        COUNT = new AtomicLong(0L);
    }

    private static class OutgoingExchangeHandler
    implements AsyncClientExchangeHandler {
        private static final Set<String> HOP_BY_HOP = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TextUtils.toLowerCase((String)"Host"), TextUtils.toLowerCase((String)"Content-Length"), TextUtils.toLowerCase((String)"Transfer-Encoding"), TextUtils.toLowerCase((String)"Connection"), TextUtils.toLowerCase((String)"Keep-Alive"), TextUtils.toLowerCase((String)"Proxy-Authenticate"), TextUtils.toLowerCase((String)"TE"), TextUtils.toLowerCase((String)"Trailer"), TextUtils.toLowerCase((String)"Upgrade"))));
        private final HttpHost targetHost;
        private final AsyncClientEndpoint clientEndpoint;
        private final ProxyExchangeState exchangeState;
        private final ReentrantLock lock;

        OutgoingExchangeHandler(HttpHost targetHost, AsyncClientEndpoint clientEndpoint, ProxyExchangeState exchangeState) {
            this.targetHost = targetHost;
            this.clientEndpoint = clientEndpoint;
            this.exchangeState = exchangeState;
            this.lock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void produceRequest(RequestChannel channel, HttpContext httpContext) throws HttpException, IOException {
            this.lock.lock();
            try {
                HttpRequest incomingRequest = this.exchangeState.request;
                EntityDetails entityDetails = this.exchangeState.requestEntityDetails;
                BasicHttpRequest outgoingRequest = new BasicHttpRequest(incomingRequest.getMethod(), this.targetHost, incomingRequest.getPath());
                Iterator it = incomingRequest.headerIterator();
                while (it.hasNext()) {
                    Header header = (Header)it.next();
                    if (HOP_BY_HOP.contains(TextUtils.toLowerCase((String)header.getName()))) continue;
                    outgoingRequest.addHeader(header);
                }
                AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " " + outgoingRequest.getMethod() + " " + outgoingRequest.getRequestUri());
                channel.sendRequest((HttpRequest)outgoingRequest, entityDetails, httpContext);
            }
            finally {
                this.lock.unlock();
            }
        }

        public int available() {
            this.lock.lock();
            try {
                int available = this.exchangeState.inBuf != null ? this.exchangeState.inBuf.length() : 0;
                AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " output available: " + available);
                int n = available;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void produce(DataStreamChannel channel) throws IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " produce output");
                this.exchangeState.requestDataChannel = channel;
                if (this.exchangeState.inBuf != null) {
                    int capacity;
                    CapacityChannel capacityChannel;
                    if (this.exchangeState.inBuf.hasData()) {
                        int bytesWritten = this.exchangeState.inBuf.write(channel);
                        AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                    if (this.exchangeState.inputEnd && !this.exchangeState.inBuf.hasData()) {
                        channel.endStream();
                        AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " end of output");
                    }
                    if (!this.exchangeState.inputEnd && (capacityChannel = this.exchangeState.requestCapacityChannel) != null && (capacity = this.exchangeState.inBuf.capacity()) > 0) {
                        AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " input capacity: " + capacity);
                        capacityChannel.update(capacity);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void consumeInformation(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consumeResponse(HttpResponse incomingResponse, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[proxy<-origin] " + this.exchangeState.id + " status " + incomingResponse.getCode());
                if (entityDetails == null) {
                    AsyncReverseProxyExample.println("[proxy<-origin] " + this.exchangeState.id + " end of input");
                }
                BasicHttpResponse outgoingResponse = new BasicHttpResponse(incomingResponse.getCode());
                Iterator it = incomingResponse.headerIterator();
                while (it.hasNext()) {
                    Header header = (Header)it.next();
                    if (HOP_BY_HOP.contains(TextUtils.toLowerCase((String)header.getName()))) continue;
                    outgoingResponse.addHeader(header);
                }
                this.exchangeState.response = outgoingResponse;
                this.exchangeState.responseEntityDetails = entityDetails;
                this.exchangeState.outputEnd = entityDetails == null;
                ResponseChannel responseChannel = this.exchangeState.responseMessageChannel;
                if (responseChannel != null) {
                    responseChannel.sendResponse((HttpResponse)outgoingResponse, entityDetails, httpContext);
                }
                AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " status " + outgoingResponse.getCode());
                if (entityDetails == null) {
                    AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " end of output");
                    this.clientEndpoint.releaseAndReuse();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
            this.lock.lock();
            try {
                int capacity;
                this.exchangeState.responseCapacityChannel = capacityChannel;
                int n = capacity = this.exchangeState.outBuf != null ? this.exchangeState.outBuf.capacity() : 4096;
                if (capacity > 0) {
                    AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " input capacity: " + capacity);
                    capacityChannel.update(capacity);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[proxy<-origin] " + this.exchangeState.id + " " + src.remaining() + " bytes received");
                DataStreamChannel dataChannel = this.exchangeState.responseDataChannel;
                if (dataChannel != null && this.exchangeState.outBuf != null) {
                    int bytesWritten;
                    if (this.exchangeState.outBuf.hasData()) {
                        bytesWritten = this.exchangeState.outBuf.write(dataChannel);
                        AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                    if (!this.exchangeState.outBuf.hasData()) {
                        bytesWritten = dataChannel.write(src);
                        AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                }
                if (src.hasRemaining()) {
                    if (this.exchangeState.outBuf == null) {
                        this.exchangeState.outBuf = new ProxyBuffer(4096);
                    }
                    this.exchangeState.outBuf.put(src);
                }
                int capacity = this.exchangeState.outBuf != null ? this.exchangeState.outBuf.capacity() : 4096;
                AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " input capacity: " + capacity);
                if (dataChannel != null) {
                    dataChannel.requestOutput();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[proxy<-origin] " + this.exchangeState.id + " end of input");
                this.exchangeState.outputEnd = true;
                DataStreamChannel dataChannel = this.exchangeState.responseDataChannel;
                if (!(dataChannel == null || this.exchangeState.outBuf != null && this.exchangeState.outBuf.hasData())) {
                    AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " end of output");
                    dataChannel.endStream();
                    this.clientEndpoint.releaseAndReuse();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void cancel() {
            this.clientEndpoint.releaseAndDiscard();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Exception cause) {
            AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " " + cause.getMessage());
            if (!(cause instanceof ConnectionClosedException)) {
                cause.printStackTrace(System.out);
            }
            this.lock.lock();
            try {
                if (this.exchangeState.response == null) {
                    int status = cause instanceof IOException ? 503 : 500;
                    BasicHttpResponse outgoingResponse = new BasicHttpResponse(status);
                    outgoingResponse.addHeader("Connection", (Object)"close");
                    this.exchangeState.response = outgoingResponse;
                    ByteBuffer msg = StandardCharsets.US_ASCII.encode(CharBuffer.wrap(cause.getMessage()));
                    int contentLen = msg.remaining();
                    this.exchangeState.outBuf = new ProxyBuffer(1024);
                    this.exchangeState.outBuf.put(msg);
                    this.exchangeState.outputEnd = true;
                    AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " status " + outgoingResponse.getCode());
                    try {
                        BasicEntityDetails entityDetails = new BasicEntityDetails((long)contentLen, ContentType.TEXT_PLAIN);
                        this.exchangeState.responseMessageChannel.sendResponse((HttpResponse)outgoingResponse, (EntityDetails)entityDetails, null);
                    }
                    catch (IOException | HttpException throwable) {}
                } else {
                    this.exchangeState.outputEnd = true;
                }
                this.clientEndpoint.releaseAndDiscard();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void releaseResources() {
            this.lock.lock();
            try {
                this.exchangeState.requestDataChannel = null;
                this.exchangeState.responseCapacityChannel = null;
                this.clientEndpoint.releaseAndDiscard();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class IncomingExchangeHandler
    implements AsyncServerExchangeHandler {
        private final HttpHost targetHost;
        private final HttpAsyncRequester requester;
        private final ProxyExchangeState exchangeState;
        private final ReentrantLock lock;

        IncomingExchangeHandler(HttpHost targetHost, HttpAsyncRequester requester) {
            this.targetHost = targetHost;
            this.requester = requester;
            this.exchangeState = new ProxyExchangeState();
            this.lock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(HttpRequest incomingRequest, EntityDetails entityDetails, final ResponseChannel responseChannel, final HttpContext httpContext) throws HttpException, IOException {
            this.lock.lock();
            try {
                Header h;
                AsyncReverseProxyExample.println("[client->proxy] " + this.exchangeState.id + " " + incomingRequest.getMethod() + " " + incomingRequest.getRequestUri());
                this.exchangeState.request = incomingRequest;
                this.exchangeState.requestEntityDetails = entityDetails;
                this.exchangeState.inputEnd = entityDetails == null;
                this.exchangeState.responseMessageChannel = responseChannel;
                if (entityDetails != null && (h = incomingRequest.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h.getValue())) {
                    responseChannel.sendInformation((HttpResponse)new BasicHttpResponse(100), httpContext);
                }
            }
            finally {
                this.lock.unlock();
            }
            AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " request connection to " + this.targetHost);
            this.requester.connect(this.targetHost, Timeout.ofSeconds((long)30L), null, (FutureCallback)new FutureCallback<AsyncClientEndpoint>(){

                public void completed(AsyncClientEndpoint clientEndpoint) {
                    AsyncReverseProxyExample.println("[proxy->origin] " + ((IncomingExchangeHandler)this).exchangeState.id + " connection leased");
                    lock.lock();
                    try {
                        ((IncomingExchangeHandler)this).exchangeState.clientEndpoint = clientEndpoint;
                    }
                    finally {
                        lock.unlock();
                    }
                    clientEndpoint.execute((AsyncClientExchangeHandler)new OutgoingExchangeHandler(targetHost, clientEndpoint, exchangeState), (HttpContext)HttpCoreContext.create());
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(Exception cause) {
                    BasicHttpResponse outgoingResponse = new BasicHttpResponse(503);
                    outgoingResponse.addHeader("Connection", (Object)"close");
                    ByteBuffer msg = StandardCharsets.US_ASCII.encode(CharBuffer.wrap(cause.getMessage()));
                    BasicEntityDetails exEntityDetails = new BasicEntityDetails((long)msg.remaining(), ContentType.TEXT_PLAIN);
                    lock.lock();
                    try {
                        ((IncomingExchangeHandler)this).exchangeState.response = outgoingResponse;
                        ((IncomingExchangeHandler)this).exchangeState.responseEntityDetails = exEntityDetails;
                        ((IncomingExchangeHandler)this).exchangeState.outBuf = new ProxyBuffer(1024);
                        ((IncomingExchangeHandler)this).exchangeState.outBuf.put(msg);
                        ((IncomingExchangeHandler)this).exchangeState.outputEnd = true;
                    }
                    finally {
                        lock.unlock();
                    }
                    AsyncReverseProxyExample.println("[client<-proxy] " + ((IncomingExchangeHandler)this).exchangeState.id + " status " + outgoingResponse.getCode());
                    try {
                        responseChannel.sendResponse((HttpResponse)outgoingResponse, (EntityDetails)exEntityDetails, httpContext);
                    }
                    catch (IOException | HttpException throwable) {
                        // empty catch block
                    }
                }

                public void cancelled() {
                    this.failed(new InterruptedIOException());
                }
            });
        }

        public void updateCapacity(CapacityChannel capacityChannel) throws IOException {
            this.lock.lock();
            try {
                int capacity;
                this.exchangeState.requestCapacityChannel = capacityChannel;
                int n = capacity = this.exchangeState.inBuf != null ? this.exchangeState.inBuf.capacity() : 4096;
                if (capacity > 0) {
                    AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " input capacity: " + capacity);
                    capacityChannel.update(capacity);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(ByteBuffer src) throws IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[client->proxy] " + this.exchangeState.id + " " + src.remaining() + " bytes received");
                DataStreamChannel dataChannel = this.exchangeState.requestDataChannel;
                if (dataChannel != null && this.exchangeState.inBuf != null) {
                    int bytesWritten;
                    if (this.exchangeState.inBuf.hasData()) {
                        bytesWritten = this.exchangeState.inBuf.write(dataChannel);
                        AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                    if (!this.exchangeState.inBuf.hasData()) {
                        bytesWritten = dataChannel.write(src);
                        AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                }
                if (src.hasRemaining()) {
                    if (this.exchangeState.inBuf == null) {
                        this.exchangeState.inBuf = new ProxyBuffer(4096);
                    }
                    this.exchangeState.inBuf.put(src);
                }
                int capacity = this.exchangeState.inBuf != null ? this.exchangeState.inBuf.capacity() : 4096;
                AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " input capacity: " + capacity);
                if (dataChannel != null) {
                    dataChannel.requestOutput();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[client->proxy] " + this.exchangeState.id + " end of input");
                this.exchangeState.inputEnd = true;
                DataStreamChannel dataChannel = this.exchangeState.requestDataChannel;
                if (!(dataChannel == null || this.exchangeState.inBuf != null && this.exchangeState.inBuf.hasData())) {
                    AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " end of output");
                    dataChannel.endStream();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public int available() {
            this.lock.lock();
            try {
                int available = this.exchangeState.outBuf != null ? this.exchangeState.outBuf.length() : 0;
                AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " output available: " + available);
                int n = available;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void produce(DataStreamChannel channel) throws IOException {
            this.lock.lock();
            try {
                AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " produce output");
                this.exchangeState.responseDataChannel = channel;
                if (this.exchangeState.outBuf != null) {
                    int capacity;
                    CapacityChannel capacityChannel;
                    if (this.exchangeState.outBuf.hasData()) {
                        int bytesWritten = this.exchangeState.outBuf.write(channel);
                        AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " " + bytesWritten + " bytes sent");
                    }
                    if (this.exchangeState.outputEnd && !this.exchangeState.outBuf.hasData()) {
                        channel.endStream();
                        AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " end of output");
                    }
                    if (!this.exchangeState.outputEnd && (capacityChannel = this.exchangeState.responseCapacityChannel) != null && (capacity = this.exchangeState.outBuf.capacity()) > 0) {
                        AsyncReverseProxyExample.println("[proxy->origin] " + this.exchangeState.id + " input capacity: " + capacity);
                        capacityChannel.update(capacity);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void failed(Exception cause) {
            AsyncReverseProxyExample.println("[client<-proxy] " + this.exchangeState.id + " " + cause.getMessage());
            if (!(cause instanceof ConnectionClosedException)) {
                cause.printStackTrace(System.out);
            }
            this.lock.lock();
            try {
                if (this.exchangeState.clientEndpoint != null) {
                    this.exchangeState.clientEndpoint.releaseAndDiscard();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void releaseResources() {
            this.lock.lock();
            try {
                this.exchangeState.responseMessageChannel = null;
                this.exchangeState.responseDataChannel = null;
                this.exchangeState.requestCapacityChannel = null;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static class ProxyExchangeState {
        final String id = String.format("%010d", AsyncReverseProxyExample.access$000().getAndIncrement());
        HttpRequest request;
        EntityDetails requestEntityDetails;
        DataStreamChannel requestDataChannel;
        CapacityChannel requestCapacityChannel;
        ProxyBuffer inBuf;
        boolean inputEnd;
        HttpResponse response;
        EntityDetails responseEntityDetails;
        ResponseChannel responseMessageChannel;
        DataStreamChannel responseDataChannel;
        CapacityChannel responseCapacityChannel;
        ProxyBuffer outBuf;
        boolean outputEnd;
        AsyncClientEndpoint clientEndpoint;

        ProxyExchangeState() {
        }
    }

    private static class ProxyBuffer
    extends BufferedData {
        ProxyBuffer(int bufferSize) {
            super(bufferSize);
        }

        int write(DataStreamChannel channel) throws IOException {
            this.setOutputMode();
            if (this.buffer().hasRemaining()) {
                return channel.write(this.buffer());
            }
            return 0;
        }
    }
}

