/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLAccessor;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Objects;
import sun.misc.Unsafe;

public final class InlineSupport {
    private InlineSupport() {
    }

    public static boolean validate(Node node, InlinableField field0, InlinableField field1, InlinableField ... fields) {
        field0.validate(node);
        field1.validate(node);
        for (InlinableField field : fields) {
            field.validate(node);
        }
        return true;
    }

    public static boolean validate(Node node, InlinableField field0, InlinableField field1) {
        field0.validate(node);
        field1.validate(node);
        return true;
    }

    public static boolean validate(Node node, InlinableField field0) {
        field0.validate(node);
        return true;
    }

    public static abstract class InlinableField
    extends UnsafeField {
        final ReferenceField<Node> parentField;

        InlinableField(Class<?> receiverClass, Class<?> declaringClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<?> valueClass) {
            super(receiverClass, declaringClass, declaringLookup, fieldName, valueClass);
            this.parentField = null;
        }

        InlinableField(InlinableField prev, Class<? extends Node> parentClass) {
            super(prev);
            this.parentField = new ReferenceField<Node>((Class<?>)parentClass, (Class<?>)Node.class, DSLAccessor.nodeAccessor().nodeLookup(), "parent", Node.class);
        }

        InlinableField(InlinableField prev) {
            super(prev);
            this.parentField = prev.parentField;
        }

        final Object resolveReceiver(Node node) {
            CompilerAsserts.partialEvaluationConstant(this);
            CompilerAsserts.partialEvaluationConstant(node);
            Node receiver = node;
            if (this.parentField != null) {
                receiver = this.resolveParent(receiver);
            }
            return receiver;
        }

        @ExplodeLoop
        private Node resolveParent(Node node) {
            Node receiver = node;
            while ((receiver = this.parentField.get(receiver)) != null && !this.receiverClass.isInstance(receiver)) {
            }
            return receiver;
        }

        private static String getEnclosingSimpleName(Class<?> c) {
            if (c.getEnclosingClass() != null) {
                return InlinableField.getEnclosingSimpleName(c.getEnclosingClass()) + "." + c.getSimpleName();
            }
            return c.getSimpleName();
        }

        public final boolean validate(Node node) {
            this.validateImpl(this.resolveReceiver(node));
            return true;
        }

        static RuntimeException invalidAccessError(Class<?> expectedClass, Object node) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (node == null) {
                throw new NullPointerException(InlinableField.formatInvalidAccessError(expectedClass, node));
            }
            throw new ClassCastException(InlinableField.formatInvalidAccessError(expectedClass, node));
        }

        private static String formatInvalidAccessError(Class<?> expectedClass, Object node) {
            return String.format("Invalid parameter type passed to updater. Instance of type '%s' expected but was '%s'. Did you pass the wrong node to an execute method of an inlined cached node?", InlinableField.getEnclosingSimpleName(expectedClass), node != null ? InlinableField.getEnclosingSimpleName(node.getClass()) : "null");
        }

        static RuntimeException invalidValue(Class<?> expectedClass, Object value) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            String message = String.format("Invalid parameter type passed to set. Instance of type '%s' expected but was '%s'. ", InlinableField.getEnclosingSimpleName(expectedClass), value != null ? InlinableField.getEnclosingSimpleName(value.getClass()) : "null");
            throw new IllegalArgumentException(message);
        }
    }

    static abstract class VarHandleField {
        private final Class<?> receiverClass;
        private final VarHandle handle;

        VarHandleField(Class<?> receiverClass, Class<?> lookupClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<?> valueClass) {
            try {
                this.receiverClass = receiverClass;
                this.handle = declaringLookup.findVarHandle(lookupClass, fieldName, valueClass);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException(e);
            }
        }

        VarHandleField(VarHandleField prev) {
            this.handle = prev.handle;
            this.receiverClass = prev.receiverClass;
        }

        Class<?> getFieldClass() {
            return this.handle.varType();
        }

        final boolean validateImpl(Object node) {
            if (!this.receiverClass.isInstance(node)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            return true;
        }

        final boolean getBoolean(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final byte getByte(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final short getShort(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final char getChar(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final int getInt(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final float getFloat(Object node) {
            return this.handle.get(node);
        }

        final long getLong(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final double getDouble(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final void setBoolean(Object node, boolean v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setByte(Object node, byte v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setShort(Object node, short v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setChar(Object node, char v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setInt(Object node, int v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setFloat(Object node, float v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setLong(Object node, long v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setDouble(Object node, double v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final void setObject(Object node, Object v) {
            assert (this.validateImpl(node));
            this.handle.set(node, v);
        }

        final Object getObject(Object node) {
            assert (this.validateImpl(node));
            return this.handle.get(node);
        }

        final Object getObjectVolatile(Object node) {
            assert (this.validateImpl(node));
            return this.handle.getVolatile(node);
        }

        final boolean compareAndSetObject(Object node, Object expect, Object update) {
            assert (this.validateImpl(node));
            return this.handle.compareAndSet(node, expect, update);
        }

        public final String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
            b.append("[");
            b.append(this.handle);
            b.append("]");
            return b.toString();
        }
    }

    static abstract class UnsafeField {
        final Class<?> declaringClass;
        final String name;
        final Class<?> receiverClass;
        final long offset;
        final Class<?> fieldClass;
        static final Unsafe U = UnsafeField.getUnsafe();

        UnsafeField(UnsafeField prev) {
            this.offset = prev.offset;
            this.receiverClass = prev.receiverClass;
            this.declaringClass = prev.declaringClass;
            this.name = prev.name;
            this.fieldClass = prev.fieldClass;
        }

        UnsafeField(Class<?> receiverClass, final Class<?> declaringClass, final MethodHandles.Lookup declaringLookup, final String fieldName, Class<?> valueClass) {
            Field field;
            Objects.requireNonNull(receiverClass);
            Objects.requireNonNull(declaringClass);
            Objects.requireNonNull(declaringLookup);
            Objects.requireNonNull(fieldName);
            Objects.requireNonNull(valueClass);
            try {
                this.declaringClass = declaringClass;
                this.name = fieldName;
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        if (declaringLookup == null) {
                            return null;
                        }
                        return declaringClass.getDeclaredField(fieldName);
                    }
                });
                this.fieldClass = field.getType();
            }
            catch (PrivilegedActionException pae) {
                if (pae.getException() instanceof NoSuchFieldException) {
                    throw new IllegalArgumentException(String.format("No such field %s.%s.", declaringClass.getName(), fieldName), pae);
                }
                throw new AssertionError((Object)pae.getException());
            }
            if (!this.fieldClass.isAssignableFrom(valueClass)) {
                throw new IllegalArgumentException(String.format("Expected field type %s, but got %s. ", valueClass.getName(), this.fieldClass.getName()));
            }
            if (!declaringClass.isAssignableFrom(receiverClass)) {
                throw new AssertionError((Object)String.format("Receiver class %s is not assignable to the declaring class %s.", receiverClass.getName(), declaringClass.getName()));
            }
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                throw new IllegalArgumentException("Must not be final field");
            }
            this.receiverClass = receiverClass;
            this.offset = U.objectFieldOffset(field);
        }

        final boolean validateImpl(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            return true;
        }

        final Class<?> getFieldClass() {
            return this.fieldClass;
        }

        final boolean getBoolean(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getBoolean(useNode, this.offset);
        }

        final byte getByte(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getByte(useNode, this.offset);
        }

        final short getShort(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getShort(useNode, this.offset);
        }

        final char getChar(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getChar(useNode, this.offset);
        }

        final int getInt(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getInt(useNode, this.offset);
        }

        final float getFloat(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getFloat(useNode, this.offset);
        }

        final long getLong(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getLong(useNode, this.offset);
        }

        final double getDouble(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getDouble(useNode, this.offset);
        }

        final Object getObject(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getObject(useNode, this.offset);
        }

        final void setBoolean(Object node, boolean v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putBoolean(useNode, this.offset, v);
        }

        final void setByte(Object node, byte v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putByte(useNode, this.offset, v);
        }

        final void setShort(Object node, short v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putShort(useNode, this.offset, v);
        }

        final void setChar(Object node, char v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putChar(useNode, this.offset, v);
        }

        final void setInt(Object node, int v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putInt(useNode, this.offset, v);
        }

        final void setFloat(Object node, float v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putFloat(useNode, this.offset, v);
        }

        final void setLong(Object node, long v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putLong(useNode, this.offset, v);
        }

        final void setDouble(Object node, double v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            U.putDouble(useNode, this.offset, v);
        }

        final void setObject(Object node, Object v) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            if (!this.fieldClass.isInstance(v) && v != null) {
                throw InlinableField.invalidValue(this.fieldClass, v);
            }
            U.putObject(useNode, this.offset, v);
        }

        final Object getObjectVolatile(Object node) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            return U.getObjectVolatile(useNode, this.offset);
        }

        final boolean compareAndSetObject(Object node, Object expect, Object update) {
            if (node == null || !this.receiverClass.isInstance(node)) {
                throw InlinableField.invalidAccessError(this.receiverClass, node);
            }
            Object useNode = this.receiverClass.cast(node);
            if (!this.fieldClass.isInstance(update) && update != null) {
                throw InlinableField.invalidValue(this.fieldClass, update);
            }
            return U.compareAndSwapObject(useNode, this.offset, expect, update);
        }

        private static Unsafe getUnsafe() {
            try {
                return Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                    theUnsafeInstance.setAccessible(true);
                    return (Unsafe)theUnsafeInstance.get(Unsafe.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
                }
            }
        }
    }

    public static final class DoubleField
    extends InlinableField {
        DoubleField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Double.TYPE);
        }

        DoubleField(DoubleField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public DoubleField createParentAccessor(Class<? extends Node> parentClass) {
            return new DoubleField(this, parentClass);
        }

        public double get(Node node) {
            return this.getDouble(this.resolveReceiver(node));
        }

        public void set(Node node, double value) {
            this.setDouble(this.resolveReceiver(node), value);
        }

        public static DoubleField create(MethodHandles.Lookup declaringLookup, String field) {
            return new DoubleField(declaringLookup, field);
        }
    }

    public static final class LongField
    extends InlinableField {
        LongField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Long.TYPE);
        }

        LongField(LongField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public LongField createParentAccessor(Class<? extends Node> parentClass) {
            return new LongField(this, parentClass);
        }

        public long get(Node node) {
            return this.getLong(this.resolveReceiver(node));
        }

        public void set(Node node, long value) {
            this.setLong(this.resolveReceiver(node), value);
        }

        public static LongField create(MethodHandles.Lookup declaringLookup, String field) {
            return new LongField(declaringLookup, field);
        }
    }

    public static final class IntField
    extends InlinableField {
        IntField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Integer.TYPE);
        }

        IntField(IntField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public IntField createParentAccessor(Class<? extends Node> parentClass) {
            return new IntField(this, parentClass);
        }

        public int get(Node node) {
            return this.getInt(this.resolveReceiver(node));
        }

        public void set(Node node, int value) {
            this.setInt(this.resolveReceiver(node), value);
        }

        public static IntField create(MethodHandles.Lookup declaringLookup, String field) {
            return new IntField(declaringLookup, field);
        }
    }

    public static final class FloatField
    extends InlinableField {
        FloatField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Float.TYPE);
        }

        FloatField(FloatField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public FloatField createParentAccessor(Class<? extends Node> parentClass) {
            return new FloatField(this, parentClass);
        }

        public float get(Node node) {
            return this.getFloat(this.resolveReceiver(node));
        }

        public void set(Node node, float value) {
            this.setFloat(this.resolveReceiver(node), value);
        }

        public static FloatField create(MethodHandles.Lookup declaringLookup, String field) {
            return new FloatField(declaringLookup, field);
        }
    }

    public static final class CharField
    extends InlinableField {
        CharField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Character.TYPE);
        }

        CharField(CharField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public CharField createParentAccessor(Class<? extends Node> parentClass) {
            return new CharField(this, parentClass);
        }

        public char get(Node node) {
            return this.getChar(this.resolveReceiver(node));
        }

        public void set(Node node, char value) {
            this.setChar(this.resolveReceiver(node), value);
        }

        public static CharField create(MethodHandles.Lookup declaringLookup, String field) {
            return new CharField(declaringLookup, field);
        }
    }

    public static final class ShortField
    extends InlinableField {
        ShortField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Short.TYPE);
        }

        ShortField(ShortField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public ShortField createParentAccessor(Class<? extends Node> parentClass) {
            return new ShortField(this, parentClass);
        }

        public short get(Node node) {
            return this.getShort(this.resolveReceiver(node));
        }

        public void set(Node node, short value) {
            this.setShort(this.resolveReceiver(node), value);
        }

        public static ShortField create(MethodHandles.Lookup declaringLookup, String field) {
            return new ShortField(declaringLookup, field);
        }
    }

    public static final class ByteField
    extends InlinableField {
        ByteField(MethodHandles.Lookup declaringLookup, String fieldName) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Byte.TYPE);
        }

        ByteField(ByteField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public ByteField createParentAccessor(Class<? extends Node> parentClass) {
            return new ByteField(this, parentClass);
        }

        public byte get(Node node) {
            return this.getByte(this.resolveReceiver(node));
        }

        public void set(Node node, byte value) {
            this.setByte(this.resolveReceiver(node), value);
        }

        public static ByteField create(MethodHandles.Lookup declaringLookup, String field) {
            return new ByteField(declaringLookup, field);
        }
    }

    public static final class BooleanField
    extends InlinableField {
        BooleanField(MethodHandles.Lookup lookup, String fieldName) {
            super(lookup.lookupClass(), lookup.lookupClass(), lookup, fieldName, Boolean.TYPE);
        }

        BooleanField(BooleanField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
        }

        public BooleanField createParentAccessor(Class<? extends Node> parentClass) {
            return new BooleanField(this, parentClass);
        }

        public boolean get(Node node) {
            return this.getBoolean(this.resolveReceiver(node));
        }

        public void set(Node node, boolean value) {
            this.setBoolean(this.resolveReceiver(node), value);
        }

        public static BooleanField create(MethodHandles.Lookup declaringLookup, String field) {
            return new BooleanField(declaringLookup, field);
        }
    }

    public static final class ReferenceField<T>
    extends InlinableField {
        ReferenceField(Class<?> receiverClass, Class<?> lookupFieldClass, MethodHandles.Lookup declaringLookup, String fieldName, Class<T> valueClass) {
            super(receiverClass, lookupFieldClass, declaringLookup, fieldName, valueClass);
        }

        ReferenceField(ReferenceField<T> prev, Class<? extends Node> pclass) {
            super(prev, pclass);
        }

        public ReferenceField<T> createParentAccessor(Class<? extends Node> parentClass) {
            return new ReferenceField<T>(this, parentClass);
        }

        public T get(Node node) {
            return (T)this.getObject(this.resolveReceiver(node));
        }

        public void set(Node node, T value) {
            this.setObject(this.resolveReceiver(node), value);
        }

        public T getVolatile(Node node) {
            return (T)this.getObjectVolatile(this.resolveReceiver(node));
        }

        public boolean compareAndSet(Node node, T expect, T update) {
            return this.compareAndSetObject(this.resolveReceiver(node), expect, update);
        }

        public static <T> ReferenceField<T> create(MethodHandles.Lookup declaringLookup, String field, Class<T> valueClass) {
            Class<?> lookupClass = declaringLookup.lookupClass();
            return new ReferenceField<T>(lookupClass, lookupClass, declaringLookup, field, valueClass);
        }
    }

    public static final class StateField
    extends InlinableField {
        final int bitOffset;
        final int bitLength;
        final int bitMask;

        StateField(MethodHandles.Lookup declaringLookup, String fieldName, int offset, int length) {
            super(declaringLookup.lookupClass(), declaringLookup.lookupClass(), declaringLookup, fieldName, Integer.TYPE);
            this.bitOffset = offset;
            this.bitLength = length;
            this.bitMask = StateField.computeMask(offset, length);
        }

        StateField(StateField prev, int offset, int length) {
            super(prev);
            this.bitOffset = prev.bitOffset + offset;
            this.bitLength = length;
            this.bitMask = StateField.computeMask(this.bitOffset, length);
        }

        StateField(StateField prev, Class<? extends Node> parentClass) {
            super(prev, parentClass);
            this.bitOffset = prev.bitOffset;
            this.bitLength = prev.bitLength;
            this.bitMask = prev.bitMask;
        }

        private static int computeMask(int offset, int length) {
            int mask = 0;
            for (int i = offset; i < offset + length; ++i) {
                mask |= 1 << i;
            }
            return mask;
        }

        public StateField createParentAccessor(Class<? extends Node> parentClass) {
            return new StateField(this, parentClass);
        }

        public StateField subUpdater(int newOffset, int newLength) {
            if (newOffset < 0) {
                throw new IllegalArgumentException("New offset parameter must not be negative.");
            }
            if (newOffset + newLength > this.bitLength) {
                throw new IllegalArgumentException("Illegal new length parameter must not exceed the available bit length.");
            }
            if (newLength <= 0) {
                throw new IllegalArgumentException("Invalid new length.");
            }
            if (newOffset == 0 && newLength == this.bitLength) {
                return this;
            }
            return new StateField(this, newOffset, newLength);
        }

        public int get(Node node) {
            return (this.getInt(this.resolveReceiver(node)) & this.bitMask) >>> this.bitOffset;
        }

        public void set(Node node, int value) {
            assert (this.noBitsLost(value));
            Object receiver = this.resolveReceiver(node);
            int newState = this.getInt(receiver) & ~this.bitMask | value << this.bitOffset & this.bitMask;
            this.setInt(receiver, newState);
        }

        private boolean noBitsLost(int providedBits) {
            int writtenBits = (providedBits << this.bitOffset & this.bitMask) >>> this.bitOffset;
            if (writtenBits != providedBits) {
                throw new IllegalArgumentException(String.format("Bits lost in masked state updater set. Provided bits: 0x%s Written bits: 0x%s. This could indicate a bug in subUpdater indices in the node object inlining logic.", Integer.toHexString(providedBits), Integer.toHexString(writtenBits)));
            }
            return true;
        }

        public static StateField create(MethodHandles.Lookup declaringLookup, String field) {
            return new StateField(declaringLookup, field, 0, 32);
        }
    }

    public static final class InlineTarget {
        private final Class<?> targetClass;
        private final InlinableField[] updaters;

        InlineTarget(Class<?> targetClass, InlinableField[] updaters) {
            this.targetClass = targetClass;
            this.updaters = updaters;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }

        public <T extends InlinableField> T getPrimitive(int index, Class<T> fieldClass) {
            Objects.requireNonNull(fieldClass);
            if (!InlineTarget.isPrimitiveField(fieldClass)) {
                throw InlineTarget.incompatibleAccessError(String.format("Invalid or modified field type. Expected primitive field but got %s.", fieldClass.getName()));
            }
            return (T)((InlinableField)this.get(index, fieldClass));
        }

        public StateField getState(int index, int minimumBits) {
            if (minimumBits <= 0 || minimumBits > 32) {
                throw new IllegalArgumentException("Invalid minimum bits. Expected >= 0 and <= 32 but was " + minimumBits + ".");
            }
            StateField field = this.get(index, StateField.class);
            if (minimumBits > field.bitLength) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected minimum state bits %s, but got %s.", minimumBits, field.bitLength));
            }
            return field;
        }

        public <V> ReferenceField<V> getReference(int index, Class<?> valueClass) {
            Objects.requireNonNull(valueClass);
            ReferenceField reference = this.get(index, ReferenceField.class);
            Class<?> varType = reference.getFieldClass();
            if (!varType.isAssignableFrom(valueClass)) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected reference type %s, but got %s. ", valueClass.getName(), varType.getName()));
            }
            return reference;
        }

        private <T> T get(int index, Class<T> fieldClass) throws IncompatibleClassChangeError {
            if (index >= this.updaters.length) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected number of updaters %s, but got %s. ", index + 1, this.updaters.length));
            }
            if (this.updaters[index].getClass() != fieldClass) {
                throw InlineTarget.incompatibleAccessError(String.format("Expected field type %s, but got %s. ", fieldClass, this.updaters[index].getClass()));
            }
            return fieldClass.cast(this.updaters[index]);
        }

        private static IncompatibleClassChangeError incompatibleAccessError(String detailMessage) {
            return new IncompatibleClassChangeError(String.format("Node inlining specification has changed in an incompatible way. %sRecompilation from source may solve this problem.", detailMessage));
        }

        private static boolean isReferenceField(Class<?> fieldClass) {
            return fieldClass == ReferenceField.class;
        }

        private static boolean isStateField(Class<?> fieldClass) {
            return fieldClass == StateField.class;
        }

        private static boolean isPrimitiveField(Class<?> fieldClass) {
            return !InlineTarget.isReferenceField(fieldClass) && !InlineTarget.isStateField(fieldClass);
        }

        public static InlineTarget create(Class<?> targetClass, InlinableField ... updaters) {
            Objects.requireNonNull(targetClass);
            Objects.requireNonNull(updaters);
            for (InlinableField updater : updaters) {
                Objects.requireNonNull(updater);
            }
            return new InlineTarget(targetClass, updaters);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.PARAMETER})
    public static @interface RequiredFields {
        public RequiredField[] value();
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD})
    public static @interface UnsafeAccessedField {
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.PARAMETER})
    @Repeatable(value=RequiredFields.class)
    public static @interface RequiredField {
        public Class<? extends InlinableField> value();

        public int bits() default 0;

        public Class<?> type() default InlinableField.class;

        public int dimensions() default 0;
    }
}

