/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.LineStringDataType;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;

public class MultiLineStringDataType
implements DataType<MultiLineString> {
    private final LineStringDataType lineStringDataType;
    private final GeometryFactory geometryFactory;

    public MultiLineStringDataType() {
        this(new GeometryFactory());
    }

    public MultiLineStringDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
        this.lineStringDataType = new LineStringDataType(geometryFactory);
    }

    @Override
    public int size(MultiLineString value) {
        int size = 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            size += this.lineStringDataType.size((LineString)value.getGeometryN(i));
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, MultiLineString value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            this.lineStringDataType.write(buffer, p, (LineString)value.getGeometryN(i));
            p += buffer.getInt(p);
        }
    }

    @Override
    public MultiLineString read(ByteBuffer buffer, int position) {
        int size = this.size(buffer, position);
        int limit = position + size;
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        for (int p = position + 4; p < limit; p += this.lineStringDataType.size(buffer, p)) {
            LineString lineString = this.lineStringDataType.read(buffer, p);
            lineStrings.add(lineString);
        }
        return this.geometryFactory.createMultiLineString((LineString[])lineStrings.toArray(LineString[]::new));
    }
}

