/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.zip.DataFormatException;
import org.apache.baremaps.openstreetmap.model.Blob;
import org.apache.baremaps.openstreetmap.model.DataBlock;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Info;
import org.apache.baremaps.openstreetmap.model.Member;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.osm.binary.Osmformat;
import org.apache.baremaps.stream.StreamException;

public class DataBlockReader {
    private final Blob blob;
    private final Osmformat.PrimitiveBlock primitiveBlock;
    private final int granularity;
    private final int dateGranularity;
    private final long latOffset;
    private final long lonOffset;
    private final String[] stringTable;

    public DataBlockReader(Blob blob) throws DataFormatException, InvalidProtocolBufferException {
        this.blob = blob;
        this.primitiveBlock = Osmformat.PrimitiveBlock.parseFrom(blob.data());
        this.granularity = this.primitiveBlock.getGranularity();
        this.latOffset = this.primitiveBlock.getLatOffset();
        this.lonOffset = this.primitiveBlock.getLonOffset();
        this.dateGranularity = this.primitiveBlock.getDateGranularity();
        this.stringTable = new String[this.primitiveBlock.getStringtable().getSCount()];
        for (int i = 0; i < this.stringTable.length; ++i) {
            this.stringTable[i] = this.primitiveBlock.getStringtable().getS(i).toStringUtf8();
        }
    }

    public DataBlock read() {
        ArrayList<Node> denseNodes = new ArrayList<Node>();
        this.readDenseNodes(denseNodes::add);
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.readNodes(nodes::add);
        ArrayList<Way> ways = new ArrayList<Way>();
        this.readWays(ways::add);
        ArrayList<Relation> relations = new ArrayList<Relation>();
        this.readRelations(relations::add);
        return new DataBlock(this.blob, denseNodes, nodes, ways, relations);
    }

    public void readEntities(Consumer<Entity> consumer) {
        this.readDenseNodes(consumer::accept);
        this.readNodes(consumer::accept);
        this.readWays(consumer::accept);
        this.readRelations(consumer::accept);
    }

    public void readDenseNodes(Consumer<Node> consumer) {
        for (Osmformat.PrimitiveGroup group : this.primitiveBlock.getPrimitivegroupList()) {
            Osmformat.DenseNodes denseNodes = group.getDense();
            long id = 0L;
            long lat = 0L;
            long lon = 0L;
            long timestamp = 0L;
            long changeset = 0L;
            int sid = 0;
            int uid = 0;
            int j = 0;
            for (int i = 0; i < denseNodes.getIdCount(); ++i) {
                id = denseNodes.getId(i) + id;
                Osmformat.DenseInfo denseInfo = denseNodes.getDenseinfo();
                int version = denseInfo.getVersion(i);
                uid = denseInfo.getUid(i) + uid;
                sid = denseInfo.getUserSid(i) + sid;
                timestamp = denseInfo.getTimestamp(i) + timestamp;
                changeset = denseInfo.getChangeset(i) + changeset;
                lat = denseNodes.getLat(i) + lat;
                lon = denseNodes.getLon(i) + lon;
                HashMap<String, Object> tags = new HashMap<String, Object>();
                if (denseNodes.getKeysValsCount() > 0) {
                    while (denseNodes.getKeysVals(j) != 0) {
                        int keyid = denseNodes.getKeysVals(j++);
                        int valid = denseNodes.getKeysVals(j++);
                        tags.put(this.getString(keyid), this.getString(valid));
                    }
                    ++j;
                }
                Info info = new Info(version, this.getTimestamp(timestamp), changeset, uid);
                consumer.accept(new Node(id, info, tags, this.getLon(lon), this.getLat(lat)));
            }
        }
    }

    public void readNodes(Consumer<Node> consumer) {
        for (Osmformat.PrimitiveGroup group : this.primitiveBlock.getPrimitivegroupList()) {
            for (Osmformat.Node node : group.getNodesList()) {
                long id = node.getId();
                int version = node.getInfo().getVersion();
                LocalDateTime timestamp = this.getTimestamp(node.getInfo().getTimestamp());
                long changeset = node.getInfo().getChangeset();
                int uid = node.getInfo().getUid();
                HashMap<String, Object> tags = new HashMap<String, Object>();
                for (int t = 0; t < node.getKeysList().size(); ++t) {
                    tags.put(this.getString(node.getKeysList().get(t)), this.getString(node.getKeysList().get(t)));
                }
                double lon = this.getLon(node.getLon());
                double lat = this.getLat(node.getLat());
                Info info = new Info(version, timestamp, changeset, uid);
                consumer.accept(new Node(id, info, tags, lon, lat));
            }
        }
    }

    public void readWays(Consumer<Way> consumer) {
        for (Osmformat.PrimitiveGroup group : this.primitiveBlock.getPrimitivegroupList()) {
            for (Osmformat.Way way : group.getWaysList()) {
                long id = way.getId();
                int version = way.getInfo().getVersion();
                LocalDateTime timestamp = this.getTimestamp(way.getInfo().getTimestamp());
                long changeset = way.getInfo().getChangeset();
                int uid = way.getInfo().getUid();
                Map<String, Object> tags = this.getTags(way.getKeysList(), way.getValsList());
                long nid = 0L;
                ArrayList<Long> nodes = new ArrayList<Long>();
                for (int index = 0; index < way.getRefsCount(); ++index) {
                    nodes.add(nid += way.getRefs(index));
                }
                Info info = new Info(version, timestamp, changeset, uid);
                consumer.accept(new Way((Long)id, info, tags, nodes));
            }
        }
    }

    public void readRelations(Consumer<Relation> consumer) {
        for (Osmformat.PrimitiveGroup group : this.primitiveBlock.getPrimitivegroupList()) {
            for (Osmformat.Relation relation : group.getRelationsList()) {
                long id = relation.getId();
                int version = relation.getInfo().getVersion();
                LocalDateTime timestamp = this.getTimestamp(relation.getInfo().getTimestamp());
                long changeset = relation.getInfo().getChangeset();
                int uid = relation.getInfo().getUid();
                Map<String, Object> tags = this.getTags(relation.getKeysList(), relation.getValsList());
                long mid = 0L;
                ArrayList<Member> members = new ArrayList<Member>();
                for (int j = 0; j < relation.getMemidsCount(); ++j) {
                    String role = this.getString(relation.getRolesSid(j));
                    Member.MemberType type = this.type(relation.getTypes(j));
                    members.add(new Member(mid += relation.getMemids(j), type, role));
                }
                Info info = new Info(version, timestamp, changeset, uid);
                consumer.accept(new Relation((Long)id, info, tags, members));
            }
        }
    }

    private Member.MemberType type(Osmformat.Relation.MemberType type) {
        switch (type) {
            case NODE: {
                return Member.MemberType.NODE;
            }
            case WAY: {
                return Member.MemberType.WAY;
            }
            case RELATION: {
                return Member.MemberType.RELATION;
            }
        }
        throw new UnsupportedOperationException();
    }

    private double getLat(long lat) {
        return (double)((long)this.granularity * lat + this.latOffset) * 1.0E-9;
    }

    private double getLon(long lon) {
        return (double)((long)this.granularity * lon + this.lonOffset) * 1.0E-9;
    }

    private LocalDateTime getTimestamp(long timestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli((long)this.dateGranularity * timestamp), TimeZone.getDefault().toZoneId());
    }

    private Map<String, Object> getTags(List<Integer> keys, List<Integer> vals) {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        for (int t = 0; t < keys.size(); ++t) {
            tags.put(this.getString(keys.get(t)), this.getString(vals.get(t)));
        }
        return tags;
    }

    private String getString(int id) {
        return this.stringTable[id];
    }

    public static DataBlock read(Blob blob) {
        try {
            return new DataBlockReader(blob).read();
        }
        catch (InvalidProtocolBufferException | DataFormatException e) {
            throw new StreamException(e);
        }
    }
}

