/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.apache.baremaps.database.schema.AbstractDataTable;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowImpl;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;

public class PostgresDataTable
extends AbstractDataTable {
    private final DataSource dataSource;
    private final DataRowType rowType;

    public PostgresDataTable(DataSource dataSource, DataRowType rowType) {
        this.dataSource = dataSource;
        this.rowType = rowType;
    }

    public PostgresIterator iterator() {
        return new PostgresIterator();
    }

    @Override
    public Stream<DataRow> stream() {
        PostgresIterator iterator = this.iterator();
        Spliterator<DataRow> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<DataRow> stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(iterator::close);
    }

    /*
     * Exception decompiling
     */
    @Override
    public long sizeAsLong() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public DataRowType rowType() {
        return this.rowType;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean add(DataRow row) {
        String query = PostgresDataTable.insert(this.rowType);
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(query);
                try {
                    this.setParameters(statement, row);
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addAll(Collection<? extends DataRow> rows) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(PostgresDataTable.insert(this.rowType));
                try {
                    for (DataRow dataRow : rows) {
                        this.setParameters(statement, dataRow);
                        statement.addBatch();
                    }
                    statement.executeBatch();
                    bl = true;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setParameters(PreparedStatement statement, DataRow row) throws SQLException {
        for (int i = 1; i <= this.rowType.columns().size(); ++i) {
            Object value = row.get(this.rowType.columns().get(i - 1).name());
            if (value instanceof Geometry) {
                Geometry geometry = (Geometry)value;
                statement.setBytes(i, GeometryUtils.serialize(geometry));
                continue;
            }
            statement.setObject(i, value);
        }
    }

    protected static String select(DataRowType rowType) {
        List<String> columns = rowType.columns().stream().map(column -> {
            if (column.type().binding().isAssignableFrom(Geometry.class)) {
                return String.format("st_asewkb(\"%s\") AS \"%s\"", column.name(), column.name());
            }
            return String.format("\"%s\"", column.name());
        }).toList();
        return "SELECT " + String.join((CharSequence)", ", columns) + " FROM \"" + rowType.name() + "\"";
    }

    protected static String insert(DataRowType rowType) {
        List<String> columns = rowType.columns().stream().map(column -> String.format("\"%s\"", column.name())).toList();
        List<String> values = rowType.columns().stream().map(column -> "?").toList();
        return "INSERT INTO \"" + rowType.name() + "\" (" + String.join((CharSequence)", ", columns) + ") VALUES (" + String.join((CharSequence)", ", values) + ")";
    }

    protected String count(DataRowType rowType) {
        return String.format("SELECT COUNT(*) FROM \"%s\"", rowType.name());
    }

    public class PostgresIterator
    implements Iterator<DataRow>,
    AutoCloseable {
        private Connection connection;
        private Statement statement;
        private ResultSet resultSet;
        private boolean hasNext;

        public PostgresIterator() {
            try {
                this.connection = PostgresDataTable.this.dataSource.getConnection();
                this.statement = this.connection.createStatement();
                this.resultSet = this.statement.executeQuery(PostgresDataTable.select(PostgresDataTable.this.rowType));
                this.hasNext = this.resultSet.next();
            }
            catch (SQLException e) {
                this.close();
                throw new RuntimeException("Error while initializing SQL query iterator", e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.close();
            }
            return this.hasNext;
        }

        @Override
        public DataRow next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            try {
                ArrayList<Object> values = new ArrayList<Object>();
                for (int i = 0; i < PostgresDataTable.this.rowType.columns().size(); ++i) {
                    DataColumn column = PostgresDataTable.this.rowType.columns().get(i);
                    if (column.type().binding().isAssignableFrom(Geometry.class)) {
                        values.add(GeometryUtils.deserialize(this.resultSet.getBytes(i + 1)));
                        continue;
                    }
                    values.add(this.resultSet.getObject(i + 1));
                }
                this.hasNext = this.resultSet.next();
                return new DataRowImpl(PostgresDataTable.this.rowType, values);
            }
            catch (SQLException e) {
                this.close();
                throw new RuntimeException("Error while fetching the next result", e);
            }
        }

        @Override
        public void close() {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Error while closing resources", e);
            }
        }
    }
}

