/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileEntry;
import org.apache.baremaps.tilestore.TileStoreException;

public interface TileStore
extends AutoCloseable {
    public ByteBuffer read(TileCoord var1) throws TileStoreException;

    default public List<ByteBuffer> read(List<TileCoord> tileCoords) throws TileStoreException {
        ArrayList<ByteBuffer> blobs = new ArrayList<ByteBuffer>();
        for (TileCoord tileCoord : tileCoords) {
            blobs.add(this.read(tileCoord));
        }
        return blobs;
    }

    public void write(TileCoord var1, ByteBuffer var2) throws TileStoreException;

    default public void write(List<TileEntry> entries) throws TileStoreException {
        for (TileEntry entry : entries) {
            this.write(entry.getTileCoord(), entry.getByteBuffer());
        }
    }

    public void delete(TileCoord var1) throws TileStoreException;

    default public void delete(List<TileCoord> tileCoords) throws TileStoreException {
        for (TileCoord tileCoord : tileCoords) {
            this.delete(tileCoord);
        }
    }
}

