/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.vectortile;

import java.nio.ByteBuffer;
import org.apache.baremaps.vectortile.Layer;
import org.apache.baremaps.vectortile.Tile;
import org.apache.baremaps.vectortile.VectorTileEncoder;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;

public class VectorTileFunctions {
    public static final int MOVE_TO = 1;
    public static final int LINE_TO = 2;
    public static final int CLOSE_PATH = 7;

    public static Geometry asVectorTileGeom(Geometry geometry, Geometry envelope, int extent, int buffer, boolean clipGeom) {
        Envelope envelopeInternal = envelope.getEnvelopeInternal();
        double scaleX = (double)extent / envelopeInternal.getWidth();
        double scaleY = (double)extent / envelopeInternal.getHeight();
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.translate(-envelopeInternal.getMinX(), -envelopeInternal.getMinY());
        affineTransformation.scale(scaleX, -scaleY);
        affineTransformation.translate(0.0, (double)extent);
        Geometry scaledGeometry = affineTransformation.transform(geometry);
        if (clipGeom) {
            return VectorTileFunctions.clipToTile(scaledGeometry, extent, buffer);
        }
        return scaledGeometry;
    }

    public static Geometry fromVectorTileGeom(Geometry geometry, Geometry envelope, int extent) {
        Envelope envelopeInternal = envelope.getEnvelopeInternal();
        double scaleX = (double)extent / envelopeInternal.getWidth();
        double scaleY = (double)extent / envelopeInternal.getHeight();
        AffineTransformation affineTransformation = new AffineTransformation();
        affineTransformation.translate(0.0, (double)(-extent));
        affineTransformation.scale(1.0 / scaleX, -1.0 / scaleY);
        affineTransformation.translate(envelopeInternal.getMinX(), envelopeInternal.getMinY());
        return affineTransformation.transform(geometry);
    }

    public static ByteBuffer asVectorTile(Tile vectorTile) {
        return new VectorTileEncoder().encodeTile(vectorTile).toByteString().asReadOnlyByteBuffer();
    }

    public static ByteBuffer asVectorTileLayer(Layer layer) {
        return new VectorTileEncoder().encodeLayer(layer).toByteString().asReadOnlyByteBuffer();
    }

    private static Geometry clipToTile(Geometry geometry, int extent, int buffer) {
        Envelope envelope = new Envelope((double)(-buffer), (double)(extent + buffer), (double)(-buffer), (double)(extent + buffer));
        GeometryFactory geometryFactory = new GeometryFactory();
        Geometry tile = geometryFactory.toGeometry(envelope);
        return geometry.intersection(tile);
    }

    public static boolean isClockWise(Geometry geometry) {
        return Orientation.isCCW((Coordinate[])geometry.getCoordinates());
    }
}

